/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer;

import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.api.metrics.HollowMetricsCollector;
import com.netflix.hollow.api.metrics.HollowProducerMetrics;
import com.netflix.hollow.api.producer.AbstractHollowProducer;
import com.netflix.hollow.api.producer.HollowProducerListener;
import com.netflix.hollow.api.producer.ProducerListenerSupport;
import com.netflix.hollow.api.producer.ProducerOptionalBlobPartConfig;
import com.netflix.hollow.api.producer.VersionMinterWithCounter;
import com.netflix.hollow.api.producer.enforcer.BasicSingleProducerEnforcer;
import com.netflix.hollow.api.producer.enforcer.SingleProducerEnforcer;
import com.netflix.hollow.api.producer.fs.HollowFilesystemBlobStager;
import com.netflix.hollow.api.producer.listener.HollowProducerEventListener;
import com.netflix.hollow.api.producer.validation.ValidatorListener;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.util.HollowObjectHashCodeFinder;
import com.netflix.hollow.core.write.HollowBlobWriter;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.objectmapper.HollowObjectMapper;
import com.netflix.hollow.core.write.objectmapper.RecordPrimaryKey;
import com.netflix.hollow.tools.compact.HollowCompactor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class HollowProducer
extends AbstractHollowProducer {
    @Deprecated
    public HollowProducer(Publisher publisher, Announcer announcer) {
        super(publisher, announcer);
    }

    protected HollowProducer(Builder<?> b) {
        super(b);
    }

    @Override
    public HollowProducerMetrics getMetrics() {
        return super.getMetrics();
    }

    @Override
    public void initializeDataModel(Class<?> ... classes) {
        super.initializeDataModel(classes);
    }

    @Override
    public void initializeDataModel(HollowSchema ... schemas) {
        super.initializeDataModel(schemas);
    }

    @Override
    public ReadState restore(long versionDesired, HollowConsumer.BlobRetriever blobRetriever) {
        return super.restore(versionDesired, blobRetriever);
    }

    @Override
    public HollowWriteStateEngine getWriteEngine() {
        return super.getWriteEngine();
    }

    @Override
    public HollowObjectMapper getObjectMapper() {
        return super.getObjectMapper();
    }

    @Override
    public boolean enablePrimaryProducer(boolean doEnable) {
        return super.enablePrimaryProducer(doEnable);
    }

    public long runCycle(Populator task) {
        return this.runCycle(null, task);
    }

    public long runCompactionCycle(HollowCompactor.CompactionConfig config) {
        HollowCompactor compactor;
        if (config != null && this.readStates.hasCurrent() && (compactor = new HollowCompactor(this.getWriteEngine(), this.readStates.current().getStateEngine(), config)).needsCompaction()) {
            return this.runCycle(newState -> compactor.compact());
        }
        return Long.MIN_VALUE;
    }

    @Override
    public void addListener(HollowProducerListener listener) {
        super.addListener(listener);
    }

    @Override
    public void addListener(HollowProducerEventListener listener) {
        super.addListener(listener);
    }

    @Override
    public void removeListener(HollowProducerListener listener) {
        super.removeListener(listener);
    }

    @Override
    public void removeListener(HollowProducerEventListener listener) {
        super.removeListener(listener);
    }

    public static Builder<?> withPublisher(Publisher publisher) {
        Builder builder = new Builder();
        return builder.withPublisher(publisher);
    }

    public static class Incremental
    extends AbstractHollowProducer {
        protected Incremental(Builder<?> b) {
            super(b);
        }

        @Override
        public ReadState restore(long versionDesired, HollowConsumer.BlobRetriever blobRetriever) {
            return super.hardRestore(versionDesired, blobRetriever);
        }

        public long runIncrementalCycle(IncrementalPopulator task) {
            return this.runCycle(task, null);
        }

        public static interface IncrementalWriteState {
            public void addOrModify(Object var1);

            public void addIfAbsent(Object var1);

            public void delete(Object var1);

            public void delete(RecordPrimaryKey var1);
        }

        @FunctionalInterface
        public static interface IncrementalPopulator {
            public void populate(IncrementalWriteState var1) throws Exception;
        }
    }

    public static abstract class BlobStorageCleaner {
        public void clean(Blob.Type blobType) {
            switch (blobType) {
                case SNAPSHOT: {
                    this.cleanSnapshots();
                    break;
                }
                case DELTA: {
                    this.cleanDeltas();
                    break;
                }
                case REVERSE_DELTA: {
                    this.cleanReverseDeltas();
                }
            }
        }

        public abstract void cleanSnapshots();

        public abstract void cleanDeltas();

        public abstract void cleanReverseDeltas();
    }

    public static class Builder<B extends Builder<B>> {
        BlobStager stager;
        BlobCompressor compressor;
        File stagingDir;
        Publisher publisher;
        Announcer announcer;
        List<HollowProducerEventListener> eventListeners = new ArrayList<HollowProducerEventListener>();
        VersionMinter versionMinter = new VersionMinterWithCounter();
        Executor snapshotPublishExecutor = null;
        int numStatesBetweenSnapshots = 0;
        boolean focusHoleFillInFewestShards = false;
        long targetMaxTypeShardSize = 0x1000000L;
        HollowMetricsCollector<HollowProducerMetrics> metricsCollector;
        BlobStorageCleaner blobStorageCleaner = new AbstractHollowProducer.DummyBlobStorageCleaner();
        SingleProducerEnforcer singleProducerEnforcer = new BasicSingleProducerEnforcer();
        HollowObjectHashCodeFinder hashCodeFinder = null;
        boolean doIntegrityCheck = true;
        ProducerOptionalBlobPartConfig optionalPartConfig = null;

        public B withBlobStager(BlobStager stager) {
            this.stager = stager;
            return (B)this;
        }

        public B withBlobCompressor(BlobCompressor compressor) {
            this.compressor = compressor;
            return (B)this;
        }

        public B withOptionalPartConfig(ProducerOptionalBlobPartConfig optionalPartConfig) {
            this.optionalPartConfig = optionalPartConfig;
            return (B)this;
        }

        public B withBlobStagingDir(File stagingDir) {
            this.stagingDir = stagingDir;
            return (B)this;
        }

        public B withPublisher(Publisher publisher) {
            this.publisher = publisher;
            return (B)this;
        }

        public B withAnnouncer(Announcer announcer) {
            this.announcer = announcer;
            return (B)this;
        }

        public B withListener(HollowProducerEventListener listener) {
            if (!ProducerListenerSupport.isValidListener(listener)) {
                throw new IllegalArgumentException("Listener does not implement a recognized event listener type: " + listener);
            }
            this.eventListeners.add(listener);
            return (B)this;
        }

        public B withListeners(HollowProducerEventListener ... listeners) {
            for (HollowProducerEventListener listener : listeners) {
                if (!ProducerListenerSupport.isValidListener(listener)) {
                    throw new IllegalArgumentException("Listener does not implement a recognized event listener type: " + listener);
                }
                this.eventListeners.add(listener);
            }
            return (B)this;
        }

        public B withValidator(ValidatorListener validator) {
            return this.withListener(validator);
        }

        public B withValidators(ValidatorListener ... validators) {
            return this.withListeners(validators);
        }

        public B withListener(HollowProducerListener listener) {
            return this.withListener((HollowProducerEventListener)listener);
        }

        public B withListeners(HollowProducerListener ... listeners) {
            return this.withListeners((HollowProducerEventListener[])listeners);
        }

        public B withVersionMinter(VersionMinter versionMinter) {
            this.versionMinter = versionMinter;
            return (B)this;
        }

        public B withSnapshotPublishExecutor(Executor executor) {
            this.snapshotPublishExecutor = executor;
            return (B)this;
        }

        public B withNumStatesBetweenSnapshots(int numStatesBetweenSnapshots) {
            this.numStatesBetweenSnapshots = numStatesBetweenSnapshots;
            return (B)this;
        }

        public B withTargetMaxTypeShardSize(long targetMaxTypeShardSize) {
            this.targetMaxTypeShardSize = targetMaxTypeShardSize;
            return (B)this;
        }

        public B withFocusHoleFillInFewestShards(boolean focusHoleFillInFewestShards) {
            this.focusHoleFillInFewestShards = focusHoleFillInFewestShards;
            return (B)this;
        }

        public B withMetricsCollector(HollowMetricsCollector<HollowProducerMetrics> metricsCollector) {
            this.metricsCollector = metricsCollector;
            return (B)this;
        }

        public B withBlobStorageCleaner(BlobStorageCleaner blobStorageCleaner) {
            this.blobStorageCleaner = blobStorageCleaner;
            return (B)this;
        }

        public B withSingleProducerEnforcer(SingleProducerEnforcer singleProducerEnforcer) {
            this.singleProducerEnforcer = singleProducerEnforcer;
            return (B)this;
        }

        public B noSingleProducerEnforcer() {
            this.singleProducerEnforcer = null;
            return (B)this;
        }

        @Deprecated
        public B withHashCodeFinder(HollowObjectHashCodeFinder hashCodeFinder) {
            this.hashCodeFinder = hashCodeFinder;
            return (B)this;
        }

        public B noIntegrityCheck() {
            this.doIntegrityCheck = false;
            return (B)this;
        }

        protected void checkArguments() {
            if (this.stager != null && this.compressor != null) {
                throw new IllegalArgumentException("Both a custom BlobStager and BlobCompressor were specified -- please specify only one of these.");
            }
            if (this.stager != null && this.stagingDir != null) {
                throw new IllegalArgumentException("Both a custom BlobStager and a staging directory were specified -- please specify only one of these.");
            }
            if (this.stager != null && this.optionalPartConfig != null) {
                throw new IllegalArgumentException("Both a custom BlobStager and an optional blob part config were specified -- please specify only one of these.");
            }
            if (this.stager == null) {
                BlobCompressor compressor = this.compressor != null ? this.compressor : BlobCompressor.NO_COMPRESSION;
                File stagingDir = this.stagingDir != null ? this.stagingDir : new File(System.getProperty("java.io.tmpdir"));
                this.stager = new HollowFilesystemBlobStager(stagingDir.toPath(), compressor, this.optionalPartConfig);
            }
        }

        public HollowProducer build() {
            this.checkArguments();
            return new HollowProducer(this);
        }

        public Incremental buildIncremental() {
            this.checkArguments();
            return new Incremental(this);
        }
    }

    public static interface Announcer {
        public void announce(long var1);

        default public void announce(long stateVersion, Map<String, String> metadata) {
            this.announce(stateVersion);
        }
    }

    public static abstract class Blob {
        protected final long fromVersion;
        protected final long toVersion;
        protected final Type type;
        protected final ProducerOptionalBlobPartConfig optionalPartConfig;

        protected Blob(long fromVersion, long toVersion, Type type) {
            this(fromVersion, toVersion, type, null);
        }

        protected Blob(long fromVersion, long toVersion, Type type, ProducerOptionalBlobPartConfig optionalPartConfig) {
            this.fromVersion = fromVersion;
            this.toVersion = toVersion;
            this.type = type;
            this.optionalPartConfig = optionalPartConfig;
        }

        protected abstract void write(HollowBlobWriter var1) throws IOException;

        public abstract InputStream newInputStream() throws IOException;

        public InputStream newOptionalPartInputStream(String partName) throws IOException {
            throw new UnsupportedOperationException("The provided HollowProducer.Blob implementation does not support optional blob parts");
        }

        public Path getOptionalPartPath(String partName) {
            throw new UnsupportedOperationException("The provided HollowProducer.Blob implementation does not support optional blob parts");
        }

        public abstract void cleanup();

        @Deprecated
        public File getFile() {
            throw new UnsupportedOperationException("File is not available");
        }

        public Path getPath() {
            throw new UnsupportedOperationException("Path is not available");
        }

        public Type getType() {
            return this.type;
        }

        public long getFromVersion() {
            return this.fromVersion;
        }

        public long getToVersion() {
            return this.toVersion;
        }

        public ProducerOptionalBlobPartConfig getOptionalPartConfig() {
            return this.optionalPartConfig;
        }

        public static enum Type {
            SNAPSHOT("snapshot"),
            DELTA("delta"),
            REVERSE_DELTA("reversedelta");

            public final String prefix;

            private Type(String prefix) {
                this.prefix = prefix;
            }
        }
    }

    public static interface Publisher {
        public void publish(Blob var1);
    }

    public static interface BlobCompressor {
        public static final BlobCompressor NO_COMPRESSION = new BlobCompressor(){

            @Override
            public OutputStream compress(OutputStream os) {
                return os;
            }

            @Override
            public InputStream decompress(InputStream is) {
                return is;
            }
        };

        public OutputStream compress(OutputStream var1);

        public InputStream decompress(InputStream var1);
    }

    public static interface BlobStager {
        public Blob openSnapshot(long var1);

        public Blob openDelta(long var1, long var3);

        public Blob openReverseDelta(long var1, long var3);
    }

    public static interface ReadState {
        public long getVersion();

        public HollowReadStateEngine getStateEngine();
    }

    public static interface WriteState {
        public int add(Object var1) throws IllegalStateException;

        public HollowObjectMapper getObjectMapper() throws IllegalStateException;

        public HollowWriteStateEngine getStateEngine() throws IllegalStateException;

        public ReadState getPriorState() throws IllegalStateException;

        public long getVersion() throws IllegalStateException;
    }

    @FunctionalInterface
    public static interface Populator {
        public void populate(WriteState var1) throws Exception;
    }

    public static interface VersionMinter {
        public long mint();
    }

    public static final class NotPrimaryMidCycleException
    extends IllegalStateException {
        NotPrimaryMidCycleException(String message) {
            super(message);
        }
    }

    public static final class ChecksumValidationException
    extends IllegalStateException {
        private static final long serialVersionUID = -4399719849669674206L;

        ChecksumValidationException(Blob.Type type) {
            super(type.name() + " checksum invalid");
        }
    }
}

