/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer;

import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.core.index.HollowPrimaryKeyIndex;
import com.netflix.hollow.core.memory.ThreadSafeBitSet;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.objectmapper.RecordPrimaryKey;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecord;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecordDumper;
import com.netflix.hollow.tools.traverse.TransitiveSetTraverser;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

@Deprecated
public class HollowIncrementalCyclePopulator
implements HollowProducer.Populator {
    public static final Object DELETE_RECORD = new Object();
    private final double threadsPerCpu;
    private final Map<RecordPrimaryKey, Object> mutations;

    HollowIncrementalCyclePopulator(Map<RecordPrimaryKey, Object> mutations, double threadsPerCpu) {
        this.mutations = mutations;
        this.threadsPerCpu = threadsPerCpu;
    }

    @Override
    public void populate(HollowProducer.WriteState newState) throws Exception {
        newState.getStateEngine().addAllObjectsFromPreviousCycle();
        this.removeRecords(newState);
        this.addRecords(newState);
    }

    private void removeRecords(HollowProducer.WriteState newState) {
        if (newState.getPriorState() != null) {
            Set<String> types = this.findTypesWithRemovedRecords(newState.getPriorState());
            Map<String, BitSet> recordsToRemove = this.markRecordsToRemove(newState.getPriorState(), types);
            this.removeRecordsFromNewState(newState, recordsToRemove);
        }
    }

    private Set<String> findTypesWithRemovedRecords(HollowProducer.ReadState readState) {
        HashSet<String> typesWithRemovedRecords = new HashSet<String>();
        for (RecordPrimaryKey key : this.mutations.keySet()) {
            HollowTypeReadState typeState;
            if (typesWithRemovedRecords.contains(key.getType()) || (typeState = readState.getStateEngine().getTypeState(key.getType())) == null) continue;
            typesWithRemovedRecords.add(key.getType());
        }
        return typesWithRemovedRecords;
    }

    private Map<String, BitSet> markRecordsToRemove(HollowProducer.ReadState priorState, Collection<String> types) {
        HollowReadStateEngine priorStateEngine = priorState.getStateEngine();
        HashMap<String, BitSet> recordsToRemove = new HashMap<String, BitSet>();
        for (String type : types) {
            recordsToRemove.put(type, this.markTypeRecordsToRemove(priorStateEngine, type));
        }
        TransitiveSetTraverser.addTransitiveMatches(priorStateEngine, recordsToRemove);
        TransitiveSetTraverser.removeReferencedOutsideClosure(priorStateEngine, recordsToRemove);
        return recordsToRemove;
    }

    private BitSet markTypeRecordsToRemove(HollowReadStateEngine priorStateEngine, String type) {
        HollowTypeReadState priorReadState = priorStateEngine.getTypeState(type);
        HollowSchema schema = priorReadState.getSchema();
        int populatedOrdinals = priorReadState.getPopulatedOrdinals().length();
        if (schema.getSchemaType() == HollowSchema.SchemaType.OBJECT) {
            HollowPrimaryKeyIndex idx = new HollowPrimaryKeyIndex(priorStateEngine, ((HollowObjectSchema)schema).getPrimaryKey());
            ThreadSafeBitSet typeRecordsToRemove = new ThreadSafeBitSet(14, populatedOrdinals);
            SimultaneousExecutor executor = new SimultaneousExecutor(this.threadsPerCpu, this.getClass(), "mark-type-records-to-remove");
            for (Map.Entry<RecordPrimaryKey, Object> entry : this.mutations.entrySet()) {
                executor.execute(() -> {
                    int priorOrdinal;
                    if (((RecordPrimaryKey)entry.getKey()).getType().equals(type) && (priorOrdinal = idx.getMatchingOrdinal(((RecordPrimaryKey)entry.getKey()).getKey())) != -1) {
                        if (entry.getValue() instanceof AddIfAbsent) {
                            ((AddIfAbsent)entry.getValue()).wasFound = true;
                        } else {
                            typeRecordsToRemove.set(priorOrdinal);
                        }
                    }
                });
            }
            try {
                executor.awaitSuccessfulCompletion();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return typeRecordsToRemove.toBitSet();
        }
        return new BitSet(populatedOrdinals);
    }

    private void removeRecordsFromNewState(HollowProducer.WriteState newState, Map<String, BitSet> recordsToRemove) {
        for (Map.Entry<String, BitSet> removalEntry : recordsToRemove.entrySet()) {
            HollowTypeWriteState writeState = newState.getStateEngine().getTypeState(removalEntry.getKey());
            BitSet typeRecordsToRemove = removalEntry.getValue();
            int ordinalToRemove = typeRecordsToRemove.nextSetBit(0);
            while (ordinalToRemove != -1) {
                writeState.removeOrdinalFromThisCycle(ordinalToRemove);
                ordinalToRemove = typeRecordsToRemove.nextSetBit(ordinalToRemove + 1);
            }
        }
    }

    private void addRecords(HollowProducer.WriteState newState) {
        ArrayList<Map.Entry<RecordPrimaryKey, Object>> entryList = new ArrayList<Map.Entry<RecordPrimaryKey, Object>>(this.mutations.entrySet());
        AtomicInteger nextMutation = new AtomicInteger(0);
        SimultaneousExecutor executor = new SimultaneousExecutor(this.threadsPerCpu, this.getClass(), "add-records");
        for (int i = 0; i < executor.getCorePoolSize(); ++i) {
            executor.execute(() -> {
                FlatRecordDumper flatRecordDumper = null;
                int currentMutationIdx = nextMutation.getAndIncrement();
                while (currentMutationIdx < entryList.size()) {
                    Object currentMutation = ((Map.Entry)entryList.get(currentMutationIdx)).getValue();
                    if (currentMutation instanceof AddIfAbsent) {
                        AddIfAbsent aia = (AddIfAbsent)currentMutation;
                        currentMutation = aia.wasFound ? DELETE_RECORD : aia.obj;
                    }
                    if (currentMutation != DELETE_RECORD) {
                        if (currentMutation instanceof FlatRecord) {
                            if (flatRecordDumper == null) {
                                flatRecordDumper = new FlatRecordDumper(newState.getStateEngine());
                            }
                            flatRecordDumper.dump((FlatRecord)currentMutation);
                        } else {
                            newState.add(currentMutation);
                        }
                    }
                    currentMutationIdx = nextMutation.getAndIncrement();
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static final class AddIfAbsent {
        private final Object obj;
        private boolean wasFound;

        public AddIfAbsent(Object obj) {
            this.obj = obj;
            this.wasFound = false;
        }
    }
}

