/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.objects.provider;

import com.netflix.hollow.api.custom.HollowTypeAPI;
import com.netflix.hollow.api.objects.HollowRecord;
import com.netflix.hollow.api.objects.delegate.HollowCachedDelegate;
import com.netflix.hollow.api.objects.provider.HollowFactory;
import com.netflix.hollow.api.objects.provider.HollowObjectProvider;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.HollowTypeStateListener;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HollowObjectCacheProvider<T>
extends HollowObjectProvider<T>
implements HollowTypeStateListener {
    private static final Logger log = Logger.getLogger(HollowObjectCacheProvider.class.getName());
    private final List<T> cachedItems;
    private HollowFactory<T> factory;
    private HollowTypeAPI typeAPI;
    private HollowTypeReadState typeReadState;

    public HollowObjectCacheProvider(HollowTypeDataAccess typeDataAccess, HollowTypeAPI typeAPI, HollowFactory<T> factory) {
        this(typeDataAccess, typeAPI, factory, null);
    }

    public HollowObjectCacheProvider(HollowTypeDataAccess typeDataAccess, HollowTypeAPI typeAPI, HollowFactory<T> factory, HollowObjectCacheProvider<T> previous) {
        if (typeDataAccess != null) {
            PopulatedOrdinalListener listener = typeDataAccess.getTypeState().getListener(PopulatedOrdinalListener.class);
            BitSet populatedOrdinals = listener.getPopulatedOrdinals();
            BitSet previousOrdinals = listener.getPreviousOrdinals();
            int length = Math.max(populatedOrdinals.length(), previousOrdinals.length());
            ArrayList<T> arr = new ArrayList<T>(length);
            for (int ordinal = 0; ordinal < length; ++ordinal) {
                while (ordinal >= arr.size()) {
                    arr.add(null);
                }
                if (previous != null && previousOrdinals.get(ordinal) && populatedOrdinals.get(ordinal)) {
                    T cached = previous.getHollowObject(ordinal);
                    arr.set(ordinal, cached);
                    if (!(cached instanceof HollowRecord)) continue;
                    ((HollowCachedDelegate)((HollowRecord)cached).getDelegate()).updateTypeAPI(typeAPI);
                    continue;
                }
                if (!populatedOrdinals.get(ordinal)) continue;
                arr.set(ordinal, this.instantiateCachedObject(factory, typeDataAccess, typeAPI, ordinal));
            }
            if (typeDataAccess instanceof HollowTypeReadState) {
                this.factory = factory;
                this.typeAPI = typeAPI;
                this.typeReadState = (HollowTypeReadState)typeDataAccess;
                this.typeReadState.addListener(this);
            }
            this.cachedItems = arr;
        } else {
            this.cachedItems = Collections.emptyList();
        }
    }

    @Override
    public T getHollowObject(int ordinal) {
        return this.cachedItems.get(ordinal);
    }

    public void detach() {
        this.cachedItems.clear();
        this.factory = null;
        this.typeAPI = null;
        this.typeReadState = null;
    }

    @Override
    public void addedOrdinal(int ordinal) {
        if (this.factory == null) {
            return;
        }
        for (int i = this.cachedItems.size(); i <= ordinal; ++i) {
            this.cachedItems.add(null);
        }
        this.cachedItems.set(ordinal, this.instantiateCachedObject(this.factory, this.typeReadState, this.typeAPI, ordinal));
    }

    private T instantiateCachedObject(HollowFactory<T> factory, HollowTypeDataAccess typeDataAccess, HollowTypeAPI typeAPI, int ordinal) {
        try {
            return factory.newCachedHollowObject(typeDataAccess, typeAPI, ordinal);
        }
        catch (Throwable th) {
            log.log(Level.SEVERE, "Cached object instantiation failed", th);
            return null;
        }
    }

    @Override
    public void beginUpdate() {
    }

    @Override
    public void removedOrdinal(int ordinal) {
    }

    @Override
    public void endUpdate() {
    }
}

