/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.objects.delegate;

import com.netflix.hollow.api.objects.delegate.HollowObjectDelegate;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.missing.MissingDataHandler;

public abstract class HollowObjectAbstractDelegate
implements HollowObjectDelegate {
    @Override
    public boolean isNull(int ordinal, String fieldName) {
        try {
            HollowObjectTypeDataAccess dataAccess = this.getTypeDataAccess();
            int fieldIndex = this.getSchema().getPosition(fieldName);
            if (fieldIndex == -1) {
                return this.missingDataHandler().handleIsNull(this.getSchema().getName(), ordinal, fieldName);
            }
            return dataAccess.isNull(ordinal, fieldIndex);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Unable to handle ordinal=%s, fieldName=%s", ordinal, fieldName), ex);
        }
    }

    @Override
    public boolean getBoolean(int ordinal, String fieldName) {
        HollowObjectTypeDataAccess dataAccess = this.getTypeDataAccess();
        int fieldIndex = this.getSchema().getPosition(fieldName);
        Boolean bool = fieldIndex != -1 ? dataAccess.readBoolean(ordinal, fieldIndex) : this.missingDataHandler().handleBoolean(this.getSchema().getName(), ordinal, fieldName);
        return bool == null ? false : bool;
    }

    @Override
    public int getOrdinal(int ordinal, String fieldName) {
        HollowObjectTypeDataAccess dataAccess = this.getTypeDataAccess();
        int fieldIndex = this.getSchema().getPosition(fieldName);
        if (fieldIndex == -1) {
            return this.missingDataHandler().handleReferencedOrdinal(this.getSchema().getName(), ordinal, fieldName);
        }
        return dataAccess.readOrdinal(ordinal, fieldIndex);
    }

    @Override
    public int getInt(int ordinal, String fieldName) {
        HollowObjectTypeDataAccess dataAccess = this.getTypeDataAccess();
        int fieldIndex = this.getSchema().getPosition(fieldName);
        if (fieldIndex == -1) {
            return this.missingDataHandler().handleInt(this.getSchema().getName(), ordinal, fieldName);
        }
        return dataAccess.readInt(ordinal, fieldIndex);
    }

    @Override
    public long getLong(int ordinal, String fieldName) {
        HollowObjectTypeDataAccess dataAccess = this.getTypeDataAccess();
        int fieldIndex = this.getSchema().getPosition(fieldName);
        if (fieldIndex == -1) {
            return this.missingDataHandler().handleLong(this.getSchema().getName(), ordinal, fieldName);
        }
        return dataAccess.readLong(ordinal, fieldIndex);
    }

    @Override
    public float getFloat(int ordinal, String fieldName) {
        HollowObjectTypeDataAccess dataAccess = this.getTypeDataAccess();
        int fieldIndex = this.getSchema().getPosition(fieldName);
        if (fieldIndex == -1) {
            return this.missingDataHandler().handleFloat(this.getSchema().getName(), ordinal, fieldName);
        }
        return dataAccess.readFloat(ordinal, fieldIndex);
    }

    @Override
    public double getDouble(int ordinal, String fieldName) {
        HollowObjectTypeDataAccess dataAccess = this.getTypeDataAccess();
        int fieldIndex = this.getSchema().getPosition(fieldName);
        if (fieldIndex == -1) {
            return this.missingDataHandler().handleDouble(this.getSchema().getName(), ordinal, fieldName);
        }
        return dataAccess.readDouble(ordinal, fieldIndex);
    }

    @Override
    public String getString(int ordinal, String fieldName) {
        HollowObjectTypeDataAccess dataAccess = this.getTypeDataAccess();
        int fieldIndex = this.getSchema().getPosition(fieldName);
        if (fieldIndex == -1) {
            return this.missingDataHandler().handleString(this.getSchema().getName(), ordinal, fieldName);
        }
        return dataAccess.readString(ordinal, fieldIndex);
    }

    @Override
    public boolean isStringFieldEqual(int ordinal, String fieldName, String testValue) {
        HollowObjectTypeDataAccess dataAccess = this.getTypeDataAccess();
        int fieldIndex = this.getSchema().getPosition(fieldName);
        if (fieldIndex == -1) {
            return this.missingDataHandler().handleStringEquals(this.getSchema().getName(), ordinal, fieldName, testValue);
        }
        return dataAccess.isStringFieldEqual(ordinal, fieldIndex, testValue);
    }

    @Override
    public byte[] getBytes(int ordinal, String fieldName) {
        HollowObjectTypeDataAccess dataAccess = this.getTypeDataAccess();
        int fieldIndex = this.getSchema().getPosition(fieldName);
        if (fieldIndex == -1) {
            return this.missingDataHandler().handleBytes(this.getSchema().getName(), ordinal, fieldName);
        }
        return dataAccess.readBytes(ordinal, fieldIndex);
    }

    private MissingDataHandler missingDataHandler() {
        return this.getTypeDataAccess().getDataAccess().getMissingDataHandler();
    }
}

