/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.consumer.metrics;

import com.netflix.hollow.api.consumer.HollowConsumer;
import java.util.List;
import java.util.OptionalLong;

public class ConsumerRefreshMetrics {
    private long durationMillis;
    private boolean isRefreshSuccess;
    private boolean isInitialLoad;
    private HollowConsumer.Blob.BlobType overallRefreshType;
    private UpdatePlanDetails updatePlanDetails;
    private long consecutiveFailures;
    private OptionalLong refreshSuccessAgeMillisOptional;
    private long refreshEndTimeNano;
    private OptionalLong cycleStartTimestamp;

    public long getDurationMillis() {
        return this.durationMillis;
    }

    public boolean getIsRefreshSuccess() {
        return this.isRefreshSuccess;
    }

    public boolean getIsInitialLoad() {
        return this.isInitialLoad;
    }

    public HollowConsumer.Blob.BlobType getOverallRefreshType() {
        return this.overallRefreshType;
    }

    public UpdatePlanDetails getUpdatePlanDetails() {
        return this.updatePlanDetails;
    }

    public long getConsecutiveFailures() {
        return this.consecutiveFailures;
    }

    public OptionalLong getRefreshSuccessAgeMillisOptional() {
        return this.refreshSuccessAgeMillisOptional;
    }

    public long getRefreshEndTimeNano() {
        return this.refreshEndTimeNano;
    }

    public OptionalLong getCycleStartTimestamp() {
        return this.cycleStartTimestamp;
    }

    private ConsumerRefreshMetrics(Builder builder) {
        this.durationMillis = builder.durationMillis;
        this.isRefreshSuccess = builder.isRefreshSuccess;
        this.isInitialLoad = builder.isInitialLoad;
        this.overallRefreshType = builder.overallRefreshType;
        this.updatePlanDetails = builder.updatePlanDetails;
        this.consecutiveFailures = builder.consecutiveFailures;
        this.refreshSuccessAgeMillisOptional = builder.refreshSuccessAgeMillisOptional;
        this.refreshEndTimeNano = builder.refreshEndTimeNano;
        this.cycleStartTimestamp = builder.cycleStartTimestamp;
    }

    public static final class Builder {
        private long durationMillis;
        private boolean isRefreshSuccess;
        private boolean isInitialLoad;
        private HollowConsumer.Blob.BlobType overallRefreshType;
        private UpdatePlanDetails updatePlanDetails;
        private long consecutiveFailures;
        private OptionalLong refreshSuccessAgeMillisOptional = OptionalLong.empty();
        private long refreshEndTimeNano;
        private OptionalLong cycleStartTimestamp = OptionalLong.empty();

        public Builder setDurationMillis(long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public Builder setIsRefreshSuccess(boolean isRefreshSuccess) {
            this.isRefreshSuccess = isRefreshSuccess;
            return this;
        }

        public Builder setIsInitialLoad(boolean isInitialLoad) {
            this.isInitialLoad = isInitialLoad;
            return this;
        }

        public Builder setOverallRefreshType(HollowConsumer.Blob.BlobType overallRefreshType) {
            this.overallRefreshType = overallRefreshType;
            return this;
        }

        public Builder setUpdatePlanDetails(UpdatePlanDetails updatePlanDetails) {
            this.updatePlanDetails = updatePlanDetails;
            return this;
        }

        public Builder setConsecutiveFailures(long consecutiveFailures) {
            this.consecutiveFailures = consecutiveFailures;
            return this;
        }

        public Builder setRefreshSuccessAgeMillisOptional(long refreshSuccessAgeMillis) {
            this.refreshSuccessAgeMillisOptional = OptionalLong.of(refreshSuccessAgeMillis);
            return this;
        }

        public Builder setRefreshEndTimeNano(long refreshEndTimeNano) {
            this.refreshEndTimeNano = refreshEndTimeNano;
            return this;
        }

        public Builder setCycleStartTimestamp(long cycleStartTimestamp) {
            this.cycleStartTimestamp = OptionalLong.of(cycleStartTimestamp);
            return this;
        }

        public ConsumerRefreshMetrics build() {
            return new ConsumerRefreshMetrics(this);
        }
    }

    public static class UpdatePlanDetails {
        long beforeVersion;
        long desiredVersion;
        List<HollowConsumer.Blob.BlobType> transitionSequence;
        int numSuccessfulTransitions;

        public long getBeforeVersion() {
            return this.beforeVersion;
        }

        public long getDesiredVersion() {
            return this.desiredVersion;
        }

        public List<HollowConsumer.Blob.BlobType> getTransitionSequence() {
            return this.transitionSequence;
        }

        public int getNumSuccessfulTransitions() {
            return this.numSuccessfulTransitions;
        }
    }
}

