/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.consumer.metrics;

import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.api.consumer.metrics.ConsumerRefreshMetrics;
import com.netflix.hollow.api.consumer.metrics.RefreshMetricsReporting;
import com.netflix.hollow.api.custom.HollowAPI;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractRefreshMetricsListener
extends HollowConsumer.AbstractRefreshListener
implements RefreshMetricsReporting {
    private static final Logger log = Logger.getLogger(AbstractRefreshMetricsListener.class.getName());
    private OptionalLong lastRefreshTimeNanoOptional = OptionalLong.empty();
    private long refreshStartTimeNano;
    private long consecutiveFailures = 0L;
    private HollowConsumer.Blob.BlobType overallRefreshType;
    private ConsumerRefreshMetrics.UpdatePlanDetails updatePlanDetails;
    ConsumerRefreshMetrics.Builder refreshMetricsBuilder;
    private final Map<Long, Long> cycleVersionStartTimes = new HashMap<Long, Long>();

    @Override
    public void refreshStarted(long currentVersion, long requestedVersion) {
        this.updatePlanDetails = new ConsumerRefreshMetrics.UpdatePlanDetails();
        this.refreshStartTimeNano = System.nanoTime();
        this.refreshMetricsBuilder = new ConsumerRefreshMetrics.Builder();
        this.refreshMetricsBuilder.setIsInitialLoad(currentVersion == Long.MIN_VALUE);
        this.refreshMetricsBuilder.setUpdatePlanDetails(this.updatePlanDetails);
        this.cycleVersionStartTimes.clear();
    }

    @Override
    public void transitionsPlanned(long beforeVersion, long desiredVersion, boolean isSnapshotPlan, List<HollowConsumer.Blob.BlobType> transitionSequence) {
        this.updatePlanDetails.beforeVersion = beforeVersion;
        this.updatePlanDetails.desiredVersion = desiredVersion;
        this.updatePlanDetails.transitionSequence = transitionSequence;
        this.overallRefreshType = isSnapshotPlan ? HollowConsumer.Blob.BlobType.SNAPSHOT : (desiredVersion > beforeVersion ? HollowConsumer.Blob.BlobType.DELTA : HollowConsumer.Blob.BlobType.REVERSE_DELTA);
        this.refreshMetricsBuilder.setOverallRefreshType(this.overallRefreshType);
    }

    @Override
    public void blobLoaded(HollowConsumer.Blob transition) {
        ++this.updatePlanDetails.numSuccessfulTransitions;
    }

    private final void noFailRefreshEndMetricsReporting(ConsumerRefreshMetrics refreshMetrics) {
        try {
            this.refreshEndMetricsReporting(refreshMetrics);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Encountered an exception in reporting consumer refresh metrics, ignoring exception and continuing with consumer refresh", e);
        }
    }

    @Override
    public void refreshSuccessful(long beforeVersion, long afterVersion, long requestedVersion) {
        long refreshEndTimeNano = System.nanoTime();
        long durationMillis = TimeUnit.NANOSECONDS.toMillis(refreshEndTimeNano - this.refreshStartTimeNano);
        this.consecutiveFailures = 0L;
        this.lastRefreshTimeNanoOptional = OptionalLong.of(refreshEndTimeNano);
        this.refreshMetricsBuilder.setDurationMillis(durationMillis).setIsRefreshSuccess(true).setConsecutiveFailures(this.consecutiveFailures).setRefreshSuccessAgeMillisOptional(0L).setRefreshEndTimeNano(refreshEndTimeNano);
        if (this.cycleVersionStartTimes.containsKey(afterVersion)) {
            this.refreshMetricsBuilder.setCycleStartTimestamp(this.cycleVersionStartTimes.get(afterVersion));
        }
        this.noFailRefreshEndMetricsReporting(this.refreshMetricsBuilder.build());
    }

    @Override
    public void refreshFailed(long beforeVersion, long afterVersion, long requestedVersion, Throwable failureCause) {
        long refreshEndTimeNano = System.nanoTime();
        long durationMillis = TimeUnit.NANOSECONDS.toMillis(refreshEndTimeNano - this.refreshStartTimeNano);
        ++this.consecutiveFailures;
        this.refreshMetricsBuilder.setDurationMillis(durationMillis).setIsRefreshSuccess(false).setConsecutiveFailures(this.consecutiveFailures).setRefreshEndTimeNano(refreshEndTimeNano);
        if (this.lastRefreshTimeNanoOptional.isPresent()) {
            this.refreshMetricsBuilder.setRefreshSuccessAgeMillisOptional(TimeUnit.NANOSECONDS.toMillis(refreshEndTimeNano - this.lastRefreshTimeNanoOptional.getAsLong()));
        }
        if (this.cycleVersionStartTimes.containsKey(afterVersion)) {
            this.refreshMetricsBuilder.setCycleStartTimestamp(this.cycleVersionStartTimes.get(afterVersion));
        }
        this.noFailRefreshEndMetricsReporting(this.refreshMetricsBuilder.build());
    }

    @Override
    public void snapshotUpdateOccurred(HollowAPI refreshAPI, HollowReadStateEngine stateEngine, long version) {
        this.trackCycleStartTime(version, stateEngine.getHeaderTags());
    }

    @Override
    public void deltaUpdateOccurred(HollowAPI refreshAPI, HollowReadStateEngine stateEngine, long version) {
        this.trackCycleStartTime(version, stateEngine.getHeaderTags());
    }

    private void trackCycleStartTime(long version, Map<String, String> headers) {
        String cycleStartMetric;
        if (headers != null && (cycleStartMetric = headers.get("hollow.metric.cycle.start")) != null && !cycleStartMetric.isEmpty()) {
            try {
                Long cycleStartTimestamp = Long.valueOf(cycleStartMetric);
                if (cycleStartTimestamp != null) {
                    this.cycleVersionStartTimes.put(version, cycleStartTimestamp);
                }
            }
            catch (NumberFormatException e) {
                log.log(Level.WARNING, "Blob header contained HEADER_TAG_METRIC_CYCLE_START but its value couldnot be parsed as a long. Consumer metrics relying on cycle start time will be unreliable.", e);
            }
        }
    }

    @Override
    public void snapshotApplied(HollowAPI api, HollowReadStateEngine stateEngine, long version) throws Exception {
    }

    @Override
    public void deltaApplied(HollowAPI api, HollowReadStateEngine stateEngine, long version) throws Exception {
    }
}

