/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.consumer.index;

import com.netflix.hollow.api.custom.HollowAPI;
import com.netflix.hollow.api.objects.HollowObject;
import com.netflix.hollow.api.objects.HollowRecord;
import com.netflix.hollow.api.objects.generic.GenericHollowObject;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.index.FieldPaths;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.write.objectmapper.HollowObjectTypeMapper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

final class SelectFieldPathResultExtractor<T> {
    final FieldPaths.FieldPath<FieldPaths.FieldSegment> fieldPath;
    final BiObjectIntFunction<HollowAPI, T> extractor;

    SelectFieldPathResultExtractor(FieldPaths.FieldPath<FieldPaths.FieldSegment> fieldPath, BiObjectIntFunction<HollowAPI, T> extractor) {
        this.fieldPath = fieldPath;
        this.extractor = extractor;
    }

    T extract(HollowAPI api, int ordinal) {
        return this.extractor.apply(api, ordinal);
    }

    static IllegalArgumentException incompatibleSelectType(Class<?> selectType, String fieldPath, HollowObjectSchema.FieldType schemaFieldType) {
        return new IllegalArgumentException(String.format("Select type %s incompatible with field path %s resolving to field of type %s", new Object[]{selectType.getName(), fieldPath, schemaFieldType}));
    }

    static IllegalArgumentException incompatibleSelectType(Class<?> selectType, String fieldPath, String typeName) {
        return new IllegalArgumentException(String.format("Select type %s incompatible with field path %s resolving to field of reference type %s", selectType.getName(), fieldPath, typeName));
    }

    static <T> SelectFieldPathResultExtractor<T> from(Class<? extends HollowAPI> apiType, HollowDataset dataset, Class<?> rootType, String fieldPath, Class<T> selectType) {
        MethodHandle selectInstantiate;
        String typeName;
        String rootTypeName = HollowObjectTypeMapper.getDefaultTypeName(rootType);
        FieldPaths.FieldPath<FieldPaths.FieldSegment> fp = FieldPaths.createFieldPathForHashIndex(dataset, rootTypeName, fieldPath);
        if (!fp.getSegments().isEmpty()) {
            HollowObjectSchema.FieldType schemaFieldType;
            FieldPaths.FieldSegment lastSegment = fp.getSegments().get(fp.getSegments().size() - 1);
            HollowSchema.SchemaType schemaType = lastSegment.getEnclosingSchema().getSchemaType();
            if (schemaType == HollowSchema.SchemaType.OBJECT) {
                FieldPaths.ObjectFieldSegment os = (FieldPaths.ObjectFieldSegment)lastSegment;
                schemaFieldType = os.getType();
            } else {
                schemaFieldType = HollowObjectSchema.FieldType.REFERENCE;
            }
            typeName = lastSegment.getTypeName();
            if (schemaFieldType != HollowObjectSchema.FieldType.REFERENCE) {
                throw SelectFieldPathResultExtractor.incompatibleSelectType(selectType, fieldPath, schemaFieldType);
            }
            if (typeName.equals("String") ? !HollowObject.class.isAssignableFrom(selectType) : (!HollowObjectTypeMapper.getDefaultTypeName(selectType).equals(typeName) ? schemaType != HollowSchema.SchemaType.OBJECT && !GenericHollowObject.class.isAssignableFrom(selectType) : !HollowRecord.class.isAssignableFrom(selectType))) {
                throw SelectFieldPathResultExtractor.incompatibleSelectType(selectType, fieldPath, typeName);
            }
        } else {
            typeName = rootTypeName;
        }
        if (GenericHollowObject.class.isAssignableFrom(selectType)) {
            BiObjectIntFunction<HollowAPI, Object> extractor = (a, o) -> {
                GenericHollowObject t = new GenericHollowObject(a.getDataAccess(), typeName, o);
                return t;
            };
            return new SelectFieldPathResultExtractor<Object>(fp, extractor);
        }
        try {
            selectInstantiate = MethodHandles.lookup().findVirtual(apiType, "get" + selectType.getSimpleName(), MethodType.methodType(selectType, Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Select type %s is not associated with API %s", selectType.getName(), apiType.getName()), e);
        }
        BiObjectIntFunction<HollowAPI, Object> extractor = (a, i) -> {
            try {
                Object s = selectInstantiate.invoke((HollowAPI)a, i);
                return s;
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
        return new SelectFieldPathResultExtractor<Object>(fp, extractor);
    }

    static interface BiObjectIntFunction<T, R> {
        public R apply(T var1, int var2);
    }
}

