/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.consumer.index;

import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.api.consumer.index.HashIndexSelect;
import com.netflix.hollow.api.objects.HollowRecord;
import java.util.Objects;

public final class HashIndex<T extends HollowRecord, Q>
extends HashIndexSelect<T, T, Q> {
    HashIndex(HollowConsumer consumer, Class<T> rootType, Class<Q> matchedFieldsType) {
        super(consumer, rootType, rootType, "", matchedFieldsType);
    }

    HashIndex(HollowConsumer consumer, Class<T> rootType, String fieldPath, Class<Q> matchedFieldType) {
        super(consumer, rootType, rootType, "", fieldPath, matchedFieldType);
    }

    public static <T extends HollowRecord> Builder<T> from(HollowConsumer consumer, Class<T> rootType) {
        Objects.requireNonNull(consumer);
        Objects.requireNonNull(rootType);
        return new Builder<T>(consumer, rootType);
    }

    public static final class Builder<T extends HollowRecord> {
        final HollowConsumer consumer;
        final Class<T> rootType;

        Builder(HollowConsumer consumer, Class<T> rootType) {
            this.consumer = consumer;
            this.rootType = rootType;
        }

        public <Q> HashIndex<T, Q> usingBean(Class<Q> queryType) {
            Objects.requireNonNull(queryType);
            return new HashIndex<T, Q>(this.consumer, this.rootType, queryType);
        }

        public <Q> HashIndex<T, Q> usingPath(String queryFieldPath, Class<Q> queryFieldType) {
            Objects.requireNonNull(queryFieldPath);
            if (queryFieldPath.isEmpty()) {
                throw new IllegalArgumentException("queryFieldPath argument is an empty String");
            }
            Objects.requireNonNull(queryFieldType);
            return new HashIndex<T, Q>(this.consumer, this.rootType, queryFieldPath, queryFieldType);
        }

        public <S extends HollowRecord> HashIndexSelect.BuilderWithSelect<T, S> selectField(String selectFieldPath, Class<S> selectFieldType) {
            Objects.requireNonNull(selectFieldPath);
            Objects.requireNonNull(selectFieldType);
            return new HashIndexSelect.BuilderWithSelect<T, S>(this.consumer, this.rootType, selectFieldPath, selectFieldType);
        }
    }
}

