/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.testdata;

import com.netflix.hollow.api.codegen.testdata.HollowListTypeTestDataAPIClassGenerator;
import com.netflix.hollow.api.codegen.testdata.HollowMapTypeTestDataAPIClassGenerator;
import com.netflix.hollow.api.codegen.testdata.HollowObjectTypeTestDataAPIClassGenerator;
import com.netflix.hollow.api.codegen.testdata.HollowSetTypeTestDataAPIClassGenerator;
import com.netflix.hollow.api.codegen.testdata.HollowTestDataAPIClassGenerator;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class HollowTestDataAPIGenerator {
    private HollowDataset dataset;
    private String apiClassname;
    private String packageName;
    private Path destinationPath;

    public static Builder newBuilder() {
        HollowTestDataAPIGenerator gen = new HollowTestDataAPIGenerator();
        return gen.theBuilder();
    }

    private Builder theBuilder() {
        return new Builder();
    }

    public void generateSourceFiles() throws IOException {
        this.generate(this.dataset, this.packageName, this.apiClassname, this.destinationPath);
    }

    private void generate(HollowDataset dataset, String packageName, String apiClassName, Path destination) throws IOException {
        Path apiClassDestination = destination.resolve(apiClassName + ".java");
        Files.createDirectories(destination, new FileAttribute[0]);
        String apiClassContent = new HollowTestDataAPIClassGenerator(dataset, apiClassName, packageName).generate();
        try (FileWriter writer = new FileWriter(apiClassDestination.toFile());){
            writer.write(apiClassContent);
        }
        for (HollowSchema schema : dataset.getSchemas()) {
            File classDestination = destination.resolve(schema.getName() + "TestData.java").toFile();
            String classContent = null;
            switch (schema.getSchemaType()) {
                case OBJECT: {
                    classContent = new HollowObjectTypeTestDataAPIClassGenerator(dataset, (HollowObjectSchema)schema, packageName).generate();
                    break;
                }
                case LIST: {
                    classContent = new HollowListTypeTestDataAPIClassGenerator(dataset, (HollowListSchema)schema, packageName).generate();
                    break;
                }
                case SET: {
                    classContent = new HollowSetTypeTestDataAPIClassGenerator(dataset, (HollowSetSchema)schema, packageName).generate();
                    break;
                }
                case MAP: {
                    classContent = new HollowMapTypeTestDataAPIClassGenerator(dataset, (HollowMapSchema)schema, packageName).generate();
                }
            }
            if (classContent == null) continue;
            FileWriter writer = new FileWriter(classDestination);
            Throwable throwable = null;
            try {
                writer.write(classContent);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                writer.close();
            }
        }
    }

    public class Builder {
        public Builder withDataset(HollowDataset dataset) {
            HollowTestDataAPIGenerator.this.dataset = dataset;
            return this;
        }

        public Builder withAPIClassname(String apiClassname) {
            HollowTestDataAPIGenerator.this.apiClassname = apiClassname;
            return this;
        }

        public Builder withPackageName(String packageName) {
            HollowTestDataAPIGenerator.this.packageName = packageName;
            return this;
        }

        public Builder withDestination(String destinationPath) {
            return this.withDestination(Paths.get(destinationPath, new String[0]));
        }

        public Builder withDestination(Path destinationPath) {
            HollowTestDataAPIGenerator.this.destinationPath = destinationPath;
            return this;
        }

        public HollowTestDataAPIGenerator build() {
            return HollowTestDataAPIGenerator.this;
        }
    }
}

