/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.testdata;

import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

class HollowObjectTypeTestDataAPIClassGenerator {
    private final HollowDataset dataset;
    private final HollowObjectSchema schema;
    private final String packageName;
    private final String className;

    public HollowObjectTypeTestDataAPIClassGenerator(HollowDataset dataset, HollowObjectSchema schema, String packageName) {
        this.dataset = dataset;
        this.schema = schema;
        this.packageName = packageName;
        this.className = schema.getName() + "TestData";
    }

    public String generate() {
        int i;
        StringBuilder builder = new StringBuilder();
        StringBuilder importBuilder = new StringBuilder();
        importBuilder.append("package " + this.packageName + ";\n\n");
        importBuilder.append("import com.netflix.hollow.api.testdata.HollowTestObjectRecord;\n");
        if (this.schema.getPrimaryKey() != null) {
            importBuilder.append("import com.netflix.hollow.core.index.key.PrimaryKey;\n");
        }
        importBuilder.append("import com.netflix.hollow.core.schema.HollowObjectSchema;\n");
        importBuilder.append("import com.netflix.hollow.core.schema.HollowObjectSchema.FieldType;\n\n");
        HashSet fieldTypesToImport = new HashSet();
        builder.append("public class " + this.className + "<T> extends HollowTestObjectRecord<T> {\n\n");
        builder.append("    " + this.className + "(T parent){\n");
        builder.append("        super(parent);\n");
        builder.append("    }\n\n");
        block19: for (i = 0; i < this.schema.numFields(); ++i) {
            String fieldName = this.schema.getFieldName(i);
            switch (this.schema.getFieldType(i)) {
                case INT: {
                    builder.append("    public " + this.className + "<T> " + fieldName + "(Integer " + fieldName + ") {\n");
                    builder.append("        super.addField(\"" + fieldName + "\", " + fieldName + ");\n");
                    builder.append("        return this;\n");
                    builder.append("    }\n\n");
                    continue block19;
                }
                case LONG: {
                    builder.append("    public " + this.className + "<T> " + fieldName + "(Long " + fieldName + ") {\n");
                    builder.append("        super.addField(\"" + fieldName + "\", " + fieldName + ");\n");
                    builder.append("        return this;\n");
                    builder.append("    }\n\n");
                    continue block19;
                }
                case FLOAT: {
                    builder.append("    public " + this.className + "<T> " + fieldName + "(Float " + fieldName + ") {\n");
                    builder.append("        super.addField(\"" + fieldName + "\", " + fieldName + ");\n");
                    builder.append("        return this;\n");
                    builder.append("    }\n\n");
                    continue block19;
                }
                case DOUBLE: {
                    builder.append("    public " + this.className + "<T> " + fieldName + "(Double " + fieldName + ") {\n");
                    builder.append("        super.addField(\"" + fieldName + "\", " + fieldName + ");\n");
                    builder.append("        return this;\n");
                    builder.append("    }\n\n");
                    continue block19;
                }
                case BOOLEAN: {
                    builder.append("    public " + this.className + "<T> " + fieldName + "(Boolean " + fieldName + ") {\n");
                    builder.append("        super.addField(\"" + fieldName + "\", " + fieldName + ");\n");
                    builder.append("        return this;\n");
                    builder.append("    }\n\n");
                    continue block19;
                }
                case BYTES: {
                    builder.append("    public " + this.className + "<T> " + fieldName + "(byte[] " + fieldName + ") {\n");
                    builder.append("        super.addField(\"" + fieldName + "\", " + fieldName + ");\n");
                    builder.append("        return this;\n");
                    builder.append("    }\n\n");
                    continue block19;
                }
                case STRING: {
                    builder.append("    public " + this.className + "<T> " + fieldName + "(String " + fieldName + ") {\n");
                    builder.append("        super.addField(\"" + fieldName + "\", " + fieldName + ");\n");
                    builder.append("        return this;\n");
                    builder.append("    }\n\n");
                    continue block19;
                }
                case REFERENCE: {
                    String refType = this.schema.getReferencedType(i);
                    String returnType = this.className(refType) + "<" + this.className + "<T>>";
                    builder.append("    public " + returnType + " " + fieldName + "() {\n");
                    builder.append("        " + returnType + " __x = new " + returnType + "(this);\n");
                    builder.append("        super.addField(\"" + fieldName + "\", __x);\n");
                    builder.append("        return __x;\n");
                    builder.append("    }\n\n");
                    if (!this.canErgonomicShortcut(i)) continue block19;
                    HollowObjectSchema refSchema = (HollowObjectSchema)this.dataset.getSchema(refType);
                    String refField = refSchema.getFieldName(0);
                    switch (refSchema.getFieldType(0)) {
                        case INT: {
                            builder.append("    public " + this.className + "<T> " + fieldName + "(Integer " + fieldName + ") {\n");
                            builder.append("        " + fieldName + "()." + refField + "(" + fieldName + ");\n");
                            builder.append("        return this;\n");
                            builder.append("    }\n\n");
                            continue block19;
                        }
                        case LONG: {
                            builder.append("    public " + this.className + "<T> " + fieldName + "(Long " + fieldName + ") {\n");
                            builder.append("        " + fieldName + "()." + refField + "(" + fieldName + ");\n");
                            builder.append("        return this;\n");
                            builder.append("    }\n\n");
                            continue block19;
                        }
                        case FLOAT: {
                            builder.append("    public " + this.className + "<T> " + fieldName + "(Float " + fieldName + ") {\n");
                            builder.append("        " + fieldName + "()." + refField + "(" + fieldName + ");\n");
                            builder.append("        return this;\n");
                            builder.append("    }\n\n");
                            continue block19;
                        }
                        case DOUBLE: {
                            builder.append("    public " + this.className + "<T> " + fieldName + "(Double " + fieldName + ") {\n");
                            builder.append("        " + fieldName + "()." + refField + "(" + fieldName + ");\n");
                            builder.append("        return this;\n");
                            builder.append("    }\n\n");
                            continue block19;
                        }
                        case BOOLEAN: {
                            builder.append("    public " + this.className + "<T> " + fieldName + "(Boolean " + fieldName + ") {\n");
                            builder.append("        " + fieldName + "()." + refField + "(" + fieldName + ");\n");
                            builder.append("        return this;\n");
                            builder.append("    }\n\n");
                            continue block19;
                        }
                        case BYTES: {
                            builder.append("    public " + this.className + "<T> " + fieldName + "(byte[] " + fieldName + ") {\n");
                            builder.append("        " + fieldName + "()." + refField + "(" + fieldName + ");\n");
                            builder.append("        return this;\n");
                            builder.append("    }\n\n");
                            continue block19;
                        }
                        case STRING: {
                            builder.append("    public " + this.className + "<T> " + fieldName + "(String " + fieldName + ") {\n");
                            builder.append("        " + fieldName + "()." + refField + "(" + fieldName + ");\n");
                            builder.append("        return this;\n");
                            builder.append("    }\n\n");
                            continue block19;
                        }
                    }
                    throw new IllegalStateException("Cannot actually ergonomic shortcut");
                }
            }
        }
        builder.append("    public static final HollowObjectSchema SCHEMA = new HollowObjectSchema(\"" + this.schema.getName() + "\", " + this.schema.numFields());
        if (this.schema.getPrimaryKey() != null) {
            builder.append(", new PrimaryKey(\"" + this.schema.getName() + "\"");
            for (i = 0; i < this.schema.getPrimaryKey().numFields(); ++i) {
                builder.append(", \"" + this.schema.getPrimaryKey().getFieldPath(i) + "\"");
            }
            builder.append(")");
        }
        builder.append(");\n\n");
        builder.append("    static {\n");
        for (i = 0; i < this.schema.numFields(); ++i) {
            builder.append("        SCHEMA.addField(\"" + this.schema.getFieldName(i) + "\", FieldType." + this.schema.getFieldType(i).name());
            if (this.schema.getFieldType(i) == HollowObjectSchema.FieldType.REFERENCE) {
                builder.append(", \"" + this.schema.getReferencedType(i) + "\"");
            }
            builder.append(");\n");
        }
        builder.append("    }\n\n");
        builder.append("    @Override public HollowObjectSchema getSchema() { return SCHEMA; }\n\n");
        builder.append("}");
        if (!fieldTypesToImport.isEmpty()) {
            ArrayList fieldTypesList = new ArrayList(fieldTypesToImport);
            Collections.sort(fieldTypesList);
            for (String fieldType : fieldTypesList) {
                importBuilder.append("import " + this.packageName + "." + this.className(fieldType) + "." + fieldType + "Field;\n");
            }
            importBuilder.append("\n");
        }
        return importBuilder.toString() + builder.toString();
    }

    public String className(String type) {
        return type + "TestData";
    }

    public boolean canErgonomicShortcut(int fieldIdx) {
        if (this.schema.getFieldType(fieldIdx) != HollowObjectSchema.FieldType.REFERENCE) {
            return false;
        }
        String refType = this.schema.getReferencedType(fieldIdx);
        HollowSchema refSchema = this.dataset.getSchema(refType);
        return this.canErgonomicShortcut(refSchema);
    }

    public boolean canErgonomicShortcut(HollowSchema schema) {
        if (schema.getSchemaType() != HollowSchema.SchemaType.OBJECT) {
            return false;
        }
        HollowObjectSchema objSchema = (HollowObjectSchema)schema;
        if (objSchema.numFields() != 1) {
            return false;
        }
        return objSchema.getFieldType(0) != HollowObjectSchema.FieldType.REFERENCE;
    }
}

