/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.perfapi;

import com.netflix.hollow.api.codegen.perfapi.HollowObjectTypePerfAPIClassGenerator;
import com.netflix.hollow.api.codegen.perfapi.HollowPerformanceAPIClassGenerator;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class HollowPerformanceAPIGenerator {
    private HollowDataset dataset;
    private String apiClassname;
    private String packageName;
    private Path destinationPath;
    private Set<String> checkFieldExistsMethods = new HashSet<String>();

    public static Builder newBuilder() {
        HollowPerformanceAPIGenerator gen = new HollowPerformanceAPIGenerator();
        return gen.theBuilder();
    }

    private Builder theBuilder() {
        return new Builder();
    }

    public void generateSourceFiles() throws IOException {
        this.generate(this.dataset, this.packageName, this.apiClassname, this.destinationPath, this.checkFieldExistsMethods);
    }

    private void generate(HollowDataset dataset, String packageName, String apiClassName, Path destination, Set<String> checkFieldExistsMethods) throws IOException {
        Path apiClassDestination = destination.resolve(apiClassName + ".java");
        if (!Files.exists(apiClassDestination, new LinkOption[0])) {
            Files.createDirectories(destination, new FileAttribute[0]);
        }
        String apiClassContent = new HollowPerformanceAPIClassGenerator(dataset, apiClassName, packageName).generate();
        try (FileWriter writer = new FileWriter(apiClassDestination.toFile());){
            writer.write(apiClassContent);
        }
        for (HollowSchema schema : dataset.getSchemas()) {
            if (schema.getSchemaType() != HollowSchema.SchemaType.OBJECT) continue;
            Path objClassDestination = destination.resolve(schema.getName() + "PerfAPI.java");
            String objClassContent = new HollowObjectTypePerfAPIClassGenerator((HollowObjectSchema)schema, packageName, checkFieldExistsMethods).generate();
            FileWriter writer = new FileWriter(objClassDestination.toFile());
            Throwable throwable = null;
            try {
                writer.write(objClassContent);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                writer.close();
            }
        }
    }

    public class Builder {
        public Builder withDataset(HollowDataset dataset) {
            HollowPerformanceAPIGenerator.this.dataset = dataset;
            return this;
        }

        public Builder withAPIClassname(String apiClassname) {
            HollowPerformanceAPIGenerator.this.apiClassname = apiClassname;
            return this;
        }

        public Builder withPackageName(String packageName) {
            HollowPerformanceAPIGenerator.this.packageName = packageName;
            return this;
        }

        public Builder withDestination(String destinationPath) {
            return this.withDestination(Paths.get(destinationPath, new String[0]));
        }

        public Builder withDestination(Path destinationPath) {
            HollowPerformanceAPIGenerator.this.destinationPath = destinationPath;
            return this;
        }

        public Builder withCheckFieldExistsMethods(Set<String> checkFieldExistsMethods) {
            HollowPerformanceAPIGenerator.this.checkFieldExistsMethods.addAll(checkFieldExistsMethods);
            return this;
        }

        public Builder withCheckFieldExistsMethods(String ... checkFieldExistsMethods) {
            HollowPerformanceAPIGenerator.this.checkFieldExistsMethods.addAll(Arrays.asList(checkFieldExistsMethods));
            return this;
        }

        public HollowPerformanceAPIGenerator build() {
            return HollowPerformanceAPIGenerator.this;
        }
    }
}

