/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.objects;

import com.netflix.hollow.api.codegen.CodeGeneratorConfig;
import com.netflix.hollow.api.codegen.HollowCodeGenerationUtils;
import com.netflix.hollow.api.codegen.HollowConsumerJavaFileGenerator;
import com.netflix.hollow.api.custom.HollowTypeAPI;
import com.netflix.hollow.api.objects.delegate.HollowListCachedDelegate;
import com.netflix.hollow.api.objects.delegate.HollowMapCachedDelegate;
import com.netflix.hollow.api.objects.delegate.HollowSetCachedDelegate;
import com.netflix.hollow.api.objects.provider.HollowFactory;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import java.util.Arrays;

public class HollowFactoryJavaGenerator
extends HollowConsumerJavaFileGenerator {
    public static final String SUB_PACKAGE_NAME = "core";
    private final String objectClassName;
    private final HollowSchema schema;

    public HollowFactoryJavaGenerator(String packageName, HollowSchema schema, HollowDataset dataset, CodeGeneratorConfig config) {
        super(packageName, SUB_PACKAGE_NAME, dataset, config);
        this.objectClassName = this.hollowImplClassname(schema.getName());
        this.className = HollowCodeGenerationUtils.hollowFactoryClassname(schema.getName());
        this.schema = schema;
    }

    @Override
    public String generate() {
        StringBuilder builder = new StringBuilder();
        this.appendPackageAndCommonImports(builder, null, Arrays.asList(this.schema));
        builder.append("import " + HollowFactory.class.getName() + ";\n");
        builder.append("import " + HollowTypeDataAccess.class.getName() + ";\n");
        builder.append("import " + HollowTypeAPI.class.getName() + ";\n");
        if (this.schema instanceof HollowListSchema) {
            builder.append("import " + HollowListCachedDelegate.class.getName() + ";\n");
        }
        if (this.schema instanceof HollowSetSchema) {
            builder.append("import " + HollowSetCachedDelegate.class.getName() + ";\n");
        }
        if (this.schema instanceof HollowMapSchema) {
            builder.append("import " + HollowMapCachedDelegate.class.getName() + ";\n");
        }
        builder.append("\n@SuppressWarnings(\"all\")\n");
        builder.append("public class " + this.className + "<T extends " + this.objectClassName + "> extends HollowFactory<T> {\n\n");
        builder.append("    @Override\n");
        builder.append("    public T newHollowObject(HollowTypeDataAccess dataAccess, HollowTypeAPI typeAPI, int ordinal) {\n");
        builder.append("        return (T)new " + this.objectClassName + "(((" + HollowCodeGenerationUtils.typeAPIClassname(this.schema.getName()) + ")typeAPI).getDelegateLookupImpl(), ordinal);\n");
        builder.append("    }\n\n");
        builder.append("    @Override\n");
        builder.append("    public T newCachedHollowObject(HollowTypeDataAccess dataAccess, HollowTypeAPI typeAPI, int ordinal) {\n");
        builder.append("        return (T)new " + this.objectClassName + "(new " + HollowCodeGenerationUtils.delegateCachedClassname(this.schema) + "((" + HollowCodeGenerationUtils.typeAPIClassname(this.schema.getName()) + ")typeAPI, ordinal), ordinal);\n");
        builder.append("    }\n\n");
        builder.append("}");
        return builder.toString();
    }
}

