/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.delegate;

import com.netflix.hollow.api.codegen.CodeGeneratorConfig;
import com.netflix.hollow.api.codegen.HollowCodeGenerationUtils;
import com.netflix.hollow.api.codegen.HollowErgonomicAPIShortcuts;
import com.netflix.hollow.api.codegen.delegate.HollowObjectDelegateGenerator;
import com.netflix.hollow.api.objects.delegate.HollowObjectAbstractDelegate;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.schema.HollowObjectSchema;

public class HollowObjectDelegateLookupImplGenerator
extends HollowObjectDelegateGenerator {
    public HollowObjectDelegateLookupImplGenerator(String packageName, HollowObjectSchema schema, HollowErgonomicAPIShortcuts ergonomicShortcuts, HollowDataset dataset, CodeGeneratorConfig config) {
        super(packageName, schema, ergonomicShortcuts, dataset, config);
        this.className = HollowCodeGenerationUtils.delegateLookupImplName(schema.getName());
    }

    @Override
    public String generate() {
        StringBuilder builder = new StringBuilder();
        this.appendPackageAndCommonImports(builder);
        builder.append("import ").append(HollowObjectAbstractDelegate.class.getName()).append(";\n");
        builder.append("import ").append(HollowObjectTypeDataAccess.class.getName()).append(";\n");
        builder.append("import ").append(HollowObjectSchema.class.getName()).append(";\n");
        builder.append("\n@SuppressWarnings(\"all\")\n");
        builder.append("public class ").append(this.className).append(" extends HollowObjectAbstractDelegate implements ").append(HollowCodeGenerationUtils.delegateInterfaceName(this.schema.getName())).append(" {\n\n");
        builder.append("    private final ").append(HollowCodeGenerationUtils.typeAPIClassname(this.schema.getName())).append(" typeAPI;\n\n");
        builder.append("    public ").append(this.className).append("(").append(HollowCodeGenerationUtils.typeAPIClassname(this.schema.getName())).append(" typeAPI) {\n");
        builder.append("        this.typeAPI = typeAPI;\n");
        builder.append("    }\n\n");
        block10: for (int i = 0; i < this.schema.numFields(); ++i) {
            String methodFieldName = HollowCodeGenerationUtils.substituteInvalidChars(HollowCodeGenerationUtils.uppercase(this.schema.getFieldName(i)));
            switch (this.schema.getFieldType(i)) {
                case BOOLEAN: {
                    builder.append("    public boolean get").append(methodFieldName).append("(int ordinal) {\n");
                    builder.append("        return typeAPI.get").append(methodFieldName).append("(ordinal);\n");
                    builder.append("    }\n\n");
                    builder.append("    public Boolean get").append(methodFieldName).append("Boxed(int ordinal) {\n");
                    builder.append("        return typeAPI.get").append(methodFieldName).append("Boxed(ordinal);\n");
                    builder.append("    }\n\n");
                    continue block10;
                }
                case BYTES: {
                    builder.append("    public byte[] get").append(methodFieldName).append("(int ordinal) {\n");
                    builder.append("        return typeAPI.get").append(methodFieldName).append("(ordinal);\n");
                    builder.append("    }\n\n");
                    continue block10;
                }
                case DOUBLE: {
                    builder.append("    public double get").append(methodFieldName).append("(int ordinal) {\n");
                    builder.append("        return typeAPI.get").append(methodFieldName).append("(ordinal);\n");
                    builder.append("    }\n\n");
                    builder.append("    public Double get").append(methodFieldName).append("Boxed(int ordinal) {\n");
                    builder.append("        return typeAPI.get").append(methodFieldName).append("Boxed(ordinal);\n");
                    builder.append("    }\n\n");
                    continue block10;
                }
                case FLOAT: {
                    builder.append("    public float get").append(methodFieldName).append("(int ordinal) {\n");
                    builder.append("        return typeAPI.get").append(methodFieldName).append("(ordinal);\n");
                    builder.append("    }\n\n");
                    builder.append("    public Float get").append(methodFieldName).append("Boxed(int ordinal) {\n");
                    builder.append("        return typeAPI.get").append(methodFieldName).append("Boxed(ordinal);\n");
                    builder.append("    }\n\n");
                    continue block10;
                }
                case INT: {
                    builder.append("    public int get").append(methodFieldName).append("(int ordinal) {\n");
                    builder.append("        return typeAPI.get").append(methodFieldName).append("(ordinal);\n");
                    builder.append("    }\n\n");
                    builder.append("    public Integer get").append(methodFieldName).append("Boxed(int ordinal) {\n");
                    builder.append("        return typeAPI.get").append(methodFieldName).append("Boxed(ordinal);\n");
                    builder.append("    }\n\n");
                    continue block10;
                }
                case LONG: {
                    builder.append("    public long get").append(methodFieldName).append("(int ordinal) {\n");
                    builder.append("        return typeAPI.get").append(methodFieldName).append("(ordinal);\n");
                    builder.append("    }\n\n");
                    builder.append("    public Long get").append(methodFieldName).append("Boxed(int ordinal) {\n");
                    builder.append("        return typeAPI.get").append(methodFieldName).append("Boxed(ordinal);\n");
                    builder.append("    }\n\n");
                    continue block10;
                }
                case STRING: {
                    builder.append("    public String get").append(methodFieldName).append("(int ordinal) {\n");
                    builder.append("        return typeAPI.get").append(methodFieldName).append("(ordinal);\n");
                    builder.append("    }\n\n");
                    builder.append("    public boolean is").append(methodFieldName).append("Equal(int ordinal, String testValue) {\n");
                    builder.append("        return typeAPI.is").append(methodFieldName).append("Equal(ordinal, testValue);\n");
                    builder.append("    }\n\n");
                    continue block10;
                }
                case REFERENCE: {
                    HollowErgonomicAPIShortcuts.Shortcut shortcut = this.ergonomicShortcuts.getShortcut(this.schema.getName() + "." + this.schema.getFieldName(i));
                    if (shortcut != null) {
                        this.addShortcutAccessMethod(builder, methodFieldName, shortcut);
                    }
                    builder.append("    public int get").append(methodFieldName).append("Ordinal(int ordinal) {\n");
                    builder.append("        return typeAPI.get").append(methodFieldName).append("Ordinal(ordinal);\n");
                    builder.append("    }\n\n");
                }
            }
        }
        builder.append("    public ").append(HollowCodeGenerationUtils.typeAPIClassname(this.schema.getName())).append(" getTypeAPI() {\n");
        builder.append("        return typeAPI;\n");
        builder.append("    }\n\n");
        builder.append("    @Override\n");
        builder.append("    public HollowObjectSchema getSchema() {\n");
        builder.append("        return typeAPI.getTypeDataAccess().getSchema();\n");
        builder.append("    }\n\n");
        builder.append("    @Override\n");
        builder.append("    public HollowObjectTypeDataAccess getTypeDataAccess() {\n");
        builder.append("        return typeAPI.getTypeDataAccess();\n");
        builder.append("    }\n\n");
        builder.append("}");
        return builder.toString();
    }

    private void addShortcutAccessMethod(StringBuilder builder, String methodFieldName, HollowErgonomicAPIShortcuts.Shortcut shortcut) {
        String finalFieldName = HollowCodeGenerationUtils.substituteInvalidChars(HollowCodeGenerationUtils.uppercase(shortcut.getPath()[shortcut.getPath().length - 1]));
        String finalTypeAPI = HollowCodeGenerationUtils.typeAPIClassname(shortcut.getPathTypes()[shortcut.getPathTypes().length - 1]);
        switch (shortcut.getType()) {
            case BOOLEAN: {
                builder.append("    public boolean get").append(methodFieldName).append("(int ordinal) {\n");
                builder.append("        ordinal = typeAPI.get").append(methodFieldName).append("Ordinal(ordinal);\n");
                this.addShortcutTraversal(builder, shortcut);
                builder.append("        return ordinal == -1 ? false : typeAPI.getAPI().get" + finalTypeAPI + "().get").append(finalFieldName).append("(ordinal);\n");
                builder.append("    }\n\n");
                builder.append("    public Boolean get").append(methodFieldName).append("Boxed(int ordinal) {\n");
                builder.append("        ordinal = typeAPI.get").append(methodFieldName).append("Ordinal(ordinal);\n");
                this.addShortcutTraversal(builder, shortcut);
                builder.append("        return ordinal == -1 ? null : typeAPI.getAPI().get" + finalTypeAPI + "().get").append(finalFieldName).append("Boxed(ordinal);\n");
                builder.append("    }\n\n");
                break;
            }
            case BYTES: {
                builder.append("    public byte[] get").append(methodFieldName).append("(int ordinal) {\n");
                builder.append("        ordinal = typeAPI.get").append(methodFieldName).append("Ordinal(ordinal);\n");
                this.addShortcutTraversal(builder, shortcut);
                builder.append("        return ordinal == -1 ? null : typeAPI.getAPI().get" + finalTypeAPI + "().get").append(finalFieldName).append("(ordinal);\n");
                builder.append("    }\n\n");
                break;
            }
            case DOUBLE: {
                builder.append("    public double get").append(methodFieldName).append("(int ordinal) {\n");
                builder.append("        ordinal = typeAPI.get").append(methodFieldName).append("Ordinal(ordinal);\n");
                this.addShortcutTraversal(builder, shortcut);
                builder.append("        return ordinal == -1 ? Double.NaN : typeAPI.getAPI().get" + finalTypeAPI + "().get").append(finalFieldName).append("(ordinal);\n");
                builder.append("    }\n\n");
                builder.append("    public Double get").append(methodFieldName).append("Boxed(int ordinal) {\n");
                builder.append("        ordinal = typeAPI.get").append(methodFieldName).append("Ordinal(ordinal);\n");
                this.addShortcutTraversal(builder, shortcut);
                builder.append("        return ordinal == -1 ? null : typeAPI.getAPI().get" + finalTypeAPI + "().get").append(finalFieldName).append("Boxed(ordinal);\n");
                builder.append("    }\n\n");
                break;
            }
            case FLOAT: {
                builder.append("    public float get").append(methodFieldName).append("(int ordinal) {\n");
                builder.append("        ordinal = typeAPI.get").append(methodFieldName).append("Ordinal(ordinal);\n");
                this.addShortcutTraversal(builder, shortcut);
                builder.append("        return ordinal == -1 ? Float.NaN : typeAPI.getAPI().get" + finalTypeAPI + "().get").append(finalFieldName).append("(ordinal);\n");
                builder.append("    }\n\n");
                builder.append("    public Float get").append(methodFieldName).append("Boxed(int ordinal) {\n");
                builder.append("        ordinal = typeAPI.get").append(methodFieldName).append("Ordinal(ordinal);\n");
                this.addShortcutTraversal(builder, shortcut);
                builder.append("        return ordinal == -1 ? null : typeAPI.getAPI().get" + finalTypeAPI + "().get").append(finalFieldName).append("Boxed(ordinal);\n");
                builder.append("    }\n\n");
                break;
            }
            case INT: {
                builder.append("    public int get").append(methodFieldName).append("(int ordinal) {\n");
                builder.append("        ordinal = typeAPI.get").append(methodFieldName).append("Ordinal(ordinal);\n");
                this.addShortcutTraversal(builder, shortcut);
                builder.append("        return ordinal == -1 ? Integer.MIN_VALUE : typeAPI.getAPI().get" + finalTypeAPI + "().get").append(finalFieldName).append("(ordinal);\n");
                builder.append("    }\n\n");
                builder.append("    public Integer get").append(methodFieldName).append("Boxed(int ordinal) {\n");
                builder.append("        ordinal = typeAPI.get").append(methodFieldName).append("Ordinal(ordinal);\n");
                this.addShortcutTraversal(builder, shortcut);
                builder.append("        return ordinal == -1 ? null : typeAPI.getAPI().get" + finalTypeAPI + "().get").append(finalFieldName).append("Boxed(ordinal);\n");
                builder.append("    }\n\n");
                break;
            }
            case LONG: {
                builder.append("    public long get").append(methodFieldName).append("(int ordinal) {\n");
                builder.append("        ordinal = typeAPI.get").append(methodFieldName).append("Ordinal(ordinal);\n");
                this.addShortcutTraversal(builder, shortcut);
                builder.append("        return ordinal == -1 ? Long.MIN_VALUE : typeAPI.getAPI().get" + finalTypeAPI + "().get").append(finalFieldName).append("(ordinal);\n");
                builder.append("    }\n\n");
                builder.append("    public Long get").append(methodFieldName).append("Boxed(int ordinal) {\n");
                builder.append("        ordinal = typeAPI.get").append(methodFieldName).append("Ordinal(ordinal);\n");
                this.addShortcutTraversal(builder, shortcut);
                builder.append("        return ordinal == -1 ? null : typeAPI.getAPI().get" + finalTypeAPI + "().get").append(finalFieldName).append("Boxed(ordinal);\n");
                builder.append("    }\n\n");
                break;
            }
            case STRING: {
                builder.append("    public String get").append(methodFieldName).append("(int ordinal) {\n");
                builder.append("        ordinal = typeAPI.get").append(methodFieldName).append("Ordinal(ordinal);\n");
                this.addShortcutTraversal(builder, shortcut);
                builder.append("        return ordinal == -1 ? null : typeAPI.getAPI().get" + finalTypeAPI + "().get").append(finalFieldName).append("(ordinal);\n");
                builder.append("    }\n\n");
                builder.append("    public boolean is").append(methodFieldName).append("Equal(int ordinal, String testValue) {\n");
                builder.append("        ordinal = typeAPI.get").append(methodFieldName).append("Ordinal(ordinal);\n");
                this.addShortcutTraversal(builder, shortcut);
                builder.append("        return ordinal == -1 ? testValue == null : typeAPI.getAPI().get" + finalTypeAPI + "().is").append(finalFieldName).append("Equal(ordinal, testValue);\n");
                builder.append("    }\n\n");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void addShortcutTraversal(StringBuilder builder, HollowErgonomicAPIShortcuts.Shortcut shortcut) {
        for (int i = 0; i < shortcut.getPath().length - 1; ++i) {
            String typeAPIClassname = HollowCodeGenerationUtils.typeAPIClassname(shortcut.getPathTypes()[i]);
            builder.append("        if(ordinal != -1) ordinal = typeAPI.getAPI().get" + typeAPIClassname + "().get" + HollowCodeGenerationUtils.uppercase(shortcut.getPath()[i]) + "Ordinal(ordinal);\n");
        }
    }
}

