/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.delegate;

import com.netflix.hollow.api.codegen.CodeGeneratorConfig;
import com.netflix.hollow.api.codegen.HollowCodeGenerationUtils;
import com.netflix.hollow.api.codegen.HollowErgonomicAPIShortcuts;
import com.netflix.hollow.api.codegen.delegate.HollowObjectDelegateGenerator;
import com.netflix.hollow.api.objects.delegate.HollowObjectDelegate;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.schema.HollowObjectSchema;

public class HollowObjectDelegateInterfaceGenerator
extends HollowObjectDelegateGenerator {
    public HollowObjectDelegateInterfaceGenerator(String packageName, HollowObjectSchema schema, HollowErgonomicAPIShortcuts ergonomicShortcuts, HollowDataset dataset, CodeGeneratorConfig config) {
        super(packageName, schema, ergonomicShortcuts, dataset, config);
        this.className = HollowCodeGenerationUtils.delegateInterfaceName(schema.getName());
    }

    @Override
    public String generate() {
        StringBuilder classBuilder = new StringBuilder();
        this.appendPackageAndCommonImports(classBuilder);
        classBuilder.append("import ").append(HollowObjectDelegate.class.getName()).append(";\n\n");
        classBuilder.append("\n@SuppressWarnings(\"all\")\n");
        classBuilder.append("public interface ").append(this.className).append(" extends HollowObjectDelegate {\n\n");
        block15: for (int i = 0; i < this.schema.numFields(); ++i) {
            String methodFieldName = HollowCodeGenerationUtils.substituteInvalidChars(HollowCodeGenerationUtils.uppercase(this.schema.getFieldName(i)));
            switch (this.schema.getFieldType(i)) {
                case BOOLEAN: {
                    classBuilder.append("    public boolean get").append(methodFieldName).append("(int ordinal);\n\n");
                    classBuilder.append("    public Boolean get").append(methodFieldName).append("Boxed(int ordinal);\n\n");
                    continue block15;
                }
                case BYTES: {
                    classBuilder.append("    public byte[] get").append(methodFieldName).append("(int ordinal);\n\n");
                    continue block15;
                }
                case DOUBLE: {
                    classBuilder.append("    public double get").append(methodFieldName).append("(int ordinal);\n\n");
                    classBuilder.append("    public Double get").append(methodFieldName).append("Boxed(int ordinal);\n\n");
                    continue block15;
                }
                case FLOAT: {
                    classBuilder.append("    public float get").append(methodFieldName).append("(int ordinal);\n\n");
                    classBuilder.append("    public Float get").append(methodFieldName).append("Boxed(int ordinal);\n\n");
                    continue block15;
                }
                case INT: {
                    classBuilder.append("    public int get").append(methodFieldName).append("(int ordinal);\n\n");
                    classBuilder.append("    public Integer get").append(methodFieldName).append("Boxed(int ordinal);\n\n");
                    continue block15;
                }
                case LONG: {
                    classBuilder.append("    public long get").append(methodFieldName).append("(int ordinal);\n\n");
                    classBuilder.append("    public Long get").append(methodFieldName).append("Boxed(int ordinal);\n\n");
                    continue block15;
                }
                case REFERENCE: {
                    HollowErgonomicAPIShortcuts.Shortcut shortcut = this.ergonomicShortcuts.getShortcut(this.schema.getName() + "." + this.schema.getFieldName(i));
                    if (shortcut != null) {
                        switch (shortcut.getType()) {
                            case BOOLEAN: 
                            case DOUBLE: 
                            case FLOAT: 
                            case INT: 
                            case LONG: {
                                classBuilder.append("    public " + HollowCodeGenerationUtils.getJavaScalarType(shortcut.getType()) + " get").append(methodFieldName).append("(int ordinal);\n\n");
                                classBuilder.append("    public " + HollowCodeGenerationUtils.getJavaBoxedType(shortcut.getType()) + " get").append(methodFieldName).append("Boxed(int ordinal);\n\n");
                                break;
                            }
                            case BYTES: {
                                classBuilder.append("    public byte[] get").append(methodFieldName).append("(int ordinal);\n\n");
                                break;
                            }
                            case STRING: {
                                classBuilder.append("    public String get").append(methodFieldName).append("(int ordinal);\n\n");
                                classBuilder.append("    public boolean is").append(methodFieldName).append("Equal(int ordinal, String testValue);\n\n");
                                break;
                            }
                        }
                    }
                    classBuilder.append("    public int get").append(methodFieldName).append("Ordinal(int ordinal);\n\n");
                    continue block15;
                }
                case STRING: {
                    classBuilder.append("    public String get").append(methodFieldName).append("(int ordinal);\n\n");
                    classBuilder.append("    public boolean is").append(methodFieldName).append("Equal(int ordinal, String testValue);\n\n");
                }
            }
        }
        classBuilder.append("    public ").append(HollowCodeGenerationUtils.typeAPIClassname(this.schema.getName())).append(" getTypeAPI();\n\n");
        classBuilder.append("}");
        return classBuilder.toString();
    }
}

