/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.delegate;

import com.netflix.hollow.api.codegen.CodeGeneratorConfig;
import com.netflix.hollow.api.codegen.HollowCodeGenerationUtils;
import com.netflix.hollow.api.codegen.HollowErgonomicAPIShortcuts;
import com.netflix.hollow.api.codegen.delegate.HollowObjectDelegateGenerator;
import com.netflix.hollow.api.custom.HollowTypeAPI;
import com.netflix.hollow.api.objects.delegate.HollowCachedDelegate;
import com.netflix.hollow.api.objects.delegate.HollowObjectAbstractDelegate;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.schema.HollowObjectSchema;

public class HollowObjectDelegateCachedImplGenerator
extends HollowObjectDelegateGenerator {
    public HollowObjectDelegateCachedImplGenerator(String packageName, HollowObjectSchema schema, HollowErgonomicAPIShortcuts ergonomicShortcuts, HollowDataset dataset, CodeGeneratorConfig config) {
        super(packageName, schema, ergonomicShortcuts, dataset, config);
        this.className = HollowCodeGenerationUtils.delegateCachedImplName(schema.getName());
    }

    @Override
    public String generate() {
        int i;
        StringBuilder builder = new StringBuilder();
        this.appendPackageAndCommonImports(builder);
        builder.append("import ").append(HollowObjectAbstractDelegate.class.getName()).append(";\n");
        builder.append("import ").append(HollowObjectTypeDataAccess.class.getName()).append(";\n");
        builder.append("import ").append(HollowObjectSchema.class.getName()).append(";\n");
        builder.append("import ").append(HollowTypeAPI.class.getName()).append(";\n");
        builder.append("import ").append(HollowCachedDelegate.class.getName()).append(";\n");
        builder.append("\n@SuppressWarnings(\"all\")\n");
        builder.append("public class ").append(this.className).append(" extends HollowObjectAbstractDelegate implements HollowCachedDelegate, ").append(HollowCodeGenerationUtils.delegateInterfaceName(this.schema.getName())).append(" {\n\n");
        block15: for (i = 0; i < this.schema.numFields(); ++i) {
            switch (this.schema.getFieldType(i)) {
                case BOOLEAN: {
                    builder.append("    private final Boolean ").append(HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(i))).append(";\n");
                    continue block15;
                }
                case BYTES: {
                    builder.append("    private final byte[] ").append(HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(i))).append(";\n");
                    continue block15;
                }
                case DOUBLE: {
                    builder.append("    private final Double ").append(HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(i))).append(";\n");
                    continue block15;
                }
                case FLOAT: {
                    builder.append("    private final Float ").append(HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(i))).append(";\n");
                    continue block15;
                }
                case INT: {
                    builder.append("    private final Integer ").append(HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(i))).append(";\n");
                    continue block15;
                }
                case LONG: {
                    builder.append("    private final Long ").append(HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(i))).append(";\n");
                    continue block15;
                }
                case REFERENCE: {
                    HollowErgonomicAPIShortcuts.Shortcut shortcut = this.ergonomicShortcuts.getShortcut(this.schema.getName() + "." + this.schema.getFieldName(i));
                    if (shortcut != null) {
                        builder.append("    private final ").append(HollowCodeGenerationUtils.getJavaBoxedType(shortcut.getType())).append(" ").append(HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(i))).append(";\n");
                    }
                    builder.append("    private final int ").append(HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(i))).append("Ordinal;\n");
                    continue block15;
                }
                case STRING: {
                    builder.append("    private final String ").append(HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(i))).append(";\n");
                }
            }
        }
        builder.append("    private ").append(HollowCodeGenerationUtils.typeAPIClassname(this.schema.getName())).append(" typeAPI;\n\n");
        builder.append("    public ").append(this.className).append("(").append(HollowCodeGenerationUtils.typeAPIClassname(this.schema.getName())).append(" typeAPI, int ordinal) {\n");
        block16: for (i = 0; i < this.schema.numFields(); ++i) {
            String fieldName = HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(i));
            switch (this.schema.getFieldType(i)) {
                case BYTES: 
                case STRING: {
                    builder.append("        this.").append(fieldName).append(" = typeAPI.get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("(ordinal);\n");
                    continue block16;
                }
                case BOOLEAN: 
                case DOUBLE: 
                case FLOAT: 
                case INT: 
                case LONG: {
                    builder.append("        this.").append(fieldName).append(" = typeAPI.get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("Boxed(ordinal);\n");
                    continue block16;
                }
                case REFERENCE: {
                    builder.append("        this.").append(fieldName).append("Ordinal = typeAPI.get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("Ordinal(ordinal);\n");
                    HollowErgonomicAPIShortcuts.Shortcut shortcut = this.ergonomicShortcuts.getShortcut(this.schema.getName() + "." + this.schema.getFieldName(i));
                    if (shortcut == null) continue block16;
                    String ordinalVariableName = fieldName + "TempOrdinal";
                    builder.append("        int ").append(ordinalVariableName).append(" = ").append(fieldName).append("Ordinal;\n");
                    for (int j = 0; j < shortcut.getPath().length - 1; ++j) {
                        String typeAPIName = HollowCodeGenerationUtils.typeAPIClassname(shortcut.getPathTypes()[j]);
                        builder.append("        " + ordinalVariableName + " = " + ordinalVariableName + " == -1 ? -1 : typeAPI.getAPI().get").append(typeAPIName).append("().get").append(HollowCodeGenerationUtils.uppercase(shortcut.getPath()[j])).append("Ordinal(").append(ordinalVariableName).append(");\n");
                    }
                    String typeAPIName = HollowCodeGenerationUtils.typeAPIClassname(shortcut.getPathTypes()[shortcut.getPathTypes().length - 1]);
                    builder.append("        this.").append(fieldName).append(" = ").append(ordinalVariableName).append(" == -1 ? null : ").append("typeAPI.getAPI().get").append(typeAPIName).append("().get").append(HollowCodeGenerationUtils.uppercase(shortcut.getPath()[shortcut.getPath().length - 1])).append("(").append(ordinalVariableName).append(");\n");
                }
            }
        }
        builder.append("        this.typeAPI = typeAPI;\n");
        builder.append("    }\n\n");
        for (i = 0; i < this.schema.numFields(); ++i) {
            HollowObjectSchema.FieldType fieldType = this.schema.getFieldType(i);
            String fieldName = HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(i));
            if (this.schema.getFieldType(i) == HollowObjectSchema.FieldType.REFERENCE) {
                HollowErgonomicAPIShortcuts.Shortcut shortcut = this.ergonomicShortcuts.getShortcut(this.schema.getName() + "." + this.schema.getFieldName(i));
                if (shortcut != null) {
                    this.addAccessor(builder, shortcut.getType(), fieldName);
                }
                builder.append("    public int get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("Ordinal(int ordinal) {\n");
                builder.append("        return ").append(fieldName).append("Ordinal;\n");
                builder.append("    }\n\n");
                continue;
            }
            this.addAccessor(builder, fieldType, fieldName);
        }
        builder.append("    @Override\n");
        builder.append("    public HollowObjectSchema getSchema() {\n");
        builder.append("        return typeAPI.getTypeDataAccess().getSchema();\n");
        builder.append("    }\n\n");
        builder.append("    @Override\n");
        builder.append("    public HollowObjectTypeDataAccess getTypeDataAccess() {\n");
        builder.append("        return typeAPI.getTypeDataAccess();\n");
        builder.append("    }\n\n");
        builder.append("    public ").append(HollowCodeGenerationUtils.typeAPIClassname(this.schema.getName())).append(" getTypeAPI() {\n");
        builder.append("        return typeAPI;\n");
        builder.append("    }\n\n");
        builder.append("    public void updateTypeAPI(HollowTypeAPI typeAPI) {\n");
        builder.append("        this.typeAPI = (").append(HollowCodeGenerationUtils.typeAPIClassname(this.schema.getName())).append(") typeAPI;\n");
        builder.append("    }\n\n");
        builder.append("}");
        return builder.toString();
    }

    private void addAccessor(StringBuilder builder, HollowObjectSchema.FieldType fieldType, String fieldName) {
        switch (fieldType) {
            case BOOLEAN: {
                builder.append("    public boolean get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("(int ordinal) {\n");
                builder.append("        if(").append(fieldName).append(" == null)\n");
                builder.append("            return false;\n");
                builder.append("        return ").append(fieldName).append(".booleanValue();\n");
                builder.append("    }\n\n");
                builder.append("    public Boolean get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("Boxed(int ordinal) {\n");
                builder.append("        return ").append(fieldName).append(";\n");
                builder.append("    }\n\n");
                break;
            }
            case BYTES: {
                builder.append("    public byte[] get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("(int ordinal) {\n");
                builder.append("        return (byte[]) ").append(fieldName).append(";\n");
                builder.append("    }\n\n");
                break;
            }
            case DOUBLE: {
                builder.append("    public double get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("(int ordinal) {\n");
                builder.append("        if(").append(fieldName).append(" == null)\n");
                builder.append("            return Double.NaN;\n");
                builder.append("        return ").append(fieldName).append(".doubleValue();\n");
                builder.append("    }\n\n");
                builder.append("    public Double get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("Boxed(int ordinal) {\n");
                builder.append("        return ").append(fieldName).append(";\n");
                builder.append("    }\n\n");
                break;
            }
            case FLOAT: {
                builder.append("    public float get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("(int ordinal) {\n");
                builder.append("        if(").append(fieldName).append(" == null)\n");
                builder.append("            return Float.NaN;\n");
                builder.append("        return ").append(fieldName).append(".floatValue();\n");
                builder.append("    }\n\n");
                builder.append("    public Float get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("Boxed(int ordinal) {\n");
                builder.append("        return ").append(fieldName).append(";\n");
                builder.append("    }\n\n");
                break;
            }
            case INT: {
                builder.append("    public int get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("(int ordinal) {\n");
                builder.append("        if(").append(fieldName).append(" == null)\n");
                builder.append("            return Integer.MIN_VALUE;\n");
                builder.append("        return ").append(fieldName).append(".intValue();\n");
                builder.append("    }\n\n");
                builder.append("    public Integer get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("Boxed(int ordinal) {\n");
                builder.append("        return ").append(fieldName).append(";\n");
                builder.append("    }\n\n");
                break;
            }
            case LONG: {
                builder.append("    public long get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("(int ordinal) {\n");
                builder.append("        if(").append(fieldName).append(" == null)\n");
                builder.append("            return Long.MIN_VALUE;\n");
                builder.append("        return ").append(fieldName).append(".longValue();\n");
                builder.append("    }\n\n");
                builder.append("    public Long get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("Boxed(int ordinal) {\n");
                builder.append("        return ").append(fieldName).append(";\n");
                builder.append("    }\n\n");
                break;
            }
            case STRING: {
                builder.append("    public String get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("(int ordinal) {\n");
                builder.append("        return ").append(fieldName).append(";\n");
                builder.append("    }\n\n");
                builder.append("    public boolean is").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("Equal(int ordinal, String testValue) {\n");
                builder.append("        if(testValue == null)\n");
                builder.append("            return ").append(fieldName).append(" == null;\n");
                builder.append("        return testValue.equals(").append(fieldName).append(");\n");
                builder.append("    }\n\n");
                break;
            }
            case REFERENCE: {
                throw new IllegalArgumentException();
            }
        }
    }
}

