/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.api;

import com.netflix.hollow.api.codegen.CodeGeneratorConfig;
import com.netflix.hollow.api.codegen.HollowCodeGenerationUtils;
import com.netflix.hollow.api.codegen.api.HollowTypeAPIGenerator;
import com.netflix.hollow.api.custom.HollowObjectTypeAPI;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.write.HollowObjectWriteRecord;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class TypeAPIObjectJavaGenerator
extends HollowTypeAPIGenerator {
    private final HollowObjectSchema objectSchema;
    private final Set<Class<?>> importClasses = new TreeSet(new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    });

    public TypeAPIObjectJavaGenerator(String apiClassname, String packageName, HollowObjectSchema schema, HollowDataset dataset, CodeGeneratorConfig config) {
        super(apiClassname, packageName, schema, dataset, config);
        this.objectSchema = schema;
        this.importClasses.add(HollowObjectTypeAPI.class);
        this.importClasses.add(HollowObjectTypeDataAccess.class);
    }

    @Override
    public String generate() {
        StringBuilder classBodyBuilder = new StringBuilder();
        classBodyBuilder.append("@SuppressWarnings(\"all\")\n");
        classBodyBuilder.append("public class " + this.className + " extends HollowObjectTypeAPI {\n\n");
        classBodyBuilder.append("    private final ").append(HollowCodeGenerationUtils.delegateLookupClassname(this.objectSchema)).append(" delegateLookupImpl;\n\n");
        classBodyBuilder.append(this.generateConstructor());
        classBodyBuilder.append("\n\n");
        for (int i = 0; i < this.objectSchema.numFields(); ++i) {
            switch (this.objectSchema.getFieldType(i)) {
                case BOOLEAN: {
                    classBodyBuilder.append(this.generateBooleanFieldAccessor(i));
                    break;
                }
                case BYTES: {
                    classBodyBuilder.append(this.generateByteArrayFieldAccessor(i));
                    break;
                }
                case DOUBLE: {
                    classBodyBuilder.append(this.generateDoubleFieldAccessor(i));
                    break;
                }
                case FLOAT: {
                    classBodyBuilder.append(this.generateFloatFieldAccessor(i));
                    break;
                }
                case INT: {
                    classBodyBuilder.append(this.generateIntFieldAccessor(i));
                    break;
                }
                case LONG: {
                    classBodyBuilder.append(this.generateLongFieldAccessor(i));
                    break;
                }
                case REFERENCE: {
                    classBodyBuilder.append(this.generateReferenceFieldAccessors(i));
                    break;
                }
                case STRING: {
                    classBodyBuilder.append(this.generateStringFieldAccessors(i));
                }
            }
            classBodyBuilder.append("\n\n");
        }
        classBodyBuilder.append("    public ").append(HollowCodeGenerationUtils.delegateLookupClassname(this.objectSchema)).append(" getDelegateLookupImpl() {\n");
        classBodyBuilder.append("        return delegateLookupImpl;\n");
        classBodyBuilder.append("    }\n\n");
        classBodyBuilder.append("    @Override\n");
        classBodyBuilder.append("    public ").append(this.apiClassname).append(" getAPI() {\n");
        classBodyBuilder.append("        return (").append(this.apiClassname).append(") api;\n");
        classBodyBuilder.append("    }\n\n");
        classBodyBuilder.append("}");
        StringBuilder classBuilder = new StringBuilder();
        this.appendPackageAndCommonImports(classBuilder, this.apiClassname);
        for (Class<?> clazz : this.importClasses) {
            classBuilder.append("import ").append(clazz.getName()).append(";\n");
        }
        classBuilder.append("\n");
        classBuilder.append(classBodyBuilder.toString());
        return classBuilder.toString();
    }

    private String generateConstructor() {
        StringBuilder builder = new StringBuilder();
        builder.append("    public " + this.className + "(" + this.apiClassname + " api, HollowObjectTypeDataAccess typeDataAccess) {\n");
        builder.append("        super(api, typeDataAccess, new String[] {\n");
        for (int i = 0; i < this.objectSchema.numFields(); ++i) {
            builder.append("            \"" + this.objectSchema.getFieldName(i) + "\"");
            if (i < this.objectSchema.numFields() - 1) {
                builder.append(",");
            }
            builder.append("\n");
        }
        builder.append("        });\n");
        builder.append("        this.delegateLookupImpl = new ").append(HollowCodeGenerationUtils.delegateLookupClassname(this.objectSchema)).append("(this);\n");
        builder.append("    }");
        return builder.toString();
    }

    private String generateByteArrayFieldAccessor(int fieldNum) {
        StringBuilder builder = new StringBuilder();
        String fieldName = HollowCodeGenerationUtils.substituteInvalidChars(this.objectSchema.getFieldName(fieldNum));
        builder.append("    public byte[] get" + HollowCodeGenerationUtils.uppercase(fieldName) + "(int ordinal) {\n");
        builder.append("        if(fieldIndex[" + fieldNum + "] == -1)\n");
        builder.append("            return missingDataHandler().handleBytes(\"").append(this.objectSchema.getName()).append("\", ordinal, \"").append(fieldName).append("\");\n");
        builder.append("        boxedFieldAccessSampler.recordFieldAccess(fieldIndex[" + fieldNum + "]);\n");
        builder.append("        return getTypeDataAccess().readBytes(ordinal, fieldIndex[" + fieldNum + "]);\n");
        builder.append("    }\n\n");
        return builder.toString();
    }

    private String generateStringFieldAccessors(int fieldNum) {
        StringBuilder builder = new StringBuilder();
        String fieldName = HollowCodeGenerationUtils.substituteInvalidChars(this.objectSchema.getFieldName(fieldNum));
        builder.append("    public String get" + HollowCodeGenerationUtils.uppercase(fieldName) + "(int ordinal) {\n");
        builder.append("        if(fieldIndex[" + fieldNum + "] == -1)\n");
        builder.append("            return missingDataHandler().handleString(\"").append(this.objectSchema.getName()).append("\", ordinal, \"").append(fieldName).append("\");\n");
        builder.append("        boxedFieldAccessSampler.recordFieldAccess(fieldIndex[" + fieldNum + "]);\n");
        builder.append("        return getTypeDataAccess().readString(ordinal, fieldIndex[" + fieldNum + "]);\n");
        builder.append("    }\n\n");
        builder.append("    public boolean is" + HollowCodeGenerationUtils.uppercase(fieldName) + "Equal(int ordinal, String testValue) {\n");
        builder.append("        if(fieldIndex[" + fieldNum + "] == -1)\n");
        builder.append("            return missingDataHandler().handleStringEquals(\"").append(this.objectSchema.getName()).append("\", ordinal, \"").append(fieldName).append("\", testValue);\n");
        builder.append("        return getTypeDataAccess().isStringFieldEqual(ordinal, fieldIndex[" + fieldNum + "], testValue);\n");
        builder.append("    }");
        return builder.toString();
    }

    private String generateReferenceFieldAccessors(int fieldNum) {
        StringBuilder builder = new StringBuilder();
        String fieldName = HollowCodeGenerationUtils.substituteInvalidChars(this.objectSchema.getFieldName(fieldNum));
        String referencedType = HollowCodeGenerationUtils.substituteInvalidChars(this.objectSchema.getReferencedType(fieldNum));
        builder.append("    public int get" + HollowCodeGenerationUtils.uppercase(fieldName) + "Ordinal(int ordinal) {\n");
        builder.append("        if(fieldIndex[" + fieldNum + "] == -1)\n");
        builder.append("            return missingDataHandler().handleReferencedOrdinal(\"").append(this.objectSchema.getName()).append("\", ordinal, \"").append(fieldName).append("\");\n");
        builder.append("        return getTypeDataAccess().readOrdinal(ordinal, fieldIndex[" + fieldNum + "]);\n");
        builder.append("    }\n\n");
        builder.append("    public " + HollowCodeGenerationUtils.typeAPIClassname(referencedType) + " get" + HollowCodeGenerationUtils.uppercase(fieldName) + "TypeAPI() {\n");
        builder.append("        return getAPI().get").append(HollowCodeGenerationUtils.uppercase(referencedType)).append("TypeAPI();\n");
        builder.append("    }");
        return builder.toString();
    }

    private String generateDoubleFieldAccessor(int fieldNum) {
        StringBuilder builder = new StringBuilder();
        String fieldName = HollowCodeGenerationUtils.substituteInvalidChars(this.objectSchema.getFieldName(fieldNum));
        builder.append("    public double get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("(int ordinal) {\n");
        builder.append("        if(fieldIndex[" + fieldNum + "] == -1)\n");
        builder.append("            return missingDataHandler().handleDouble(\"").append(this.objectSchema.getName()).append("\", ordinal, \"").append(fieldName).append("\");\n");
        builder.append("        return getTypeDataAccess().readDouble(ordinal, fieldIndex[" + fieldNum + "]);\n");
        builder.append("    }\n\n");
        builder.append("    public Double get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("Boxed(int ordinal) {\n");
        builder.append("        double d;\n");
        builder.append("        if(fieldIndex[" + fieldNum + "] == -1) {\n");
        builder.append("            d = missingDataHandler().handleDouble(\"").append(this.objectSchema.getName()).append("\", ordinal, \"").append(fieldName).append("\");\n");
        builder.append("        } else {\n");
        builder.append("            boxedFieldAccessSampler.recordFieldAccess(fieldIndex[" + fieldNum + "]);\n");
        builder.append("            d = getTypeDataAccess().readDouble(ordinal, fieldIndex[" + fieldNum + "]);\n");
        builder.append("        }\n");
        builder.append("        return Double.isNaN(d) ? null : Double.valueOf(d);\n");
        builder.append("    }\n\n");
        this.importClasses.add(HollowObjectWriteRecord.class);
        return builder.toString();
    }

    private String generateFloatFieldAccessor(int fieldNum) {
        StringBuilder builder = new StringBuilder();
        String fieldName = HollowCodeGenerationUtils.substituteInvalidChars(this.objectSchema.getFieldName(fieldNum));
        builder.append("    public float get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("(int ordinal) {\n");
        builder.append("        if(fieldIndex[" + fieldNum + "] == -1)\n");
        builder.append("            return missingDataHandler().handleFloat(\"").append(this.objectSchema.getName()).append("\", ordinal, \"").append(fieldName).append("\");\n");
        builder.append("        return getTypeDataAccess().readFloat(ordinal, fieldIndex[" + fieldNum + "]);\n");
        builder.append("    }\n\n");
        builder.append("    public Float get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("Boxed(int ordinal) {\n");
        builder.append("        float f;\n");
        builder.append("        if(fieldIndex[" + fieldNum + "] == -1) {\n");
        builder.append("            f = missingDataHandler().handleFloat(\"").append(this.objectSchema.getName()).append("\", ordinal, \"").append(fieldName).append("\");\n");
        builder.append("        } else {\n");
        builder.append("            boxedFieldAccessSampler.recordFieldAccess(fieldIndex[" + fieldNum + "]);\n");
        builder.append("            f = getTypeDataAccess().readFloat(ordinal, fieldIndex[" + fieldNum + "]);\n");
        builder.append("        }");
        builder.append("        return Float.isNaN(f) ? null : Float.valueOf(f);\n");
        builder.append("    }\n\n");
        this.importClasses.add(HollowObjectWriteRecord.class);
        return builder.toString();
    }

    private String generateLongFieldAccessor(int fieldNum) {
        StringBuilder builder = new StringBuilder();
        String fieldName = HollowCodeGenerationUtils.substituteInvalidChars(this.objectSchema.getFieldName(fieldNum));
        builder.append("    public long get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("(int ordinal) {\n");
        builder.append("        if(fieldIndex[" + fieldNum + "] == -1)\n");
        builder.append("            return missingDataHandler().handleLong(\"").append(this.objectSchema.getName()).append("\", ordinal, \"").append(fieldName).append("\");\n");
        builder.append("        return getTypeDataAccess().readLong(ordinal, fieldIndex[" + fieldNum + "]);\n");
        builder.append("    }\n\n");
        builder.append("    public Long get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("Boxed(int ordinal) {\n");
        builder.append("        long l;\n");
        builder.append("        if(fieldIndex[" + fieldNum + "] == -1) {\n");
        builder.append("            l = missingDataHandler().handleLong(\"").append(this.objectSchema.getName()).append("\", ordinal, \"").append(fieldName).append("\");\n");
        builder.append("        } else {\n");
        builder.append("            boxedFieldAccessSampler.recordFieldAccess(fieldIndex[" + fieldNum + "]);\n");
        builder.append("            l = getTypeDataAccess().readLong(ordinal, fieldIndex[" + fieldNum + "]);\n");
        builder.append("        }\n");
        builder.append("        if(l == Long.MIN_VALUE)\n");
        builder.append("            return null;\n");
        builder.append("        return Long.valueOf(l);\n");
        builder.append("    }\n\n");
        return builder.toString();
    }

    private String generateIntFieldAccessor(int fieldNum) {
        StringBuilder builder = new StringBuilder();
        String fieldName = HollowCodeGenerationUtils.substituteInvalidChars(this.objectSchema.getFieldName(fieldNum));
        builder.append("    public int get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("(int ordinal) {\n");
        builder.append("        if(fieldIndex[" + fieldNum + "] == -1)\n");
        builder.append("            return missingDataHandler().handleInt(\"").append(this.objectSchema.getName()).append("\", ordinal, \"").append(fieldName).append("\");\n");
        builder.append("        return getTypeDataAccess().readInt(ordinal, fieldIndex[" + fieldNum + "]);\n");
        builder.append("    }\n\n");
        builder.append("    public Integer get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("Boxed(int ordinal) {\n");
        builder.append("        int i;\n");
        builder.append("        if(fieldIndex[" + fieldNum + "] == -1) {\n");
        builder.append("            i = missingDataHandler().handleInt(\"").append(this.objectSchema.getName()).append("\", ordinal, \"").append(fieldName).append("\");\n");
        builder.append("        } else {\n");
        builder.append("            boxedFieldAccessSampler.recordFieldAccess(fieldIndex[" + fieldNum + "]);\n");
        builder.append("            i = getTypeDataAccess().readInt(ordinal, fieldIndex[" + fieldNum + "]);\n");
        builder.append("        }\n");
        builder.append("        if(i == Integer.MIN_VALUE)\n");
        builder.append("            return null;\n");
        builder.append("        return Integer.valueOf(i);\n");
        builder.append("    }\n\n");
        return builder.toString();
    }

    private String generateBooleanFieldAccessor(int fieldNum) {
        StringBuilder builder = new StringBuilder();
        String fieldName = HollowCodeGenerationUtils.substituteInvalidChars(this.objectSchema.getFieldName(fieldNum));
        builder.append("    public boolean get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("(int ordinal) {\n");
        builder.append("        if(fieldIndex[" + fieldNum + "] == -1)\n");
        builder.append("            return Boolean.TRUE.equals(missingDataHandler().handleBoolean(\"").append(this.objectSchema.getName()).append("\", ordinal, \"").append(fieldName).append("\"));\n");
        builder.append("        return Boolean.TRUE.equals(getTypeDataAccess().readBoolean(ordinal, fieldIndex[" + fieldNum + "]));\n");
        builder.append("    }\n\n");
        builder.append("    public Boolean get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("Boxed(int ordinal) {\n");
        builder.append("        if(fieldIndex[" + fieldNum + "] == -1)\n");
        builder.append("            return missingDataHandler().handleBoolean(\"").append(this.objectSchema.getName()).append("\", ordinal, \"").append(fieldName).append("\");\n");
        builder.append("        return getTypeDataAccess().readBoolean(ordinal, fieldIndex[" + fieldNum + "]);\n");
        builder.append("    }\n\n");
        return builder.toString();
    }
}

