/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.api;

import com.netflix.hollow.api.codegen.CodeGeneratorConfig;
import com.netflix.hollow.api.codegen.HollowCodeGenerationUtils;
import com.netflix.hollow.api.codegen.api.HollowTypeAPIGenerator;
import com.netflix.hollow.api.custom.HollowListTypeAPI;
import com.netflix.hollow.api.objects.delegate.HollowListLookupDelegate;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.read.dataaccess.HollowListTypeDataAccess;
import com.netflix.hollow.core.schema.HollowListSchema;

public class TypeAPIListJavaGenerator
extends HollowTypeAPIGenerator {
    private final HollowListSchema schema;

    public TypeAPIListJavaGenerator(String apiClassname, String packageName, HollowListSchema schema, HollowDataset dataset, CodeGeneratorConfig config) {
        super(apiClassname, packageName, schema, dataset, config);
        this.schema = schema;
    }

    @Override
    public String generate() {
        StringBuilder builder = new StringBuilder();
        this.appendPackageAndCommonImports(builder, this.apiClassname);
        builder.append("import " + HollowListTypeAPI.class.getName() + ";\n\n");
        builder.append("import " + HollowListTypeDataAccess.class.getName() + ";\n");
        builder.append("import " + HollowListLookupDelegate.class.getName() + ";\n");
        builder.append("\n@SuppressWarnings(\"all\")\n");
        builder.append("public class ").append(this.className).append(" extends HollowListTypeAPI {\n\n");
        builder.append("    private final ").append(HollowCodeGenerationUtils.delegateLookupClassname(this.schema)).append(" delegateLookupImpl;\n\n");
        builder.append("    public ").append(this.className).append("(").append(this.apiClassname).append(" api, HollowListTypeDataAccess dataAccess) {\n");
        builder.append("        super(api, dataAccess);\n");
        builder.append("        this.delegateLookupImpl = new ").append(HollowCodeGenerationUtils.delegateLookupClassname(this.schema)).append("(this);\n");
        builder.append("    }\n\n");
        builder.append("    public ").append(HollowCodeGenerationUtils.typeAPIClassname(this.schema.getElementType())).append(" getElementAPI() {\n");
        builder.append("        return getAPI().get").append(HollowCodeGenerationUtils.typeAPIClassname(this.schema.getElementType())).append("();\n");
        builder.append("    }\n\n");
        builder.append("    public ").append(HollowCodeGenerationUtils.delegateLookupClassname(this.schema)).append(" getDelegateLookupImpl() {\n");
        builder.append("        return delegateLookupImpl;\n");
        builder.append("    }\n\n");
        builder.append("    public ").append(this.apiClassname).append(" getAPI() {\n");
        builder.append("        return (").append(this.apiClassname).append(")api;\n");
        builder.append("    }\n\n");
        builder.append("}");
        return builder.toString();
    }
}

