/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.api;

import com.netflix.hollow.api.codegen.CodeGeneratorConfig;
import com.netflix.hollow.api.codegen.HollowConsumerJavaFileGenerator;
import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.api.consumer.data.AbstractHollowDataAccessor;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import java.util.Arrays;

public class HollowDataAccessorGenerator
extends HollowConsumerJavaFileGenerator {
    public static final String SUB_PACKAGE_NAME = "accessor";
    protected final String apiclassName;
    protected final String type;
    protected final HollowObjectSchema schema;

    public HollowDataAccessorGenerator(String packageName, String apiclassName, HollowObjectSchema schema, HollowDataset dataset, CodeGeneratorConfig config) {
        super(packageName, SUB_PACKAGE_NAME, dataset, config);
        this.className = this.getClassName(schema);
        this.apiclassName = apiclassName;
        this.type = this.hollowImplClassname(schema.getName());
        this.schema = schema;
    }

    protected String getClassName(HollowObjectSchema schema) {
        return schema.getName() + "DataAccessor";
    }

    @Override
    public String generate() {
        StringBuilder builder = new StringBuilder();
        this.appendPackageAndCommonImports(builder, this.apiclassName, Arrays.asList(this.schema));
        builder.append("import " + HollowConsumer.class.getName() + ";\n");
        builder.append("import " + AbstractHollowDataAccessor.class.getName() + ";\n");
        builder.append("import " + PrimaryKey.class.getName() + ";\n");
        builder.append("import " + HollowReadStateEngine.class.getName() + ";\n");
        builder.append("\n");
        builder.append("@SuppressWarnings(\"all\")\n");
        builder.append("public class " + this.className + " extends " + AbstractHollowDataAccessor.class.getSimpleName() + "<" + this.type + "> {\n\n");
        builder.append("    public static final String TYPE = \"" + this.schema.getName() + "\";\n");
        builder.append("    private " + this.apiclassName + " api;\n\n");
        this.genConstructors(builder);
        this.genPublicAPIs(builder);
        builder.append("}");
        return builder.toString();
    }

    protected void genConstructors(StringBuilder builder) {
        builder.append("    public " + this.className + "(HollowConsumer consumer) {\n");
        builder.append("        super(consumer, TYPE);\n");
        builder.append("        this.api = (" + this.apiclassName + ")consumer.getAPI();\n");
        builder.append("    }\n\n");
        builder.append("    public " + this.className + "(HollowReadStateEngine rStateEngine, " + this.apiclassName + " api) {\n");
        builder.append("        super(rStateEngine, TYPE);\n");
        builder.append("        this.api = api;\n");
        builder.append("    }\n\n");
        builder.append("    public " + this.className + "(HollowReadStateEngine rStateEngine, " + this.apiclassName + " api, String ... fieldPaths) {\n");
        builder.append("        super(rStateEngine, TYPE, fieldPaths);\n");
        builder.append("        this.api = api;\n");
        builder.append("    }\n\n");
        builder.append("    public " + this.className + "(HollowReadStateEngine rStateEngine, " + this.apiclassName + " api, PrimaryKey primaryKey) {\n");
        builder.append("        super(rStateEngine, TYPE, primaryKey);\n");
        builder.append("        this.api = api;\n");
        builder.append("    }\n\n");
    }

    protected void genPublicAPIs(StringBuilder builder) {
        builder.append("    @Override public " + this.type + " getRecord(int ordinal){\n");
        builder.append("        return api.get" + this.type + "(ordinal);\n");
        builder.append("    }\n\n");
    }
}

