/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen;

import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HollowErgonomicAPIShortcuts {
    public static final HollowErgonomicAPIShortcuts NO_SHORTCUTS = new HollowErgonomicAPIShortcuts();
    private final Map<String, Shortcut> shortcutFieldPaths;

    private HollowErgonomicAPIShortcuts() {
        this.shortcutFieldPaths = Collections.emptyMap();
    }

    HollowErgonomicAPIShortcuts(HollowDataset dataset) {
        this.shortcutFieldPaths = new HashMap<String, Shortcut>();
        this.populatePaths(dataset);
    }

    public Shortcut getShortcut(String typeField) {
        return this.shortcutFieldPaths.get(typeField);
    }

    int numShortcuts() {
        return this.shortcutFieldPaths.size();
    }

    private void populatePaths(HollowDataset dataset) {
        for (HollowSchema schema : dataset.getSchemas()) {
            if (schema.getSchemaType() != HollowSchema.SchemaType.OBJECT) continue;
            HollowObjectSchema objSchema = (HollowObjectSchema)schema;
            for (int i = 0; i < objSchema.numFields(); ++i) {
                Shortcut shortcut;
                HollowSchema refSchema;
                if (objSchema.getFieldType(i) != HollowObjectSchema.FieldType.REFERENCE || (refSchema = dataset.getSchema(objSchema.getReferencedType(i))) == null || (shortcut = this.getShortcutFieldPath(dataset, refSchema)) == null) continue;
                String key = objSchema.getName() + "." + objSchema.getFieldName(i);
                this.shortcutFieldPaths.put(key, shortcut);
            }
        }
    }

    private Shortcut getShortcutFieldPath(HollowDataset dataset, HollowSchema schema) {
        HollowObjectSchema objSchema;
        if (schema.getSchemaType() == HollowSchema.SchemaType.OBJECT && (objSchema = (HollowObjectSchema)schema).numFields() == 1) {
            if (objSchema.getFieldType(0) == HollowObjectSchema.FieldType.REFERENCE) {
                Shortcut childShortcut;
                HollowSchema refSchema = dataset.getSchema(objSchema.getReferencedType(0));
                if (refSchema != null && (childShortcut = this.getShortcutFieldPath(dataset, refSchema)) != null) {
                    String[] shortcutPathTypes = new String[childShortcut.getPathTypes().length + 1];
                    String[] shortcutPath = new String[childShortcut.getPath().length + 1];
                    shortcutPathTypes[0] = objSchema.getName();
                    shortcutPath[0] = objSchema.getFieldName(0);
                    System.arraycopy(childShortcut.getPath(), 0, shortcutPath, 1, childShortcut.getPath().length);
                    System.arraycopy(childShortcut.getPathTypes(), 0, shortcutPathTypes, 1, childShortcut.getPathTypes().length);
                    return new Shortcut(shortcutPathTypes, shortcutPath, childShortcut.getType());
                }
            } else {
                return new Shortcut(new String[]{objSchema.getName()}, new String[]{objSchema.getFieldName(0)}, objSchema.getFieldType(0));
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Shortcut> entry : this.shortcutFieldPaths.entrySet()) {
            builder.append(entry.getKey() + ": " + entry.getValue()).append("\n");
        }
        return builder.toString();
    }

    public static class Shortcut {
        public final String[] pathTypes;
        public final String[] path;
        public final HollowObjectSchema.FieldType type;

        public Shortcut(String[] pathTypes, String[] path, HollowObjectSchema.FieldType type) {
            this.pathTypes = pathTypes;
            this.path = path;
            this.type = type;
        }

        public String[] getPath() {
            return this.path;
        }

        public String[] getPathTypes() {
            return this.pathTypes;
        }

        public HollowObjectSchema.FieldType getType() {
            return this.type;
        }

        public String toString() {
            return Arrays.toString(this.path) + " (" + this.type.toString() + ")";
        }
    }
}

