/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen;

import com.netflix.hollow.api.codegen.CodeGeneratorConfig;
import com.netflix.hollow.api.codegen.HollowCodeGenerationUtils;
import com.netflix.hollow.api.codegen.HollowJavaFileGenerator;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class HollowConsumerJavaFileGenerator
implements HollowJavaFileGenerator {
    protected final String packageName;
    protected final String subPackageName;
    protected final CodeGeneratorConfig config;
    protected final HollowDataset dataset;
    protected String className;
    protected boolean useCollectionsImport = false;

    public HollowConsumerJavaFileGenerator(String packageName, String subPackageName, HollowDataset dataset, CodeGeneratorConfig config) {
        this.dataset = dataset;
        this.packageName = packageName;
        this.subPackageName = subPackageName;
        this.config = config;
    }

    protected String hollowImplClassname(String typeName) {
        return HollowCodeGenerationUtils.hollowImplClassname(typeName, this.config.getClassPostfix(), this.config.isUseAggressiveSubstitutions(), this.config.isUseHollowPrimitiveTypes());
    }

    public String getSubPackageName() {
        return this.subPackageName;
    }

    @Override
    public final String getClassName() {
        return this.className;
    }

    public void useCollectionsImport() {
        this.useCollectionsImport = true;
    }

    protected void appendPackageAndCommonImports(StringBuilder builder) {
        this.appendPackageAndCommonImports(builder, null, new ArrayList<HollowSchema>());
    }

    protected void appendPackageAndCommonImports(StringBuilder builder, String apiClassname) {
        this.appendPackageAndCommonImports(builder, apiClassname, new ArrayList<HollowSchema>());
    }

    protected void appendPackageAndCommonImports(StringBuilder builder, String apiClassname, List<HollowSchema> schemasToImport) {
        String fullPackageName = this.createFullPackageName(this.packageName, this.subPackageName, this.config.isUsePackageGrouping());
        if (!this.isEmpty(fullPackageName)) {
            builder.append("package ").append(fullPackageName).append(";\n\n");
            if (this.config.isUseHollowPrimitiveTypes()) {
                builder.append("import com.netflix.hollow.core.type.*;\n");
            }
            if (this.config.isUsePackageGrouping()) {
                if (apiClassname != null) {
                    this.appendImportFromBasePackage(builder, apiClassname);
                }
                HashSet<String> schemaNameSet = new HashSet<String>();
                block6: for (HollowSchema schema : schemasToImport) {
                    switch (schema.getSchemaType()) {
                        case OBJECT: {
                            this.addToSetIfNotPrimitiveOrCollection(schemaNameSet, schema.getName());
                            continue block6;
                        }
                        case SET: {
                            this.addToSetIfNotPrimitiveOrCollection(schemaNameSet, ((HollowSetSchema)schema).getElementType());
                            continue block6;
                        }
                        case LIST: {
                            this.addToSetIfNotPrimitiveOrCollection(schemaNameSet, ((HollowListSchema)schema).getElementType());
                            continue block6;
                        }
                        case MAP: {
                            HollowMapSchema mapSchema = (HollowMapSchema)schema;
                            this.addToSetIfNotPrimitiveOrCollection(schemaNameSet, mapSchema.getKeyType(), mapSchema.getValueType());
                            continue block6;
                        }
                    }
                    throw new IllegalArgumentException("Unexpected HollowSchema to import: " + schema);
                }
                for (String schemaName : schemaNameSet) {
                    this.appendImportFromBasePackage(builder, schemaName + this.config.getClassPostfix());
                }
                this.appendImportFromBasePackage(builder, "core.*");
                if (this.useCollectionsImport) {
                    this.appendImportFromBasePackage(builder, "collections.*");
                }
                builder.append("\n");
            }
        }
    }

    private String createFullPackageName(String packageName, String subPackageName, boolean usePackageGrouping) {
        if (usePackageGrouping && !this.isEmpty(packageName) && !this.isEmpty(subPackageName)) {
            return packageName + "." + subPackageName;
        }
        return packageName;
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    private void appendImportFromBasePackage(StringBuilder builder, String leaf) {
        builder.append("import ").append(this.packageName).append(".").append(leaf).append(";\n");
    }

    private void addToSetIfNotPrimitiveOrCollection(Set<String> schemaNameSet, String ... schemaNames) {
        for (String schemaName : schemaNames) {
            if (HollowCodeGenerationUtils.isCollectionType(schemaName, this.dataset) || HollowCodeGenerationUtils.isPrimitiveType(schemaName)) continue;
            schemaNameSet.add(schemaName);
        }
    }
}

