/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen;

import com.netflix.hollow.api.codegen.AbstractHollowAPIGeneratorBuilder;
import com.netflix.hollow.api.codegen.ArgumentParser;
import com.netflix.hollow.api.codegen.CodeGeneratorConfig;
import com.netflix.hollow.api.codegen.HollowAPIClassJavaGenerator;
import com.netflix.hollow.api.codegen.HollowAPIFactoryJavaGenerator;
import com.netflix.hollow.api.codegen.HollowCodeGenerationUtils;
import com.netflix.hollow.api.codegen.HollowConsumerJavaFileGenerator;
import com.netflix.hollow.api.codegen.HollowErgonomicAPIShortcuts;
import com.netflix.hollow.api.codegen.HollowJavaFileGenerator;
import com.netflix.hollow.api.codegen.api.HollowDataAccessorGenerator;
import com.netflix.hollow.api.codegen.api.TypeAPIListJavaGenerator;
import com.netflix.hollow.api.codegen.api.TypeAPIMapJavaGenerator;
import com.netflix.hollow.api.codegen.api.TypeAPIObjectJavaGenerator;
import com.netflix.hollow.api.codegen.api.TypeAPISetJavaGenerator;
import com.netflix.hollow.api.codegen.delegate.HollowObjectDelegateCachedImplGenerator;
import com.netflix.hollow.api.codegen.delegate.HollowObjectDelegateInterfaceGenerator;
import com.netflix.hollow.api.codegen.delegate.HollowObjectDelegateLookupImplGenerator;
import com.netflix.hollow.api.codegen.indexes.HollowHashIndexGenerator;
import com.netflix.hollow.api.codegen.indexes.HollowPrimaryKeyIndexGenerator;
import com.netflix.hollow.api.codegen.indexes.HollowUniqueKeyIndexGenerator;
import com.netflix.hollow.api.codegen.indexes.LegacyHollowPrimaryKeyIndexGenerator;
import com.netflix.hollow.api.codegen.objects.HollowFactoryJavaGenerator;
import com.netflix.hollow.api.codegen.objects.HollowListJavaGenerator;
import com.netflix.hollow.api.codegen.objects.HollowMapJavaGenerator;
import com.netflix.hollow.api.codegen.objects.HollowObjectJavaGenerator;
import com.netflix.hollow.api.codegen.objects.HollowSetJavaGenerator;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.util.HollowWriteStateCreator;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.objectmapper.HollowObjectMapper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;

public class HollowAPIGenerator {
    protected final String apiClassname;
    protected final String packageName;
    protected final Path destinationPath;
    protected final HollowDataset dataset;
    protected final Set<String> parameterizedTypes;
    protected final boolean parameterizeClassNames;
    protected final boolean hasCollectionsInDataSet;
    protected final HollowErgonomicAPIShortcuts ergonomicShortcuts;
    protected CodeGeneratorConfig config = new CodeGeneratorConfig("Hollow", "_");

    public HollowAPIGenerator(String apiClassname, String packageName, HollowDataset dataset) {
        this(apiClassname, packageName, dataset, Collections.emptySet(), false, false);
    }

    public HollowAPIGenerator(String apiClassname, String packageName, HollowDataset dataset, Path destinationPath) {
        this(apiClassname, packageName, dataset, Collections.emptySet(), false, false, destinationPath);
    }

    public HollowAPIGenerator(String apiClassname, String packageName, HollowDataset dataset, boolean parameterizeAllClassNames) {
        this(apiClassname, packageName, dataset, Collections.emptySet(), parameterizeAllClassNames, false);
    }

    public HollowAPIGenerator(String apiClassname, String packageName, HollowDataset dataset, boolean parameterizeAllClassNames, Path destinationPath) {
        this(apiClassname, packageName, dataset, Collections.emptySet(), parameterizeAllClassNames, false, destinationPath);
    }

    public HollowAPIGenerator(String apiClassname, String packageName, HollowDataset dataset, Set<String> parameterizeSpecificTypeNames) {
        this(apiClassname, packageName, dataset, parameterizeSpecificTypeNames, false, false);
    }

    public HollowAPIGenerator(String apiClassname, String packageName, HollowDataset dataset, Set<String> parameterizedTypes, Path destinationPath) {
        this(apiClassname, packageName, dataset, parameterizedTypes, false, false, destinationPath);
    }

    protected HollowAPIGenerator(String apiClassname, String packageName, HollowDataset dataset, Set<String> parameterizedTypes, boolean parameterizeAllClassNames, boolean useErgonomicShortcuts) {
        this(apiClassname, packageName, dataset, parameterizedTypes, parameterizeAllClassNames, useErgonomicShortcuts, null);
    }

    protected HollowAPIGenerator(String apiClassname, String packageName, HollowDataset dataset, Set<String> parameterizedTypes, boolean parameterizeAllClassNames, boolean useErgonomicShortcuts, Path destinationPath) {
        this.apiClassname = apiClassname;
        this.packageName = packageName;
        this.dataset = dataset;
        this.hasCollectionsInDataSet = HollowAPIGenerator.hasCollectionsInDataSet(dataset);
        this.parameterizedTypes = parameterizedTypes;
        this.parameterizeClassNames = parameterizeAllClassNames;
        HollowErgonomicAPIShortcuts hollowErgonomicAPIShortcuts = this.ergonomicShortcuts = useErgonomicShortcuts ? new HollowErgonomicAPIShortcuts(dataset) : HollowErgonomicAPIShortcuts.NO_SHORTCUTS;
        if (destinationPath != null && packageName != null && !packageName.trim().isEmpty()) {
            Path packagePath = Paths.get(packageName.replace(".", File.separator), new String[0]);
            if (!destinationPath.toAbsolutePath().endsWith(packagePath)) {
                destinationPath = destinationPath.resolve(packagePath);
            }
        }
        this.destinationPath = destinationPath;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        if (args.length == 0) {
            System.out.println("Usage:\njava " + HollowAPIGenerator.class.getName() + " --arg1=value1 --arg2=value2\nsee " + GeneratorArguments.class.getName() + " for available arguments.");
            return;
        }
        HollowWriteStateEngine engine = new HollowWriteStateEngine();
        Builder builder = new Builder();
        HollowObjectMapper mapper = new HollowObjectMapper(engine);
        ArgumentParser<GeneratorArguments> argumentParser = new ArgumentParser<GeneratorArguments>(GeneratorArguments.class, args);
        block10: for (ArgumentParser.ParsedArgument arg : argumentParser.getParsedArguments()) {
            switch ((GeneratorArguments)((Object)arg.getKey())) {
                case addToDataModel: {
                    mapper.initializeTypeState(HollowAPIGenerator.class.getClassLoader().loadClass(arg.getValue()));
                    continue block10;
                }
                case addSchemaFileToDataModel: {
                    HollowWriteStateCreator.readSchemaFileIntoWriteState(arg.getValue(), engine);
                    continue block10;
                }
                case apiClassName: {
                    builder.withAPIClassname(arg.getValue());
                    continue block10;
                }
                case classPostfix: {
                    builder.withClassPostfix(arg.getValue());
                    continue block10;
                }
                case getterPrefix: {
                    builder.withGetterPrefix(arg.getValue());
                    continue block10;
                }
                case packageName: {
                    builder.withPackageName(arg.getValue());
                    continue block10;
                }
                case pathToGeneratedFiles: {
                    builder.withDestination(arg.getValue());
                    continue block10;
                }
                case parameterizeAllClassNames: {
                    builder.withParameterizeAllClassNames(Boolean.valueOf(arg.getValue()));
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Unhandled argument " + arg.getKey());
        }
        ((HollowAPIGenerator)((Builder)builder.withDataModel(engine)).build()).generateSourceFiles();
    }

    protected static boolean hasCollectionsInDataSet(HollowDataset dataset) {
        for (HollowSchema schema : dataset.getSchemas()) {
            if (!(schema instanceof HollowListSchema) && !(schema instanceof HollowSetSchema) && !(schema instanceof HollowMapSchema)) continue;
            return true;
        }
        return false;
    }

    protected void setCodeGeneratorConfig(CodeGeneratorConfig config) {
        this.config = config;
    }

    public void setClassPostfix(String classPostfix) {
        this.config.setClassPostfix(classPostfix);
    }

    public void setGetterPrefix(String getterPrefix) {
        this.config.setGetterPrefix(getterPrefix);
    }

    public void setUseAggressiveSubstitutions(boolean useAggressiveSubstitutions) {
        this.config.setUseAggressiveSubstitutions(useAggressiveSubstitutions);
    }

    public void setUseBooleanFieldErgonomics(boolean useBooleanFieldErgonomics) {
        this.config.setUseBooleanFieldErgonomics(useBooleanFieldErgonomics);
    }

    public void setUsePackageGrouping(boolean usePackageGrouping) {
        this.config.setUsePackageGrouping(usePackageGrouping);
    }

    public void reservePrimaryKeyIndexForTypeWithPrimaryKey(boolean reservePrimaryKeyIndexForTypeWithPrimaryKey) {
        this.config.setReservePrimaryKeyIndexForTypeWithPrimaryKey(reservePrimaryKeyIndexForTypeWithPrimaryKey);
    }

    public void setUseHollowPrimitiveTypes(boolean useHollowPrimitiveTypes) {
        this.config.setUseHollowPrimitiveTypes(useHollowPrimitiveTypes);
    }

    public void setRestrictApiToFieldType(boolean restrictApiToFieldType) {
        this.config.setRestrictApiToFieldType(restrictApiToFieldType);
    }

    public void generateSourceFiles() throws IOException {
        this.generateFiles(this.destinationPath.toFile());
    }

    public void generateFiles(String directory) throws IOException {
        this.generateFiles(new File(directory));
    }

    public void generateFiles(File directory) throws IOException {
        if (this.packageName != null && !this.packageName.trim().isEmpty()) {
            String packageDir = this.packageName.replace(".", File.separator);
            if (!directory.getAbsolutePath().endsWith(packageDir)) {
                directory = new File(directory, packageDir);
            }
        }
        directory.mkdirs();
        HollowAPIClassJavaGenerator apiClassGenerator = new HollowAPIClassJavaGenerator(this.packageName, this.apiClassname, this.dataset, this.parameterizeClassNames, this.config);
        HollowAPIFactoryJavaGenerator apiFactoryGenerator = new HollowAPIFactoryJavaGenerator(this.packageName, this.apiClassname, this.dataset, this.config);
        HollowHashIndexGenerator hashIndexGenerator = new HollowHashIndexGenerator(this.packageName, this.apiClassname, this.dataset, this.config);
        this.generateFile(directory, apiClassGenerator);
        this.generateFile(directory, apiFactoryGenerator);
        this.generateFile(directory, hashIndexGenerator);
        this.generateFilesForHollowSchemas(directory);
    }

    protected void generateSourceFilesForHollowSchemas() throws IOException {
        this.generateFilesForHollowSchemas(this.destinationPath.toFile());
    }

    protected void generateFilesForHollowSchemas(File directory) throws IOException {
        for (HollowSchema schema : this.dataset.getSchemas()) {
            String type = schema.getName();
            if (this.config.isUseHollowPrimitiveTypes() && HollowCodeGenerationUtils.isPrimitiveType(type)) continue;
            this.generateFile(directory, this.getStaticAPIGenerator(schema));
            this.generateFile(directory, this.getHollowObjectGenerator(schema));
            this.generateFile(directory, this.getHollowFactoryGenerator(schema));
            if (schema.getSchemaType() != HollowSchema.SchemaType.OBJECT) continue;
            HollowObjectSchema objSchema = (HollowObjectSchema)schema;
            this.generateFile(directory, new HollowObjectDelegateInterfaceGenerator(this.packageName, objSchema, this.ergonomicShortcuts, this.dataset, this.config));
            this.generateFile(directory, new HollowObjectDelegateCachedImplGenerator(this.packageName, objSchema, this.ergonomicShortcuts, this.dataset, this.config));
            this.generateFile(directory, new HollowObjectDelegateLookupImplGenerator(this.packageName, objSchema, this.ergonomicShortcuts, this.dataset, this.config));
            this.generateFile(directory, new HollowDataAccessorGenerator(this.packageName, this.apiClassname, objSchema, this.dataset, this.config));
            if (!this.config.isReservePrimaryKeyIndexForTypeWithPrimaryKey()) {
                this.generateFile(directory, new LegacyHollowPrimaryKeyIndexGenerator(this.packageName, this.apiClassname, objSchema, this.dataset, this.config));
                continue;
            }
            if (objSchema.getPrimaryKey() == null) continue;
            this.generateFile(directory, new HollowPrimaryKeyIndexGenerator(this.dataset, this.packageName, this.apiClassname, objSchema, this.config));
            this.generateFile(directory, new HollowUniqueKeyIndexGenerator(this.packageName, this.apiClassname, objSchema, this.dataset, this.config));
        }
    }

    protected void generateSourceFile(HollowJavaFileGenerator generator) throws IOException {
        this.generateFile(this.destinationPath.toFile(), generator);
    }

    protected void generateFile(File directory, HollowJavaFileGenerator generator) throws IOException {
        if (this.packageName != null && !this.packageName.trim().isEmpty() && this.config.isUsePackageGrouping() && generator instanceof HollowConsumerJavaFileGenerator) {
            HollowConsumerJavaFileGenerator consumerCodeGenerator = (HollowConsumerJavaFileGenerator)generator;
            if (this.hasCollectionsInDataSet) {
                consumerCodeGenerator.useCollectionsImport();
            }
            directory = new File(directory, consumerCodeGenerator.getSubPackageName());
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
        FileWriter writer = new FileWriter(new File(directory, generator.getClassName() + ".java"));
        writer.write(generator.generate());
        writer.close();
    }

    protected HollowJavaFileGenerator getStaticAPIGenerator(HollowSchema schema) {
        if (schema instanceof HollowObjectSchema) {
            return new TypeAPIObjectJavaGenerator(this.apiClassname, this.packageName, (HollowObjectSchema)schema, this.dataset, this.config);
        }
        if (schema instanceof HollowListSchema) {
            return new TypeAPIListJavaGenerator(this.apiClassname, this.packageName, (HollowListSchema)schema, this.dataset, this.config);
        }
        if (schema instanceof HollowSetSchema) {
            return new TypeAPISetJavaGenerator(this.apiClassname, this.packageName, (HollowSetSchema)schema, this.dataset, this.config);
        }
        if (schema instanceof HollowMapSchema) {
            return new TypeAPIMapJavaGenerator(this.apiClassname, this.packageName, (HollowMapSchema)schema, this.dataset, this.config);
        }
        throw new UnsupportedOperationException("What kind of schema is a " + schema.getClass().getName() + "?");
    }

    protected HollowJavaFileGenerator getHollowObjectGenerator(HollowSchema schema) {
        if (schema instanceof HollowObjectSchema) {
            return new HollowObjectJavaGenerator(this.packageName, this.apiClassname, (HollowObjectSchema)schema, this.parameterizedTypes, this.parameterizeClassNames, this.ergonomicShortcuts, this.dataset, this.config);
        }
        if (schema instanceof HollowListSchema) {
            return new HollowListJavaGenerator(this.packageName, this.apiClassname, (HollowListSchema)schema, this.parameterizedTypes, this.parameterizeClassNames, this.dataset, this.config);
        }
        if (schema instanceof HollowSetSchema) {
            return new HollowSetJavaGenerator(this.packageName, this.apiClassname, (HollowSetSchema)schema, this.parameterizedTypes, this.parameterizeClassNames, this.dataset, this.config);
        }
        if (schema instanceof HollowMapSchema) {
            return new HollowMapJavaGenerator(this.packageName, this.apiClassname, (HollowMapSchema)schema, this.dataset, this.parameterizedTypes, this.parameterizeClassNames, this.config);
        }
        throw new UnsupportedOperationException("What kind of schema is a " + schema.getClass().getName() + "?");
    }

    protected HollowFactoryJavaGenerator getHollowFactoryGenerator(HollowSchema schema) {
        return new HollowFactoryJavaGenerator(this.packageName, schema, this.dataset, this.config);
    }

    public static class Builder
    extends AbstractHollowAPIGeneratorBuilder<Builder, HollowAPIGenerator> {
        @Override
        protected HollowAPIGenerator instantiateGenerator() {
            return new HollowAPIGenerator(this.apiClassname, this.packageName, this.dataset, this.parameterizedTypes, this.parameterizeAllClassNames, this.useErgonomicShortcuts, this.destinationPath);
        }

        @Override
        protected Builder getBuilder() {
            return this;
        }
    }

    public static enum GeneratorArguments {
        addToDataModel,
        addSchemaFileToDataModel,
        apiClassName,
        classPostfix,
        getterPrefix,
        packageName,
        pathToGeneratedFiles,
        parameterizeAllClassNames;

    }
}

