/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class StackTraceRecorder {
    private final int maxStackTraceElementsToRecord;
    private final ConcurrentHashMap<String, StackTraceNode> rootNodes;

    public StackTraceRecorder(int maxStackTraceElementsToRecord) {
        this.maxStackTraceElementsToRecord = maxStackTraceElementsToRecord;
        this.rootNodes = new ConcurrentHashMap();
    }

    public void recordStackTrace() {
        this.recordStackTrace(1);
    }

    public void recordStackTrace(int omitFirstNFrames) {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        if (stackTrace.length <= ++omitFirstNFrames) {
            return;
        }
        int maxFrameIndexToRecord = Math.min(stackTrace.length, this.maxStackTraceElementsToRecord + omitFirstNFrames);
        StackTraceNode node = this.getNode(stackTrace[omitFirstNFrames], this.rootNodes);
        node.increment();
        for (int i = omitFirstNFrames + 1; i < maxFrameIndexToRecord; ++i) {
            node = node.getChild(stackTrace[i]);
            node.increment();
        }
    }

    public Map<String, StackTraceNode> getRootNodes() {
        return this.rootNodes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, StackTraceNode> entry : this.rootNodes.entrySet()) {
            this.append(builder, entry.getValue(), 0);
        }
        return builder.toString();
    }

    private void append(StringBuilder builder, StackTraceNode node, int level) {
        for (int i = 0; i < level; ++i) {
            builder.append("  ");
        }
        builder.append(node.getTraceLine()).append(" (").append(node.getCount()).append(")\n");
        for (Map.Entry<String, StackTraceNode> entry : node.getChildren().entrySet()) {
            this.append(builder, entry.getValue(), level + 1);
        }
    }

    private StackTraceNode getNode(StackTraceElement element, ConcurrentHashMap<String, StackTraceNode> nodes) {
        String line = element.toString();
        StackTraceNode node = nodes.get(line);
        if (node != null) {
            return node;
        }
        node = new StackTraceNode(line);
        StackTraceNode existingNode = nodes.putIfAbsent(line, node);
        return existingNode == null ? node : existingNode;
    }

    public class StackTraceNode {
        private final String traceLine;
        private final AtomicInteger count;
        private final ConcurrentHashMap<String, StackTraceNode> children;

        public StackTraceNode(String traceLine) {
            this.traceLine = traceLine;
            this.count = new AtomicInteger(0);
            this.children = new ConcurrentHashMap(2);
        }

        public String getTraceLine() {
            return this.traceLine;
        }

        public int getCount() {
            return this.count.get();
        }

        public Map<String, StackTraceNode> getChildren() {
            return this.children;
        }

        public void increment() {
            this.count.incrementAndGet();
        }

        public StackTraceNode getChild(StackTraceElement element) {
            return StackTraceRecorder.this.getNode(element, this.children);
        }
    }
}

