/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.client;

import com.netflix.hollow.api.client.FailedTransitionTracker;
import com.netflix.hollow.api.client.HollowAPIFactory;
import com.netflix.hollow.api.client.HollowDataHolder;
import com.netflix.hollow.api.client.HollowUpdatePlan;
import com.netflix.hollow.api.client.HollowUpdatePlanner;
import com.netflix.hollow.api.client.StackTraceRecorder;
import com.netflix.hollow.api.client.StaleHollowReferenceDetector;
import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.api.custom.HollowAPI;
import com.netflix.hollow.api.metrics.HollowConsumerMetrics;
import com.netflix.hollow.api.metrics.HollowMetricsCollector;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.read.filter.TypeFilter;
import com.netflix.hollow.core.util.HollowObjectHashCodeFinder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class HollowClientUpdater {
    private static final Logger LOG = Logger.getLogger(HollowClientUpdater.class.getName());
    private volatile HollowDataHolder hollowDataHolderVolatile;
    private final HollowUpdatePlanner planner;
    private final CompletableFuture<Long> initialLoad;
    private boolean forceDoubleSnapshot = false;
    private final FailedTransitionTracker failedTransitionTracker;
    private final StaleHollowReferenceDetector staleReferenceDetector;
    private final CopyOnWriteArrayList<HollowConsumer.RefreshListener> refreshListeners;
    private final HollowAPIFactory apiFactory;
    private final HollowObjectHashCodeFinder hashCodeFinder;
    private final MemoryMode memoryMode;
    private final HollowConsumer.ObjectLongevityConfig objectLongevityConfig;
    private final HollowConsumer.DoubleSnapshotConfig doubleSnapshotConfig;
    private final HollowConsumerMetrics metrics;
    private final HollowMetricsCollector<HollowConsumerMetrics> metricsCollector;
    private boolean skipTypeShardUpdateWithNoAdditions;
    private TypeFilter filter;

    public HollowClientUpdater(HollowConsumer.BlobRetriever transitionCreator, List<HollowConsumer.RefreshListener> refreshListeners, HollowAPIFactory apiFactory, HollowConsumer.DoubleSnapshotConfig doubleSnapshotConfig, HollowObjectHashCodeFinder hashCodeFinder, MemoryMode memoryMode, HollowConsumer.ObjectLongevityConfig objectLongevityConfig, HollowConsumer.ObjectLongevityDetector objectLongevityDetector, HollowConsumerMetrics metrics, HollowMetricsCollector<HollowConsumerMetrics> metricsCollector) {
        this.planner = new HollowUpdatePlanner(transitionCreator, doubleSnapshotConfig);
        this.failedTransitionTracker = new FailedTransitionTracker();
        this.staleReferenceDetector = new StaleHollowReferenceDetector(objectLongevityConfig, objectLongevityDetector);
        this.refreshListeners = new CopyOnWriteArrayList(refreshListeners.stream().distinct().toArray(HollowConsumer.RefreshListener[]::new));
        this.apiFactory = apiFactory;
        this.hashCodeFinder = hashCodeFinder;
        this.memoryMode = memoryMode;
        this.doubleSnapshotConfig = doubleSnapshotConfig;
        this.objectLongevityConfig = objectLongevityConfig;
        this.staleReferenceDetector.startMonitoring();
        this.metrics = metrics;
        this.metricsCollector = metricsCollector;
        this.initialLoad = new CompletableFuture();
    }

    public void setSkipShardUpdateWithNoAdditions(boolean skipTypeShardUpdateWithNoAdditions) {
        this.skipTypeShardUpdateWithNoAdditions = skipTypeShardUpdateWithNoAdditions;
        HollowDataHolder dataHolder = this.hollowDataHolderVolatile;
        if (dataHolder != null) {
            dataHolder.getStateEngine().setSkipTypeShardUpdateWithNoAdditions(skipTypeShardUpdateWithNoAdditions);
        }
    }

    public synchronized boolean updateTo(long requestedVersion) throws Throwable {
        if (requestedVersion == this.getCurrentVersionId()) {
            if (requestedVersion == Long.MIN_VALUE && this.hollowDataHolderVolatile == null) {
                LOG.warning("No versions to update to, initializing to empty state");
                this.hollowDataHolderVolatile = this.newHollowDataHolder();
                this.forceDoubleSnapshotNextUpdate();
            }
            return true;
        }
        HollowConsumer.RefreshListener[] localListeners = this.refreshListeners.toArray(new HollowConsumer.RefreshListener[0]);
        long beforeVersion = this.getCurrentVersionId();
        for (HollowConsumer.RefreshListener listener : localListeners) {
            listener.refreshStarted(beforeVersion, requestedVersion);
        }
        try {
            HollowUpdatePlan updatePlan = this.shouldCreateSnapshotPlan() ? this.planner.planInitializingUpdate(requestedVersion) : this.planner.planUpdate(this.hollowDataHolderVolatile.getCurrentVersion(), requestedVersion, this.doubleSnapshotConfig.allowDoubleSnapshot());
            for (HollowConsumer.RefreshListener listener : localListeners) {
                if (!(listener instanceof HollowConsumer.TransitionAwareRefreshListener)) continue;
                ((HollowConsumer.TransitionAwareRefreshListener)listener).transitionsPlanned(beforeVersion, requestedVersion, updatePlan.isSnapshotPlan(), updatePlan.getTransitionSequence());
            }
            if (updatePlan.destinationVersion() == Long.MIN_VALUE && requestedVersion != Long.MAX_VALUE) {
                String msg = String.format("Could not create an update plan for version %s, because that version or any qualifying previous versions could not be retrieved.", requestedVersion);
                if (beforeVersion != Long.MIN_VALUE) {
                    msg = msg + String.format(" Consumer will remain at current version %s until next update attempt.", beforeVersion);
                }
                throw new IllegalArgumentException(msg);
            }
            if (updatePlan.equals(HollowUpdatePlan.DO_NOTHING) && requestedVersion == Long.MAX_VALUE) {
                throw new IllegalArgumentException("Could not create an update plan, because no existing versions could be retrieved.");
            }
            if (updatePlan.destinationVersion(requestedVersion) == this.getCurrentVersionId()) {
                return true;
            }
            if (updatePlan.isSnapshotPlan()) {
                HollowDataHolder oldDh = this.hollowDataHolderVolatile;
                if (oldDh == null || this.doubleSnapshotConfig.allowDoubleSnapshot()) {
                    HollowDataHolder newDh = this.newHollowDataHolder();
                    try {
                        newDh.update(updatePlan, localListeners, () -> {
                            this.hollowDataHolderVolatile = newDh;
                        });
                    }
                    catch (Throwable t) {
                        this.hollowDataHolderVolatile = oldDh;
                        throw t;
                    }
                    this.forceDoubleSnapshot = false;
                }
            } else {
                this.hollowDataHolderVolatile.update(updatePlan, localListeners, () -> {});
            }
            for (HollowConsumer.RefreshListener refreshListener : localListeners) {
                refreshListener.refreshSuccessful(beforeVersion, this.getCurrentVersionId(), requestedVersion);
            }
            this.metrics.updateTypeStateMetrics(this.getStateEngine(), requestedVersion);
            if (this.metricsCollector != null) {
                this.metricsCollector.collect(this.metrics);
            }
            this.initialLoad.complete(this.getCurrentVersionId());
            return this.getCurrentVersionId() == requestedVersion;
        }
        catch (Throwable th) {
            this.forceDoubleSnapshotNextUpdate();
            this.metrics.updateRefreshFailed();
            if (this.metricsCollector != null) {
                this.metricsCollector.collect(this.metrics);
            }
            for (HollowConsumer.RefreshListener refreshListener : localListeners) {
                refreshListener.refreshFailed(beforeVersion, this.getCurrentVersionId(), requestedVersion, th);
            }
            throw th;
        }
    }

    public synchronized void addRefreshListener(HollowConsumer.RefreshListener refreshListener, HollowConsumer c) {
        if (refreshListener instanceof HollowConsumer.RefreshRegistrationListener) {
            if (!this.refreshListeners.contains(refreshListener)) {
                ((HollowConsumer.RefreshRegistrationListener)((Object)refreshListener)).onBeforeAddition(c);
            }
            this.refreshListeners.add(refreshListener);
        } else {
            this.refreshListeners.addIfAbsent(refreshListener);
        }
    }

    public synchronized void removeRefreshListener(HollowConsumer.RefreshListener refreshListener, HollowConsumer c) {
        if (this.refreshListeners.remove(refreshListener) && refreshListener instanceof HollowConsumer.RefreshRegistrationListener) {
            ((HollowConsumer.RefreshRegistrationListener)((Object)refreshListener)).onAfterRemoval(c);
        }
    }

    public long getCurrentVersionId() {
        HollowDataHolder hollowDataHolderLocal = this.hollowDataHolderVolatile;
        return hollowDataHolderLocal != null ? hollowDataHolderLocal.getCurrentVersion() : Long.MIN_VALUE;
    }

    public void forceDoubleSnapshotNextUpdate() {
        this.forceDoubleSnapshot = true;
    }

    boolean shouldCreateSnapshotPlan() {
        return this.getCurrentVersionId() == Long.MIN_VALUE || this.forceDoubleSnapshot && this.doubleSnapshotConfig.allowDoubleSnapshot();
    }

    private HollowDataHolder newHollowDataHolder() {
        return new HollowDataHolder(this.newStateEngine(), this.apiFactory, this.memoryMode, this.doubleSnapshotConfig, this.failedTransitionTracker, this.staleReferenceDetector, this.objectLongevityConfig).setFilter(this.filter).setSkipTypeShardUpdateWithNoAdditions(this.skipTypeShardUpdateWithNoAdditions);
    }

    private HollowReadStateEngine newStateEngine() {
        HollowDataHolder hollowDataHolderLocal = this.hollowDataHolderVolatile;
        if (hollowDataHolderLocal != null) {
            ArraySegmentRecycler existingRecycler = hollowDataHolderLocal.getStateEngine().getMemoryRecycler();
            return new HollowReadStateEngine(this.hashCodeFinder, true, existingRecycler);
        }
        return new HollowReadStateEngine(this.hashCodeFinder);
    }

    public StackTraceRecorder getStaleReferenceUsageStackTraceRecorder() {
        return this.staleReferenceDetector.getStaleReferenceStackTraceRecorder();
    }

    public HollowReadStateEngine getStateEngine() {
        HollowDataHolder hollowDataHolderLocal = this.hollowDataHolderVolatile;
        return hollowDataHolderLocal == null ? null : hollowDataHolderLocal.getStateEngine();
    }

    public HollowAPI getAPI() {
        HollowDataHolder hollowDataHolderLocal = this.hollowDataHolderVolatile;
        return hollowDataHolderLocal == null ? null : hollowDataHolderLocal.getAPI();
    }

    public void setFilter(HollowFilterConfig filter) {
        this.filter = filter;
    }

    public void setFilter(TypeFilter filter) {
        this.filter = filter;
    }

    public int getNumFailedSnapshotTransitions() {
        return this.failedTransitionTracker.getNumFailedSnapshotTransitions();
    }

    public int getNumFailedDeltaTransitions() {
        return this.failedTransitionTracker.getNumFailedDeltaTransitions();
    }

    public void clearFailedTransitions() {
        this.failedTransitionTracker.clear();
    }

    public CompletableFuture<Long> getInitialLoad() {
        return this.initialLoad;
    }
}

