/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.client;

import com.netflix.hollow.api.custom.HollowAPI;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public interface HollowAPIFactory {
    public static final HollowAPIFactory DEFAULT_FACTORY = new HollowAPIFactory(){

        @Override
        public HollowAPI createAPI(HollowDataAccess dataAccess) {
            return new HollowAPI(dataAccess);
        }

        @Override
        public HollowAPI createAPI(HollowDataAccess dataAccess, HollowAPI previousCycleAPI) {
            return this.createAPI(dataAccess);
        }
    };

    public HollowAPI createAPI(HollowDataAccess var1);

    public HollowAPI createAPI(HollowDataAccess var1, HollowAPI var2);

    public static class ForGeneratedAPI<T extends HollowAPI>
    implements HollowAPIFactory {
        private final Class<T> generatedAPIClass;
        private final Set<String> cachedTypes;

        public ForGeneratedAPI(Class<T> generatedAPIClass) {
            this(generatedAPIClass, new String[0]);
        }

        public ForGeneratedAPI(Class<T> generatedAPIClass, String ... cachedTypes) {
            this.generatedAPIClass = generatedAPIClass;
            this.cachedTypes = new HashSet<String>(Arrays.asList(cachedTypes));
        }

        public T createAPI(HollowDataAccess dataAccess) {
            try {
                Constructor<T> constructor = this.generatedAPIClass.getConstructor(HollowDataAccess.class, Set.class);
                return (T)((HollowAPI)constructor.newInstance(dataAccess, this.cachedTypes));
            }
            catch (Exception e) {
                try {
                    Constructor<T> constructor = this.generatedAPIClass.getConstructor(HollowDataAccess.class);
                    return (T)((HollowAPI)constructor.newInstance(dataAccess));
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        }

        public T createAPI(HollowDataAccess dataAccess, HollowAPI previousCycleAPI) {
            try {
                Constructor<T> constructor = this.generatedAPIClass.getConstructor(HollowDataAccess.class, Set.class, Map.class, this.generatedAPIClass);
                return (T)((HollowAPI)constructor.newInstance(dataAccess, this.cachedTypes, Collections.emptyMap(), previousCycleAPI));
            }
            catch (Exception e) {
                try {
                    Constructor<T> constructor = this.generatedAPIClass.getConstructor(HollowDataAccess.class);
                    return (T)((HollowAPI)constructor.newInstance(dataAccess));
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
    }
}

