/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.client;

import com.netflix.hollow.api.client.HollowUpdatePlan;
import com.netflix.hollow.api.consumer.HollowConsumer;
import java.util.HashSet;

public class FailedTransitionTracker {
    private final HashSet<Long> failedSnapshotTransitions = new HashSet();
    private final HashSet<DeltaTransition> failedDeltaTransitions = new HashSet();

    public void markAllTransitionsAsFailed(HollowUpdatePlan plan) {
        for (HollowConsumer.Blob transition : plan) {
            this.markFailedTransition(transition);
        }
    }

    public void markFailedTransition(HollowConsumer.Blob transition) {
        if (transition.isSnapshot()) {
            this.failedSnapshotTransitions.add(transition.getToVersion());
        } else {
            this.failedDeltaTransitions.add(this.delta(transition));
        }
    }

    public boolean anyTransitionWasFailed(HollowUpdatePlan plan) {
        for (HollowConsumer.Blob transition : plan) {
            if (!this.transitionWasFailed(transition)) continue;
            return true;
        }
        return false;
    }

    public int getNumFailedSnapshotTransitions() {
        return this.failedSnapshotTransitions.size();
    }

    public int getNumFailedDeltaTransitions() {
        return this.failedDeltaTransitions.size();
    }

    public void clear() {
        this.failedSnapshotTransitions.clear();
        this.failedDeltaTransitions.clear();
    }

    private boolean transitionWasFailed(HollowConsumer.Blob transition) {
        if (transition.isSnapshot()) {
            return this.failedSnapshotTransitions.contains(transition.getToVersion());
        }
        return this.failedDeltaTransitions.contains(this.delta(transition));
    }

    private DeltaTransition delta(HollowConsumer.Blob transition) {
        return new DeltaTransition(transition.getFromVersion(), transition.getToVersion());
    }

    private class DeltaTransition {
        private final long fromState;
        private final long toState;

        DeltaTransition(long fromState, long toState) {
            this.fromState = fromState;
            this.toState = toState;
        }

        public int hashCode() {
            return (int)this.fromState ^ (int)(this.fromState >> 32) ^ (int)this.toState ^ (int)(this.toState >> 32);
        }

        public boolean equals(Object obj) {
            if (obj instanceof DeltaTransition) {
                DeltaTransition other = (DeltaTransition)obj;
                return other.fromState == this.fromState && other.toState == this.toState;
            }
            return false;
        }
    }
}

