/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.roster;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.server.PolicyViolationException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.roster.Roster;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;

public class RosterFlat
extends RosterAbstract {
    private static final Logger log = Logger.getLogger(RosterFlat.class.getName());
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public RosterFlat() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static boolean addBuddy(RosterElement relem, Map<BareJID, RosterElement> roster) {
        if (roster.size() < maxRosterSize) {
            roster.put(relem.getJid().getBareJID(), relem);
            return true;
        }
        return false;
    }

    public RosterElement addTempBuddy(JID buddy, XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElementInstance(buddy.copyWithoutResource(), null, null, session);
        relem.setPersistent(false);
        relem.setSubscription(null);
        RosterFlat.addBuddy(relem, this.getUserRoster(session));
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Added temporary buddy to roster: {0}, name: {1}, item: {2}", new Object[]{relem.getJid(), relem.getName(), relem.getRosterItem(), relem.toString()});
        }
        return relem;
    }

    public static boolean parseRosterUtil(String roster_str, Map<BareJID, RosterElement> roster, XMPPResourceConnection session) {
        boolean result = false;
        DomBuilderHandler domHandler = new DomBuilderHandler();
        parser.parse(domHandler, roster_str.toCharArray(), 0, roster_str.length());
        Queue<Element> elems = domHandler.getParsedElements();
        if (elems != null && elems.size() > 0) {
            for (Element elem : elems) {
                try {
                    RosterElement relem = new RosterElement(elem, session);
                    result |= relem.isModified();
                    if (RosterFlat.addBuddy(relem, roster)) continue;
                    break;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Can't load roster element: {0}", elem);
                }
            }
        }
        return result;
    }

    @Override
    public void addBuddy(XMPPResourceConnection session, JID buddy, String name, String[] groups, String otherData) throws NotAuthorizedException, TigaseDBException, PolicyViolationException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            Map<BareJID, RosterElement> roster = this.getUserRoster(session);
            relem = this.getRosterElementInstance(buddy, name, groups, session);
            if (emptyNameAllowed && (name == null || name.isEmpty())) {
                relem.setName(null);
            } else if (name == null || name.isEmpty()) {
                String n = buddy.getLocalpart();
                if (n == null || n.trim().isEmpty()) {
                    n = buddy.getBareJID().toString();
                }
                relem.setName(n);
            } else {
                relem.setName(name);
            }
            relem.setOtherData(otherData);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "1. Added buddy to roster: {0}, name: {1}, item: {2}", new Object[]{relem.getJid(), relem.getName(), relem.getRosterItem()});
            }
            if (!RosterFlat.addBuddy(relem, roster)) {
                throw new PolicyViolationException("Too many elements in the user roster. Limit: " + maxRosterSize);
            }
            this.saveUserRoster(session);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "2. Added buddy to roster: {0}, name: {1}, item: {2}", new Object[]{relem.getJid(), relem.getName(), relem.getRosterItem()});
            }
        } else {
            if (emptyNameAllowed && (name == null || name.isEmpty())) {
                relem.setName(null);
            } else if (name == null || name.isEmpty()) {
                String n = buddy.getLocalpart();
                if (n == null || n.trim().isEmpty()) {
                    n = buddy.getBareJID().toString();
                }
                relem.setName(n);
            } else {
                relem.setName(name);
            }
            relem.setGroups(groups);
            relem.setPersistent(true);
            this.saveUserRoster(session);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Updated buddy in roster: {0}", buddy);
            }
        }
    }

    @Override
    public boolean addBuddyGroup(XMPPResourceConnection session, JID buddy, String[] groups) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem != null) {
            relem.addGroups(groups);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsBuddy(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        return relem != null && relem.isPersistent();
    }

    @Override
    public JID[] getBuddies(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Map<BareJID, RosterElement> roster = this.getUserRoster(session);
        if (roster.size() == 0) {
            return null;
        }
        JID[] result = new JID[roster.size()];
        int idx = 0;
        for (RosterElement rosterElement : roster.values()) {
            result[idx++] = rosterElement.getJid();
        }
        Arrays.sort(result, new RosterElemComparator(roster));
        return result;
    }

    @Override
    public String[] getBuddyGroups(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            return null;
        }
        return relem.getGroups();
    }

    public Element getBuddyItem(RosterElement relem) {
        return relem.getRosterItem();
    }

    @Override
    public Element getBuddyItem(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            return null;
        }
        return this.getBuddyItem(relem);
    }

    @Override
    public String getBuddyName(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            return null;
        }
        return relem.getName();
    }

    @Override
    public RosterAbstract.SubscriptionType getBuddySubscription(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null || !relem.isPersistent()) {
            return null;
        }
        return relem.getSubscription();
    }

    public RosterElement getRosterElementInstance(JID buddy, String name, String[] groups, XMPPResourceConnection session) {
        return new RosterElement(buddy.copyWithoutResource(), name, groups, session);
    }

    @Override
    public List<Element> getRosterItems(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        LinkedList<Element> items = new LinkedList<Element>();
        Map<BareJID, RosterElement> roster = this.getUserRoster(session);
        for (RosterElement relem : roster.values()) {
            if (!relem.isPersistent() || RosterAbstract.SubscriptionType.none_pending_in.equals((Object)relem.getSubscription())) continue;
            items.add(this.getBuddyItem(relem));
        }
        return items;
    }

    @Override
    public boolean isRosterLoaded(XMPPResourceConnection session) {
        return session.getCommonSessionData("roster") != null;
    }

    @Override
    public boolean isOnline(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        return relem != null && relem.isOnline();
    }

    public boolean parseRoster(String roster_str, Map<BareJID, RosterElement> roster, XMPPResourceConnection session) {
        return RosterFlat.parseRosterUtil(roster_str, roster, session);
    }

    @Override
    public boolean presenceSent(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        return relem != null && relem.isPresence_sent();
    }

    @Override
    public boolean removeBuddy(XMPPResourceConnection session, JID jid) throws NotAuthorizedException, TigaseDBException {
        Map<BareJID, RosterElement> roster = this.getUserRoster(session);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Removing roster buddy: {0}, before removal: {1}", new Object[]{jid, roster});
        }
        roster.remove(jid.getBareJID());
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Removing roster buddy: {0}, after removal: {1}", new Object[]{jid, roster});
        }
        this.saveUserRoster(session);
        return true;
    }

    @Override
    public void setBuddyName(XMPPResourceConnection session, JID buddy, String name) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Setting name: ''{0}'' for buddy: {1}", new Object[]{name, buddy});
            }
            if (emptyNameAllowed && (name == null || name.isEmpty())) {
                relem.setName(null);
            } else if (name == null || name.isEmpty()) {
                String n = buddy.getLocalpart();
                if (n == null || n.trim().isEmpty()) {
                    n = buddy.getBareJID().toString();
                }
                relem.setName(n);
            } else {
                relem.setName(name);
            }
            this.saveUserRoster(session);
        } else {
            log.log(Level.WARNING, "Setting buddy name for non-existen contact: {0}", buddy);
        }
    }

    @Override
    public void setBuddySubscription(XMPPResourceConnection session, RosterAbstract.SubscriptionType subscription, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem != null) {
            relem.setSubscription(subscription);
            this.saveUserRoster(session);
        } else {
            log.log(Level.WARNING, "Missing roster contact for subscription set: {0}", buddy);
        }
    }

    @Override
    public void setOnline(XMPPResourceConnection session, JID buddy, boolean online) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            relem = this.addTempBuddy(buddy, session);
        }
        relem.setOnline(buddy.getResource(), online);
    }

    @Override
    public void setPresenceSent(XMPPResourceConnection session, JID buddy, boolean sent) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            relem = this.addTempBuddy(buddy, session);
        }
        relem.setPresence_sent(sent);
    }

    @Override
    public RosterElement getRosterElement(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        Map<BareJID, RosterElement> roster = this.getUserRoster(session);
        return roster.get(buddy.getBareJID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<BareJID, RosterElement> getUserRoster(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Map<BareJID, RosterElement> roster = null;
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            roster = (Map<BareJID, RosterElement>)session.getCommonSessionData("roster");
            if (roster == null) {
                roster = this.loadUserRoster(session);
            }
        }
        return roster;
    }

    protected void saveUserRoster(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Map<BareJID, RosterElement> roster = this.getUserRoster(session);
        StringBuilder sb = new StringBuilder(5000);
        for (RosterElement relem : roster.values()) {
            if (!relem.isPersistent()) continue;
            sb.append(relem.getRosterElement().toString());
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0} | Saving user roster: {1}", new String[]{session.getBareJID().toString(), sb.toString()});
        }
        session.setData(null, "roster", sb.toString());
    }

    private Map<BareJID, RosterElement> loadUserRoster(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        ConcurrentHashMap<BareJID, RosterElement> roster = new ConcurrentHashMap<BareJID, RosterElement>(100, 0.25f, 1);
        session.putCommonSessionData("roster", roster);
        String roster_str = session.getData(null, "roster", null);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Loaded user {1} roster: {0}", new Object[]{roster_str, session.getjid()});
        }
        if (roster_str != null && !roster_str.isEmpty()) {
            this.updateRosterHash(roster_str, session);
            boolean modified = this.parseRoster(roster_str, roster, session);
            if (modified) {
                this.saveUserRoster(session);
            }
        } else {
            Roster oldRoster = new Roster();
            JID[] buddies = oldRoster.getBuddies(session);
            if (buddies != null && buddies.length > 0) {
                for (JID buddy : buddies) {
                    String name = oldRoster.getBuddyName(session, buddy);
                    RosterAbstract.SubscriptionType subscr = oldRoster.getBuddySubscription(session, buddy);
                    String[] groups = oldRoster.getBuddyGroups(session, buddy);
                    RosterElement relem = this.getRosterElementInstance(buddy, name, groups, session);
                    relem.setSubscription(subscr);
                    if (!RosterFlat.addBuddy(relem, roster)) break;
                }
                this.saveUserRoster(session);
            }
        }
        return roster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getCustomChild(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement rel = this.getRosterElement(session, buddy);
        if (rel != null && rel.getLastSeen() > 1000L) {
            String stamp;
            SimpleDateFormat simpleDateFormat = this.formatter;
            synchronized (simpleDateFormat) {
                stamp = this.formatter.format(new Date(rel.getLastSeen()));
            }
            return new Element("delay", new String[]{"stamp", "xmlns"}, new String[]{stamp, "urn:xmpp:delay"});
        }
        return null;
    }

    @Override
    public void logout(XMPPResourceConnection session) {
        try {
            if (session.isAuthorized() && this.isModified(session)) {
                this.saveUserRoster(session);
            }
        }
        catch (NotAuthorizedException ex) {
            ex.printStackTrace();
        }
        catch (TigaseDBException ex) {
            ex.printStackTrace();
        }
    }

    public boolean isModified(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Map<BareJID, RosterElement> roster = this.getUserRoster(session);
        boolean result = false;
        if (roster != null) {
            for (RosterElement rel : roster.values()) {
                result |= rel.isModified();
            }
        }
        return result;
    }

    private class RosterElemComparator
    implements Comparator<JID> {
        private Map<BareJID, RosterElement> roster = null;

        private RosterElemComparator(Map<BareJID, RosterElement> roster) {
            this.roster = roster;
        }

        @Override
        public int compare(JID arg0, JID arg1) {
            double w0 = this.roster.get(arg0.getBareJID()).getWeight();
            double w1 = this.roster.get(arg1.getBareJID()).getWeight();
            return Double.compare(w0, w1);
        }
    }
}

