/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class StartZLib
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final String[][] ELEMENTS = new String[][]{{"compress"}, {"compressed"}, {"failure"}};
    private static final String ID = "zlib";
    private static Logger log = Logger.getLogger(StartZLib.class.getName());
    private static final String XMLNS = "http://jabber.org/protocol/compress";
    private static final String[] XMLNSS = new String[]{"http://jabber.org/protocol/compress", "http://jabber.org/protocol/compress", "http://jabber.org/protocol/compress"};
    private static final Element[] FEATURES = new Element[]{new Element("compression", new Element[]{new Element("method", "zlib")}, new String[]{"xmlns"}, new String[]{"http://jabber.org/features/compress"})};
    private Element compressed = new Element("compressed", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/compress"});
    private Element failure = new Element("failure", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/compress"});

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        if (packet.isElement("compress", XMLNS)) {
            if (session.getSessionData(ID) != null) {
                log.log(Level.WARNING, "Multiple ZLib requests, possible DOS attack, closing connection: {0}", packet);
                results.offer(packet.swapFromTo(this.failure, null, null));
                results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
                return;
            }
            session.putSessionData(ID, "true");
            Packet result = Command.STARTZLIB.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId(), Command.DataType.submit);
            Command.setData(result, this.compressed);
            results.offer(result);
        } else {
            log.log(Level.WARNING, "Unknown ZLIB element: {0}", packet);
            results.offer(packet.swapFromTo(this.failure, null, null));
            results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
        }
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session != null && session.getSessionData(ID) == null) {
            return FEATURES;
        }
        return null;
    }
}

