/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.form.Field;
import tigase.form.Form;
import tigase.form.FormSignatureVerifier;
import tigase.form.FormSignerException;
import tigase.form.SignatureCalculator;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.stats.StatisticsList;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLUtils;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class JabberIqRegister
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final int REMOTE_ADDRESS_IDX = 2;
    private static final String[][] ELEMENTS = new String[][]{Iq.IQ_QUERY_PATH};
    public static final String ID = "jabber:iq:register";
    public static final String REGISTRATION_BLACKLIST_PROP_KEY = "registration-blacklist";
    public static final String REGISTRATION_WHITELIST_PROP_KEY = "registration-whitelist";
    public static final String WHITELIST_REGISTRATION_ONLY_PROP_KEY = "whitelist-registration-only";
    private List<CIDRAddress> registrationWhitelist = new LinkedList<CIDRAddress>();
    private List<CIDRAddress> registrationBlacklist = new LinkedList<CIDRAddress>();
    private boolean whitelistRegistrationOnly = false;
    public static final String OAUTH_CONSUMERKEY_PROP_KEY = "oauth-consumer-key";
    public static final String OAUTH_CONSUMERSECRET_PROP_KEY = "oauth-consumer-secret";
    public static final String SIGNED_FORM_REQUIRED_PROP_KEY = "signed-form-required";
    private String oauthConsumerKey;
    private String oauthConsumerSecret;
    private boolean signedFormRequired = false;
    private static Logger log = Logger.getLogger(JabberIqRegister.class.getName());
    private static final String[] XMLNSS = new String[]{"jabber:iq:register"};
    private static final String[] IQ_QUERY_USERNAME_PATH = new String[]{"iq", "query", "username"};
    private static final String[] IQ_QUERY_REMOVE_PATH = new String[]{"iq", "query", "remove"};
    private static final String[] IQ_QUERY_PASSWORD_PATH = new String[]{"iq", "query", "password"};
    private static final String[] IQ_QUERY_EMAIL_PATH = new String[]{"iq", "query", "email"};
    private static final Element[] FEATURES = new Element[]{new Element("register", new String[]{"xmlns"}, new String[]{"http://jabber.org/features/iq-register"})};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:register"})};
    private long statsRegisteredUsers;
    private long statsInvalidRegistrations;

    public void setOAuthCredentials(String oauthConsumerKey, String oauthConsumerSecret) {
        this.oauthConsumerKey = oauthConsumerKey;
        this.oauthConsumerSecret = oauthConsumerSecret;
    }

    public void setSignedFormRequired(boolean required) {
        this.signedFormRequired = required;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing packet: " + packet.toString());
        }
        if (session == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Session is null, ignoring");
            }
            return;
        }
        BareJID id = session.getDomainAsJID().getBareJID();
        if (packet.getStanzaTo() != null) {
            id = packet.getStanzaTo().getBareJID();
        }
        try {
            if (packet.getPacketFrom() != null && packet.getPacketFrom().equals(session.getConnectionId()) && (!session.isAuthorized() || session.isUserId(id) || session.isLocalDomain(id.toString(), false))) {
                boolean remove;
                Element request = packet.getElement();
                boolean bl = remove = request.findChildStaticStr(IQ_QUERY_REMOVE_PATH) != null;
                if (!session.isAuthorized() || remove) {
                    if (!this.isRegistrationAllowedForConnection(packet.getFrom())) {
                        results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "Registration is not allowed for this connection.", true));
                        ++this.statsInvalidRegistrations;
                        return;
                    }
                    if (!session.getDomain().isRegisterEnabled()) {
                        results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "Registration is not allowed for this domain.", true));
                        ++this.statsInvalidRegistrations;
                        return;
                    }
                }
                Authorization result = Authorization.NOT_AUTHORIZED;
                StanzaType type = packet.getType();
                switch (type) {
                    case set: {
                        String email;
                        String password;
                        String user_name;
                        Element elem = request.findChildStaticStr(IQ_QUERY_REMOVE_PATH);
                        if (elem != null) {
                            elem = request.findChildStaticStr(Iq.IQ_QUERY_PATH);
                            if (elem.getChildren().size() > 1) {
                                result = Authorization.BAD_REQUEST;
                                break;
                            }
                            try {
                                result = session.unregister(packet.getStanzaFrom().toString());
                                Packet ok_result = packet.okResult((String)null, 0);
                                ok_result.setPriority(Priority.SYSTEM);
                                results.offer(ok_result);
                                Packet close_cmd = Command.CLOSE.getPacket(session.getSMComponentId(), session.getConnectionId(), StanzaType.set, session.nextStanzaId());
                                close_cmd.setPacketTo(session.getConnectionId());
                                close_cmd.setPriority(Priority.LOWEST);
                                results.offer(close_cmd);
                            }
                            catch (NotAuthorizedException e) {
                                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
                            }
                            break;
                        }
                        if (this.signedFormRequired) {
                            Element formEl;
                            String expectedToken = UUID.nameUUIDFromBytes((session.getConnectionId() + "|" + session.getSessionId()).getBytes()).toString();
                            FormSignatureVerifier verifier = new FormSignatureVerifier(this.oauthConsumerKey, this.oauthConsumerSecret);
                            Element queryEl = request.getChild("query", ID);
                            Element element = formEl = queryEl == null ? null : queryEl.getChild("x", "jabber:x:data");
                            if (formEl == null) {
                                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Use Signed Registration Form", true));
                                ++this.statsInvalidRegistrations;
                                return;
                            }
                            Form form = new Form(formEl);
                            if (!expectedToken.equals(form.getAsString("oauth_token"))) {
                                log.finest("Received oauth_token is different that sent one.");
                                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Unknown oauth_token", true));
                                ++this.statsInvalidRegistrations;
                                return;
                            }
                            if (!this.oauthConsumerKey.equals(form.getAsString("oauth_consumer_key"))) {
                                log.finest("Unknown oauth_consumer_key");
                                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Unknown oauth_consumer_key", true));
                                ++this.statsInvalidRegistrations;
                                return;
                            }
                            try {
                                long timestamp = verifier.verify(packet.getStanzaTo(), form);
                                user_name = form.getAsString("username");
                                password = form.getAsString("password");
                                email = form.getAsString("email");
                            }
                            catch (FormSignerException e) {
                                log.fine("Form Signature Validation Problem: " + e.getMessage());
                                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Invalid form signature", true));
                                ++this.statsInvalidRegistrations;
                                return;
                            }
                        } else {
                            user_name = request.getChildCDataStaticStr(IQ_QUERY_USERNAME_PATH);
                            password = request.getChildCDataStaticStr(IQ_QUERY_PASSWORD_PATH);
                            email = request.getChildCDataStaticStr(IQ_QUERY_EMAIL_PATH);
                        }
                        String pass_enc = null;
                        if (null != password) {
                            pass_enc = XMLUtils.unescape(password);
                        }
                        LinkedHashMap<String, String> reg_params = null;
                        if (email != null && !email.trim().isEmpty()) {
                            reg_params = new LinkedHashMap<String, String>();
                            reg_params.put("email", email);
                        }
                        if ((result = session.register(user_name, pass_enc, reg_params)) == Authorization.AUTHORIZED) {
                            results.offer(result.getResponseMessage(packet, null, false));
                            break;
                        }
                        ++this.statsInvalidRegistrations;
                        results.offer(result.getResponseMessage(packet, "Unsuccessful registration attempt", true));
                        break;
                    }
                    case get: {
                        if (this.signedFormRequired) {
                            results.offer(packet.okResult(this.prepareRegistrationForm(session), 0));
                            break;
                        }
                        results.offer(packet.okResult("<instructions>Choose a user name and password for use with this service.Please provide also your e-mail address.</instructions><username/><password/><email/>", 1));
                        break;
                    }
                    case result: {
                        Packet pack_res = packet.copyElementOnly();
                        pack_res.setPacketTo(session.getConnectionId());
                        results.offer(pack_res);
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Message type is incorrect", true));
                    }
                }
            } else if (session.isUserId(id)) {
                Packet pack_res = packet.copyElementOnly();
                pack_res.setPacketTo(session.getConnectionId());
                results.offer(pack_res);
            } else {
                results.offer(packet.copyElementOnly());
            }
        }
        catch (TigaseStringprepException ex) {
            results.offer(Authorization.JID_MALFORMED.getResponseMessage(packet, "Incorrect user name, stringprep processing failed.", true));
        }
        catch (NotAuthorizedException e) {
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized to change registration settings.\n" + e.getMessage(), true));
        }
        catch (TigaseDBException e) {
            log.warning("Database problem: " + e);
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database access problem, please contact administrator.", true));
        }
    }

    private Element prepareRegistrationForm(XMPPResourceConnection session) throws NoConnectionIdException {
        Element query = new Element("query", new String[]{"xmlns"}, XMLNSS);
        query.addChild(new Element("instructions", "Use the enclosed form to register."));
        Form form = new Form("urn:xmpp:xdata:signature:oauth1", "Contest Registration", "Please provide the following information to sign up for our special contests!");
        form.addField(Field.fieldTextSingle("username", "", "Username"));
        form.addField(Field.fieldTextPrivate("password", "", "Password"));
        form.addField(Field.fieldTextSingle("email", "", "Email"));
        SignatureCalculator sc = new SignatureCalculator(this.oauthConsumerKey, this.oauthConsumerSecret);
        sc.setOauthToken(UUID.nameUUIDFromBytes((session.getConnectionId() + "|" + session.getSessionId()).getBytes()).toString());
        sc.addEmptyFields(form);
        query.addChild(form.getElement());
        return query;
    }

    protected boolean isRegistrationAllowedForConnection(JID from) {
        String remoteAdress = JabberIqRegister.parseRemoteAddressFromJid(from);
        if (this.whitelistRegistrationOnly) {
            return JabberIqRegister.contains(this.registrationWhitelist, remoteAdress);
        }
        return !JabberIqRegister.contains(this.registrationBlacklist, remoteAdress);
    }

    private static String parseRemoteAddressFromJid(JID from) {
        try {
            String connectionId = from.getResource();
            return connectionId.split("_")[2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getComponentInfo().getName(), "Registered users", this.statsRegisteredUsers, Level.INFO);
        list.add(this.getComponentInfo().getName(), "Invalid registrations", this.statsInvalidRegistrations, Level.INFO);
    }

    @Override
    public void init(Map<String, Object> settings) throws TigaseDBException {
        String registrationBlacklistStr;
        String registrationWhitelistStr;
        this.oauthConsumerKey = (String)settings.get(OAUTH_CONSUMERKEY_PROP_KEY);
        this.oauthConsumerSecret = (String)settings.get(OAUTH_CONSUMERSECRET_PROP_KEY);
        Object verifyFormSignatureObj = settings.get(SIGNED_FORM_REQUIRED_PROP_KEY);
        if (verifyFormSignatureObj != null && verifyFormSignatureObj instanceof Boolean) {
            this.signedFormRequired = (Boolean)verifyFormSignatureObj;
        } else if (verifyFormSignatureObj != null) {
            this.signedFormRequired = Boolean.parseBoolean(verifyFormSignatureObj.toString());
        }
        String whitelistRegistrationOnlyStr = (String)settings.get(WHITELIST_REGISTRATION_ONLY_PROP_KEY);
        if (whitelistRegistrationOnlyStr != null) {
            this.whitelistRegistrationOnly = Boolean.parseBoolean(whitelistRegistrationOnlyStr);
        }
        if ((registrationWhitelistStr = (String)settings.get(REGISTRATION_WHITELIST_PROP_KEY)) != null) {
            this.registrationWhitelist = JabberIqRegister.parseList(registrationWhitelistStr);
        }
        if ((registrationBlacklistStr = (String)settings.get(REGISTRATION_BLACKLIST_PROP_KEY)) != null) {
            this.registrationBlacklist = JabberIqRegister.parseList(registrationBlacklistStr);
        }
    }

    private static boolean contains(List<CIDRAddress> addresses, String address) {
        if (address == null) {
            return false;
        }
        for (CIDRAddress cidrAddress : addresses) {
            if (!cidrAddress.inRange(address)) continue;
            return true;
        }
        return false;
    }

    private static List<CIDRAddress> parseList(String listStr) {
        String[] splitArray = listStr.split(",");
        LinkedList<CIDRAddress> splitList = new LinkedList<CIDRAddress>();
        for (String listEl : splitArray) {
            splitList.add(CIDRAddress.parse(listEl.trim()));
        }
        return splitList;
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        if (log.isLoggable(Level.FINEST) && session != null) {
            log.finest("VHostItem: " + session.getDomain());
        }
        if (session != null && session.getDomain().isRegisterEnabled()) {
            return DISCO_FEATURES;
        }
        return null;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (log.isLoggable(Level.FINEST) && session != null) {
            log.finest("VHostItem: " + session.getDomain());
        }
        if (session != null && session.getDomain().isRegisterEnabled()) {
            return FEATURES;
        }
        return null;
    }

    public boolean isSignedFormRequired() {
        return this.signedFormRequired;
    }

    private static class CIDRAddress {
        static final int NBITS = 32;
        static final String IP_ADDRESS_MASK = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
        static final String CIDR_ADDRESS_MASK = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})";
        static final Pattern IP_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
        static final Pattern CIDR_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})");
        final int high;
        final int low;

        private CIDRAddress(int high, int low) {
            this.high = high;
            this.low = low;
        }

        boolean inRange(String address) {
            int diff = CIDRAddress.toInteger(address) - this.low;
            return diff >= 0 && diff <= this.high - this.low;
        }

        static int toInteger(String address) {
            Matcher matcher = IP_PATTERN.matcher(address);
            matcher.matches();
            return CIDRAddress.matchAddress(matcher);
        }

        static int matchAddress(Matcher matcher) {
            int addr = 0;
            for (int i = 1; i <= 4; ++i) {
                int n = Integer.parseInt(matcher.group(i));
                addr |= (n & 0xFF) << 8 * (4 - i);
            }
            return addr;
        }

        static CIDRAddress parse(String mask) {
            if (!mask.contains("/")) {
                mask = mask + "/" + 32;
            }
            Matcher matcher = CIDR_PATTERN.matcher(mask);
            matcher.matches();
            int address = CIDRAddress.matchAddress(matcher);
            int cidrPart = Integer.parseInt(matcher.group(5));
            int netmask = 0;
            int broadcast = 0;
            int network = 0;
            for (int j = 0; j < cidrPart; ++j) {
                netmask |= 1 << 31 - j;
            }
            network = address & netmask;
            broadcast = network | ~netmask;
            return new CIDRAddress(broadcast, network);
        }
    }
}

