/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.MobileV2;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.impl.annotation.StreamFeature;
import tigase.xmpp.impl.annotation.StreamFeatures;

@Id(value="urn:xmpp:csi:0")
@Handles(value={@Handle(path={"active"}, xmlns="urn:xmpp:csi:0"), @Handle(path={"inactive"}, xmlns="urn:xmpp:csi:0")})
@StreamFeatures(value={@StreamFeature(elem="csi", xmlns="urn:xmpp:csi:0")})
public class ClientStateIndication
extends AnnotatedXMPPProcessor
implements XMPPProcessorIfc,
XMPPPacketFilterIfc {
    private static final Logger log = Logger.getLogger(ClientStateIndication.class.getCanonicalName());
    protected static final String XMLNS = "urn:xmpp:csi:0";
    protected static final String ID = "urn:xmpp:csi:0";
    protected static final String ACTIVE_NAME = "active";
    protected static final String INACTIVE_NAME = "inactive";
    private Logic logic = new MobileV2();

    @Override
    public void init(Map<String, Object> settings) throws TigaseDBException {
        super.init(settings);
        if (settings.containsKey("logic")) {
            String cls = (String)settings.get("logic");
            try {
                this.logic = (Logic)ModulesManagerImpl.getInstance().forName(cls).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                log.log(Level.SEVERE, "Could not create instance of class", ex);
            }
        }
        this.logic.init(settings);
    }

    @Override
    public void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        this.logic.filter(packet, session, repo, results);
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        if (!session.isAuthorized()) {
            try {
                results.offer(session.getAuthState().getResponseMessage(packet, "Session is not yet authorized.", false));
            }
            catch (PacketErrorTypeException ex) {
                log.log(Level.FINEST, "ignoring packet from not authorized session which is already of type error");
            }
            return;
        }
        switch (packet.getElemName()) {
            case "active": {
                this.logic.deactivate(session, results);
                break;
            }
            case "inactive": {
                this.logic.activate(session, results);
                break;
            }
            default: {
                results.offer(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, null, true));
            }
        }
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session == null || !session.isAuthorized()) {
            return null;
        }
        return super.supStreamFeatures(session);
    }

    public static interface Logic
    extends XMPPPacketFilterIfc {
        public void activate(XMPPResourceConnection var1, Queue<Packet> var2);

        public void deactivate(XMPPResourceConnection var1, Queue<Packet> var2);
    }
}

