/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.Message;

public class C2SDeliveryErrorProcessor {
    private static final Logger log = Logger.getLogger(C2SDeliveryErrorProcessor.class.getCanonicalName());
    public static final String ELEM_NAME = "delivery-error";
    public static final String XMLNS = "http://tigase.org/delivery-error";
    private static final String[] DELAY_PATH = new String[]{"message", "delay"};

    public static void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, JID toIgnore) {
        for (Packet p : results) {
            Element elem;
            Element error;
            if (p.getElemName() != "message" || (error = (elem = p.getElement()).getChildStaticStr(ELEM_NAME)) == null || error.getXMLNS() != XMLNS || toIgnore != null && toIgnore.equals(packet.getPacketTo())) continue;
            elem.removeChild(error);
        }
    }

    public static void filterErrorElement(Element messageElem) {
        Element error = messageElem.getChildStaticStr(ELEM_NAME);
        if (error != null && error.getXMLNS() == XMLNS) {
            messageElem.removeChild(error);
        }
    }

    public static boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings, Message messageProcessor) {
        block11: {
            if (packet.getElemName() != "message") {
                return false;
            }
            Element deliveryError = C2SDeliveryErrorProcessor.getDeliveryError(packet);
            if (deliveryError == null) {
                return false;
            }
            try {
                if (packet.getStanzaTo() != null && packet.getStanzaTo().getResource() == null && session != null) {
                    if (packet.getElemName() != "message") {
                        return true;
                    }
                    List<XMPPResourceConnection> sessionsForMessageDelivery = messageProcessor.getConnectionsForMessageDelivery(session);
                    if (sessionsForMessageDelivery.isEmpty()) {
                        return false;
                    }
                    String delay = deliveryError.getAttributeStaticStr("stamp");
                    if (delay == null) {
                        return true;
                    }
                    long time = Long.parseLong(delay);
                    for (XMPPResourceConnection conn : sessionsForMessageDelivery) {
                        if (conn.getCreationTime() <= time) continue;
                        Packet result = packet.copyElementOnly();
                        result.setPacketFrom(packet.getPacketTo());
                        result.setPacketTo(conn.getConnectionId());
                        results.offer(result);
                    }
                    return true;
                }
                return false;
            }
            catch (NotAuthorizedException ex) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("NotAuthorizedException while processing undelivered message from C2S, packet = " + packet);
                }
            }
            catch (NoConnectionIdException ex) {
                if (!log.isLoggable(Level.FINEST)) break block11;
                log.finest("NotAuthorizedException while processing undelivered message from C2S, packet = " + packet);
            }
        }
        return false;
    }

    public static boolean isDeliveryError(Packet packet) {
        Element elem = packet.getElement();
        Element error = elem.getChildStaticStr(ELEM_NAME);
        return error != null && error.getXMLNS() == XMLNS;
    }

    public static Element getDeliveryError(Packet packet) {
        Element elem = packet.getElement();
        Element error = elem.getChildStaticStr(ELEM_NAME);
        return error != null && error.getXMLNS() == XMLNS ? error : null;
    }

    public static Packet makeDeliveryError(Packet packet, Long stamp) {
        Packet result = packet.copyElementOnly();
        result.setPacketFrom(packet.getPacketTo());
        Element error = new Element(ELEM_NAME, new String[]{"xmlns"}, new String[]{XMLNS});
        if (stamp != null) {
            error.setAttribute("stamp", String.valueOf(stamp));
        }
        result.getElement().addChild(error);
        return result;
    }
}

