/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorAbstract;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.impl.PresenceAbstract;
import tigase.xmpp.impl.Privacy;
import tigase.xmpp.impl.annotation.DiscoFeatures;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.HandleStanzaTypes;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;

@Id(value="urn:xmpp:blocking")
@DiscoFeatures(value={"urn:xmpp:blocking"})
@Handles(value={@Handle(path={"iq", "blocklist"}, xmlns="urn:xmpp:blocking"), @Handle(path={"iq", "block"}, xmlns="urn:xmpp:blocking"), @Handle(path={"iq", "unblock"}, xmlns="urn:xmpp:blocking")})
@HandleStanzaTypes(value={StanzaType.set, StanzaType.get})
public class BlockingCommand
extends XMPPProcessorAbstract
implements XMPPProcessorIfc {
    private static final Logger log = Logger.getLogger(BlockingCommand.class.getName());
    protected static final String XMLNS = "urn:xmpp:blocking";
    protected static final String XMLNS_ERRORS = "urn:xmpp:blocking:errors";
    protected static final String ID = "urn:xmpp:blocking";
    protected static final String BLOCKLIST = "blocklist";
    protected static final String BLOCK = "block";
    protected static final String UNBLOCK = "unblock";
    private static final String ITEM = "item";
    private static final String _JID = "jid";
    private final RosterAbstract roster_util = RosterFactory.getRosterImplementation(true);

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null || packet.getElemName() != "iq") {
            return;
        }
        StanzaType type = packet.getType();
        try {
            block1 : switch (type) {
                case get: {
                    this.processGet(packet, session, results);
                    break;
                }
                case set: {
                    Element e = packet.getElement().findChild(c -> c.getXMLNS() == "urn:xmpp:blocking");
                    if (e == null) break;
                    switch (e.getName()) {
                        case "block": {
                            this.processSetBlock(packet, e, session, results);
                            break block1;
                        }
                        case "unblock": {
                            this.processSetUnblock(packet, e, session, results);
                            break block1;
                        }
                    }
                    results.offer(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, null, true));
                    break;
                }
            }
        }
        catch (TigaseStringprepRuntimeException ex) {
            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, ex.getMessage(), true));
        }
        catch (TigaseDBException ex) {
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database error", true));
        }
    }

    private void processGet(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws XMPPException, NotAuthorizedException, TigaseDBException {
        if (packet.getElement().getChild(BLOCKLIST, "urn:xmpp:blocking") != null) {
            Element list = new Element(BLOCKLIST);
            list.setXMLNS("urn:xmpp:blocking");
            List<String> jids = Privacy.getBlocked(session);
            if (jids != null) {
                for (String jid : jids) {
                    list.addChild(new Element(ITEM, new String[]{_JID}, new String[]{jid}));
                }
            }
            session.putSessionData("urn:xmpp:blocking", "urn:xmpp:blocking");
            results.offer(packet.okResult(list, 0));
        } else {
            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Bad request", true));
        }
    }

    private void processSetBlock(Packet packet, Element e, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException, TigaseDBException, PacketErrorTypeException {
        List<JID> jids = this.collectJids(e);
        if (jids != null && !jids.isEmpty()) {
            for (JID jid : jids) {
                Privacy.block(session, jid.toString());
                this.sendBlockPresences(session, jid, results);
            }
            results.offer(packet.okResult((Element)null, 0));
            this.sendPush(session.getParentSession(), packet, results);
        } else {
            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Bad request", true));
        }
    }

    private void processSetUnblock(Packet packet, Element e, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException, TigaseDBException {
        List<String> jidsStr;
        List<JID> jids = this.collectJids(e);
        if ((jids == null || jids.isEmpty()) && (jidsStr = Privacy.getBlocked(session)) != null) {
            jids = new ArrayList<JID>(jidsStr.size());
            for (String jidStr : jidsStr) {
                jids.add(JID.jidInstanceNS(jidStr));
            }
        }
        if (jids != null) {
            for (JID jid : jids) {
                Privacy.unblock(session, jid.toString());
                this.sendUnblockPresences(session, jid, results);
            }
        }
        results.offer(packet.okResult((Element)null, 0));
        this.sendPush(session.getParentSession(), packet, results);
    }

    private List<JID> collectJids(Element el) {
        return el.mapChildren(item -> {
            String jid = item.getAttributeStaticStr(_JID);
            try {
                return JID.jidInstance(jid);
            }
            catch (TigaseStringprepException ex) {
                throw new TigaseStringprepRuntimeException("Invalid JID: " + jid, ex);
            }
        });
    }

    private void sendUnblockPresences(XMPPResourceConnection session, JID jid, Queue<Packet> results) throws NotAuthorizedException, TigaseDBException {
        List<XMPPResourceConnection> conns;
        RosterAbstract.SubscriptionType stype = this.roster_util.getBuddySubscription(session, jid);
        if (stype == RosterAbstract.SubscriptionType.both || stype == RosterAbstract.SubscriptionType.from) {
            PresenceAbstract.sendPresence(StanzaType.probe, JID.jidInstance(session.getBareJID()), jid, results, null);
        }
        if ((stype == RosterAbstract.SubscriptionType.both || stype == RosterAbstract.SubscriptionType.to) && (conns = session.getActiveSessions()) != null) {
            for (XMPPResourceConnection conn : conns) {
                Element pres = conn.getPresence();
                if (pres == null) continue;
                PresenceAbstract.sendPresence(null, conn.getjid(), jid, results, pres);
            }
        }
    }

    private void sendBlockPresences(XMPPResourceConnection session, JID jid, Queue<Packet> results) throws NotAuthorizedException, TigaseDBException {
        RosterAbstract.SubscriptionType stype = this.roster_util.getBuddySubscription(session, jid);
        JID[] froms = session.getAllResourcesJIDs();
        if ((stype == RosterAbstract.SubscriptionType.both || stype == RosterAbstract.SubscriptionType.to) && froms != null) {
            for (JID from : froms) {
                PresenceAbstract.sendPresence(StanzaType.unavailable, from, jid, results, null);
            }
        }
    }

    private void sendPush(XMPPSession session, Packet packet, Queue<Packet> results) {
        for (XMPPResourceConnection conn : session.getActiveResources()) {
            if (conn.getSessionData("urn:xmpp:blocking") != "urn:xmpp:blocking") continue;
            try {
                Packet result = packet.copyElementOnly();
                result.initVars(null, conn.getJID());
                result.setPacketTo(conn.getConnectionId());
                results.offer(result);
            }
            catch (NotAuthorizedException ex) {
                log.log(Level.FINEST, "failed to send push notification as session is not yet authorized");
            }
            catch (NoConnectionIdException ex) {
                log.log(Level.FINEST, "failed to send push notification as session is do not have connection id");
            }
        }
    }

    @Override
    public void processFromUserToServerPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
    }

    @Override
    public void processServerSessionPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
    }

    private static class TigaseStringprepRuntimeException
    extends RuntimeException {
        public TigaseStringprepRuntimeException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

