/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPResourceConnection;

public abstract class AbstractAuthPreprocessor
extends XMPPProcessor
implements XMPPPreprocessorIfc {
    private static final Logger log = Logger.getLogger(AbstractAuthPreprocessor.class.getCanonicalName());
    private static final String[] AUTH_ONLY_ELEMS = new String[]{"message", "presence"};

    @Override
    public boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null || session.isServerSession()) {
            return false;
        }
        try {
            if (session.getConnectionId().equals(packet.getPacketFrom()) && !session.isAuthorized()) {
                for (String elem : AUTH_ONLY_ELEMS) {
                    if (packet.getElemName() != elem) continue;
                    results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authenticate session first, before you can send any message or presence packet.", true));
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Packet received before the session has been authenticated.Session details: connectionId={0}, sessionId={1}, packet={2}", new Object[]{session.getConnectionId(), session.getSessionId(), packet.toStringSecure()});
                    }
                    return true;
                }
                return false;
            }
        }
        catch (PacketErrorTypeException e) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Ignoring packet with an error to non-existen user session: {0}", packet.toStringSecure());
            }
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Packet preprocessing exception: ", e);
            return false;
        }
        return false;
    }
}

