/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.HashMap;
import java.util.Map;

public enum StreamError {
    BadFormat("bad-format"),
    BadNamespacePrefix("bad-namespace-prefix"),
    Conflict("conflict"),
    ConnectionTimeout("connection-timeout"),
    HostGone("host-gone"),
    HostUnknown("host-unknown"),
    ImproperAddressing("improper-addressing"),
    InternalServerError("internal-server-error"),
    InvalidFrom("invalid-from"),
    InvalidNamespace("invalid-namespace"),
    InvalidXml("invalid-xml"),
    NotAuthorized("not-authorized"),
    NotWellFormed("not-well-formed"),
    PolicyViolation("policy-violation"),
    RemoteConnectionFailed("remote-connection-failed"),
    Reset("reset"),
    ResourceConstraint("resource-constraint"),
    RestrictedXml("restricted-xml"),
    SeeOtherHost("see-other-host"),
    SystemShutdown("system-shutdown"),
    UndefinedCondition("undefined-condition"),
    UnsupportedEncoding("unsupported-encoding"),
    UnsupportedFeature("unsupported-feature"),
    UnsupportedStanzaType("unsupported-stanza-type"),
    UnsupportedVersion("unsupported-version");

    private static final Map<String, StreamError> BY_CONDITION;
    private final String condition;

    public static StreamError getByCondition(String condition) {
        StreamError err = BY_CONDITION.get(condition);
        if (err == null) {
            return UndefinedCondition;
        }
        return err;
    }

    private StreamError(String condition) {
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }

    static {
        BY_CONDITION = new HashMap<String, StreamError>();
        for (StreamError err : StreamError.values()) {
            BY_CONDITION.put(err.getCondition(), err);
        }
    }
}

