/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.util.ClassUtil;
import tigase.xmpp.XMPPImplIfc;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPPostprocessorIfc;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPStopListenerIfc;

public class ProcessorFactory {
    private static final Logger log = Logger.getLogger(ProcessorFactory.class.getName());
    private static final Map<String, XMPPImplIfc> processors = new TreeMap<String, XMPPImplIfc>();

    private ProcessorFactory() {
    }

    public static XMPPPacketFilterIfc getPacketFilter(String id) {
        XMPPImplIfc imp = processors.get(id);
        if (imp instanceof XMPPPacketFilterIfc) {
            return (XMPPPacketFilterIfc)imp;
        }
        return null;
    }

    public static XMPPPostprocessorIfc getPostprocessor(String id) {
        XMPPImplIfc imp = processors.get(id);
        if (imp instanceof XMPPPostprocessorIfc) {
            return (XMPPPostprocessorIfc)imp;
        }
        return null;
    }

    public static XMPPPreprocessorIfc getPreprocessor(String id) {
        XMPPImplIfc imp = processors.get(id);
        if (imp instanceof XMPPPreprocessorIfc) {
            return (XMPPPreprocessorIfc)imp;
        }
        return null;
    }

    public static XMPPProcessorIfc getProcessor(String id) {
        XMPPImplIfc imp = processors.get(id);
        if (imp instanceof XMPPProcessorIfc) {
            return (XMPPProcessorIfc)imp;
        }
        return null;
    }

    public static XMPPStopListenerIfc getStopListener(String id) {
        XMPPImplIfc imp = processors.get(id);
        if (imp instanceof XMPPStopListenerIfc) {
            return (XMPPStopListenerIfc)imp;
        }
        return null;
    }

    public static boolean hasImplementation(String id) {
        return processors.containsKey(id);
    }

    static {
        try {
            Set<Class<XMPPImplIfc>> procs = ClassUtil.getClassesImplementing(XMPPImplIfc.class);
            ArrayList<String> elems = new ArrayList<String>(32);
            for (Class<XMPPImplIfc> cproc : procs) {
                if (!Modifier.isPublic(cproc.getModifiers())) continue;
                XMPPImplIfc xproc = (XMPPImplIfc)cproc.newInstance();
                processors.put(xproc.id(), xproc);
                String[][] els = xproc.supElementNamePaths();
                String[] nss = xproc.supNamespaces();
                if (els == null || nss == null) continue;
                for (int i = 0; i < els.length; ++i) {
                    String el_name = "";
                    for (int j = 0; j < els[i].length; ++j) {
                        el_name = el_name + "/" + els[i][j];
                    }
                    elems.add("  <" + el_name + " xmlns='" + nss[i] + "'/>\n");
                }
            }
            Collections.sort(elems);
            if (log.isLoggable(Level.FINEST)) {
                StringBuilder sb = new StringBuilder(200);
                for (String elm : elems) {
                    sb.append(elm);
                }
                log.log(Level.FINEST, "Loaded XMPPProcessors:\n{0}", sb);
            }
        }
        catch (Exception e) {
            System.out.println("Can not load XMPPProcessor implementations");
            e.printStackTrace();
            log.log(Level.SEVERE, "Can not load XMPPProcessor implementations", e);
            System.exit(1);
        }
    }
}

