/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tigase.server.Packet;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public enum Authorization {
    AUTHORIZED{

        @Override
        public String getCondition() {
            return null;
        }

        @Override
        public int getErrorCode() {
            return 0;
        }

        @Override
        public String getErrorType() {
            return null;
        }

        @Override
        public Packet getResponseMessage(Packet p, String t, boolean i) {
            return p.okResult(t, 0);
        }
    }
    ,
    BAD_REQUEST{

        @Override
        public String getCondition() {
            return "bad-request";
        }

        @Override
        public int getErrorCode() {
            return 400;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_MODIFY;
        }
    }
    ,
    CONFLICT{

        @Override
        public String getCondition() {
            return "conflict";
        }

        @Override
        public int getErrorCode() {
            return 409;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_CANCEL;
        }
    }
    ,
    FEATURE_NOT_IMPLEMENTED{

        @Override
        public String getCondition() {
            return "feature-not-implemented";
        }

        @Override
        public int getErrorCode() {
            return 501;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_CANCEL;
        }
    }
    ,
    FORBIDDEN{

        @Override
        public String getCondition() {
            return "forbidden";
        }

        @Override
        public int getErrorCode() {
            return 403;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_AUTH;
        }
    }
    ,
    GONE{

        @Override
        public String getCondition() {
            return "gone";
        }

        @Override
        public int getErrorCode() {
            return 302;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_MODIFY;
        }
    }
    ,
    INTERNAL_SERVER_ERROR{

        @Override
        public String getCondition() {
            return "internal-server-error";
        }

        @Override
        public int getErrorCode() {
            return 500;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_WAIT;
        }
    }
    ,
    ITEM_NOT_FOUND{

        @Override
        public String getCondition() {
            return "item-not-found";
        }

        @Override
        public int getErrorCode() {
            return 404;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_CANCEL;
        }
    }
    ,
    JID_MALFORMED{

        @Override
        public String getCondition() {
            return "jid-malformed";
        }

        @Override
        public int getErrorCode() {
            return 400;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_MODIFY;
        }
    }
    ,
    NOT_ACCEPTABLE{

        @Override
        public String getCondition() {
            return "not-acceptable";
        }

        @Override
        public int getErrorCode() {
            return 406;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_MODIFY;
        }
    }
    ,
    NOT_ALLOWED{

        @Override
        public String getCondition() {
            return "not-allowed";
        }

        @Override
        public int getErrorCode() {
            return 405;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_CANCEL;
        }
    }
    ,
    NOT_AUTHORIZED{

        @Override
        public String getCondition() {
            return "not-authorized";
        }

        @Override
        public int getErrorCode() {
            return 401;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_AUTH;
        }
    }
    ,
    PAYMENT_REQUIRED{

        @Override
        public String getCondition() {
            return "payment-required";
        }

        @Override
        public int getErrorCode() {
            return 402;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_AUTH;
        }
    }
    ,
    POLICY_VIOLATION{

        @Override
        public String getCondition() {
            return "policy-violation";
        }

        @Override
        public int getErrorCode() {
            return 0;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_CANCEL;
        }
    }
    ,
    RECIPIENT_UNAVAILABLE{

        @Override
        public String getCondition() {
            return "recipient-unavailable";
        }

        @Override
        public int getErrorCode() {
            return 404;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_WAIT;
        }
    }
    ,
    REDIRECT{

        @Override
        public String getCondition() {
            return "redirect";
        }

        @Override
        public int getErrorCode() {
            return 302;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_MODIFY;
        }
    }
    ,
    REGISTRATION_REQUIRED{

        @Override
        public String getCondition() {
            return "registration-required";
        }

        @Override
        public int getErrorCode() {
            return 407;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_AUTH;
        }
    }
    ,
    REMOTE_SERVER_NOT_FOUND{

        @Override
        public String getCondition() {
            return "remote-server-not-found";
        }

        @Override
        public int getErrorCode() {
            return 404;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_CANCEL;
        }
    }
    ,
    REMOTE_SERVER_TIMEOUT{

        @Override
        public String getCondition() {
            return "remote-server-timeout";
        }

        @Override
        public int getErrorCode() {
            return 504;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_WAIT;
        }
    }
    ,
    RESOURCE_CONSTRAINT{

        @Override
        public String getCondition() {
            return "resource-constraint";
        }

        @Override
        public int getErrorCode() {
            return 500;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_WAIT;
        }
    }
    ,
    SERVICE_UNAVAILABLE{

        @Override
        public String getCondition() {
            return "service-unavailable";
        }

        @Override
        public int getErrorCode() {
            return 503;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_CANCEL;
        }
    }
    ,
    SUBSCRIPTION_REQUIRED{

        @Override
        public String getCondition() {
            return "subscription-required";
        }

        @Override
        public int getErrorCode() {
            return 407;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_AUTH;
        }
    }
    ,
    UNDEFINED_CONDITION{

        @Override
        public String getCondition() {
            return "undefined-condition";
        }

        @Override
        public int getErrorCode() {
            return 500;
        }

        @Override
        public String getErrorType() {
            return "[undefined]";
        }
    }
    ,
    UNEXPECTED_REQUEST{

        @Override
        public String getCondition() {
            return "unexpected-request";
        }

        @Override
        public int getErrorCode() {
            return 400;
        }

        @Override
        public String getErrorType() {
            return Authorization.ERR_TYPE_WAIT;
        }
    };

    protected static final String ERR_TYPE_AUTH = "auth";
    protected static final String ERR_TYPE_CANCEL = "cancel";
    protected static final String ERR_TYPE_MODIFY = "modify";
    protected static final String ERR_TYPE_WAIT = "wait";
    private static final Map<String, Authorization> BY_CONDITION;

    public static Authorization getByCondition(String condition) {
        if (condition == null) {
            return null;
        }
        return BY_CONDITION.get(condition);
    }

    public abstract String getCondition();

    public abstract int getErrorCode();

    public abstract String getErrorType();

    public Packet getResponseMessage(Packet packet, String text, boolean includeOriginalXML) throws PacketErrorTypeException {
        if (packet.getType() == null || packet.getType() != StanzaType.error) {
            return packet.errorResult(this.getErrorType(), this.getErrorCode(), this.getCondition(), text, includeOriginalXML);
        }
        throw new PacketErrorTypeException("The packet has already 'error' type: " + packet.toString());
    }

    static {
        BY_CONDITION = new ConcurrentHashMap<String, Authorization>();
        for (Authorization v : Authorization.values()) {
            if (v.getCondition() == null) continue;
            BY_CONDITION.put(v.getCondition(), v);
        }
    }
}

