/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.io.FileReader;
import java.util.Queue;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleParser;

public abstract class XMLUtils {
    private static final String[] decoded = new String[]{"&", "<", ">", "\"", "'"};
    private static final String[] encoded = new String[]{"&amp;", "&lt;", "&gt;", "&quot;", "&apos;"};
    private static final String[] decoded_1 = new String[]{"<", ">", "\"", "'", "&"};
    private static final String[] encoded_1 = new String[]{"&lt;", "&gt;", "&quot;", "&apos;", "&amp;"};

    public static String escape(String input) {
        if (input != null) {
            return XMLUtils.translateAll(input, decoded, encoded);
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("You must give a file name as a parameter.");
            System.exit(1);
        }
        FileReader file = new FileReader(args[0]);
        char[] buff = new char[16384];
        SimpleParser parser = new SimpleParser();
        DomBuilderHandler dombuilder = new DomBuilderHandler();
        int result = -1;
        while ((result = file.read(buff)) != -1) {
            parser.parse(dombuilder, buff, 0, result);
        }
        file.close();
        Queue<Element> results = dombuilder.getParsedElements();
        for (Element elem : results) {
            System.out.println(elem.toString());
        }
    }

    public static String translateAll(String input, String[] patterns, String[] replacements) {
        String result = input;
        for (int i = 0; i < patterns.length; ++i) {
            result = result.replace(patterns[i], replacements[i]);
        }
        return result;
    }

    public static String unescape(String input) {
        if (input != null) {
            return XMLUtils.translateAll(input, encoded_1, decoded_1);
        }
        return null;
    }
}

