/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;
import tigase.db.AuthRepository;
import tigase.db.RepositoryFactory;
import tigase.db.UserExistsException;
import tigase.db.UserRepository;
import tigase.util.TigaseStringprepException;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class RepositoryUtils {
    private static long counter = 0L;
    private static BareJID user1 = BareJID.bareJIDInstanceNS("user111@hostname");
    private static BareJID user2 = BareJID.bareJIDInstanceNS("user222@hostname");
    private static BareJID user3 = BareJID.bareJIDInstanceNS("user333@hostname");
    private static String src_class = "tigase.db.jdbc.JDBCRepository";
    private static String src_uri = null;
    private static String dst_class = null;
    private static String dst_uri = null;
    private static String content = null;
    private static BareJID user = null;
    private static boolean simple_test = false;
    private static boolean add_user_test = false;
    private static boolean copy_repos = false;
    private static boolean print_repo = false;
    private static boolean add = false;
    private static boolean del = false;
    private static boolean node = false;
    private static boolean key_val = false;
    private static boolean check_roster = false;
    private static boolean allowed_empty_groups = true;
    private static boolean import_data = false;
    private static boolean export_data = false;
    private static String subnode = null;
    private static String key = null;
    private static String value = null;
    private static String import_file = null;
    private static String export_file = null;

    public static boolean checkContact(BareJID user, UserRepository repo, String cont) throws Exception {
        JID contact = JID.jidInstanceNS(cont);
        String[] vals = repo.getDataList(user, "roster/" + contact, "groups");
        if (vals == null || vals.length == 0) {
            System.out.println("      Empty groups list");
            if (!allowed_empty_groups) {
                return false;
            }
        } else {
            for (String val : vals) {
                if (!val.equals("Upline Support") && !val.equals("Support") && !val.startsWith("Level ")) continue;
                System.out.println("      Invalid group: " + val);
                return false;
            }
        }
        return true;
    }

    public static void copyNode(BareJID user, String node, UserRepository src, UserRepository dst) throws Exception {
        String[] nodes;
        String[] keys = src.getKeys(user, node);
        if (keys != null) {
            for (String key : keys) {
                String[] vals = src.getDataList(user, node, key);
                if (vals == null) continue;
                dst.setDataList(user, node, key, vals);
            }
        }
        if ((nodes = src.getSubnodes(user, node)) != null) {
            for (String subnode : nodes) {
                RepositoryUtils.copyNode(user, node != null ? node + "/" + subnode : subnode, src, dst);
            }
        }
    }

    public static void copyRepositories(UserRepository src, UserRepository dst) throws Exception {
        if (user != null) {
            RepositoryUtils.copyUser(user, src, dst);
        } else {
            List<BareJID> users = src.getUsers();
            if (users != null) {
                System.out.println("Found " + users.size() + " in the source repository.");
                for (BareJID usr : users) {
                    System.out.println("Found " + usr + " in the source repository.");
                    RepositoryUtils.copyUser(usr, src, dst);
                }
            } else {
                System.out.println("There are no user accounts in source repository.");
            }
        }
    }

    public static void copyRepositories(UserRepository src, AuthRepository dst) throws Exception {
        if (user != null) {
            RepositoryUtils.copyUser(user, src, dst);
        } else {
            List<BareJID> users = src.getUsers();
            if (users != null) {
                for (BareJID usr : users) {
                    RepositoryUtils.copyUser(usr, src, dst);
                }
            } else {
                System.out.println("There are no user accounts in source repository.");
            }
        }
    }

    public static void copyUser(BareJID user, UserRepository src, UserRepository dst) throws Exception {
        if (user == null) {
            return;
        }
        System.out.print("Copying user: " + user + "...");
        try {
            dst.addUser(user);
            RepositoryUtils.copyNode(user, null, src, dst);
            System.out.println("OK");
        }
        catch (UserExistsException e) {
            System.out.println("ERROR, user already exists.");
        }
    }

    public static void copyUser(BareJID user, UserRepository src, AuthRepository dst) throws Exception {
        if (user == null) {
            return;
        }
        System.out.print("Copying user: " + user + "...");
        String password = src.getData(user, "password");
        try {
            dst.addUser(user, password);
            System.out.println("OK");
        }
        catch (UserExistsException e) {
            System.out.println("ERROR, user already exists.");
        }
    }

    public static void exportRoster(UserRepository repo, Writer w) throws Exception {
        if (user != null) {
            RepositoryUtils.exportUserRoster(user, repo, w);
        } else {
            List<BareJID> users = repo.getUsers();
            if (users != null) {
                for (BareJID usr : users) {
                    RepositoryUtils.exportUserRoster(usr, repo, w);
                }
            } else {
                System.out.println("There are no user accounts in repository.");
            }
        }
    }

    public static void exportUserRoster(BareJID user, UserRepository repo, Writer w) throws Exception {
        System.out.println("  " + ++counter + ". " + user + " roster: ");
        String[] contacts = repo.getSubnodes(user, "roster");
        if (contacts != null) {
            for (String contact : contacts) {
                System.out.println("    contact: " + contact);
                boolean valid = RepositoryUtils.checkContact(user, repo, contact);
                if (valid) {
                    System.out.println("      looks OK");
                    String password = repo.getData(user, "password");
                    String[] groups = repo.getDataList(user, "roster/" + contact, "groups");
                    String contact_nick = repo.getData(user, "roster/" + contact, "name");
                    String subscription = repo.getData(user, "roster/" + contact, "subscription");
                    StringBuilder sb = new StringBuilder(user.toString());
                    sb.append(",");
                    if (password != null) {
                        sb.append(password);
                    }
                    sb.append("," + contact);
                    sb.append(",");
                    if (contact_nick != null) {
                        sb.append(contact_nick);
                    }
                    sb.append(",");
                    if (subscription != null) {
                        sb.append(subscription);
                    }
                    if (groups != null && groups.length > 0) {
                        for (String group : groups) {
                            sb.append("," + group);
                        }
                    }
                    sb.append("\n");
                    w.write(sb.toString());
                    continue;
                }
                System.out.println("      should be REMOVED");
                String contact_node = "roster/" + contact;
                System.out.println("      removing node: " + contact_node);
                System.out.println("      DONE.");
            }
        } else {
            System.out.println("    empty roster...");
        }
    }

    public static void loadTestData(UserRepository repo) throws Exception {
        try {
            repo.addUser(user1);
        }
        catch (UserExistsException userExistsException) {
            // empty catch block
        }
        try {
            repo.addUser(user2);
        }
        catch (UserExistsException userExistsException) {
            // empty catch block
        }
        try {
            repo.addUser(user3);
        }
        catch (UserExistsException userExistsException) {
            // empty catch block
        }
        repo.setData(user1, null, "password", "secret111");
        repo.setData(user2, null, "password", "secret222");
        repo.setData(user3, null, "password", "secret333");
        repo.setData(user1, "roster/buddy111", "name", "budy1");
        repo.setData(user1, "roster/buddy222", "name", "budy2");
        repo.setData(user1, "roster/buddy333", "name", "budy3");
        repo.setDataList(user1, "roster/buddy111", "groups", new String[]{"buddies", "friends"});
        repo.setDataList(user2, "roster/buddy111", "groups", new String[]{"buddies", "friends"});
        repo.addDataList(user2, "roster/buddy111", "groups", new String[]{"family", "home"});
    }

    public static void main(String[] args) throws Exception {
        RepositoryUtils.parseParams(args);
        Exception repo_exc = null;
        UserRepository src_repo = null;
        AuthRepository src_auth = null;
        try {
            src_repo = RepositoryFactory.getUserRepository(src_class, src_uri, null);
            System.out.println("Loaded src_repo " + src_repo.getClass().getName() + " for parameters:\n   src_class=" + src_class + "\n   src_uri=" + src_uri);
        }
        catch (Exception e) {
            repo_exc = e;
            src_repo = null;
        }
        if (src_repo == null) {
            try {
                src_auth = RepositoryFactory.getAuthRepository(src_class, src_uri, null);
                System.out.println("Loaded src_auth " + src_auth.getClass().getName() + " for parameters:\n   src_class=" + src_class + "\n   src_uri=" + src_uri);
            }
            catch (Exception e) {
                System.out.println("Incorrect source class name given (or connection URI).");
                System.out.println("class: " + src_class);
                System.out.println("uri: " + src_uri);
                System.out.println("Can't initialize repository:");
                repo_exc.printStackTrace();
                e.printStackTrace();
                System.exit(-1);
            }
        }
        if (simple_test) {
            System.out.println("Simple test on repository:");
            RepositoryUtils.simpleTest(src_repo);
        }
        if (add_user_test) {
            System.out.println("Simple test on repository:");
            RepositoryUtils.userAddTest(src_repo);
        }
        if (add) {
            if (key_val && src_repo != null) {
                System.out.println("Adding key=value: " + content);
                RepositoryUtils.parseNodeKeyValue(content);
                System.out.println("Parsed parameters: user=" + user + ", node=" + subnode + ", key=" + key + ", value=" + value);
                src_repo.setData(user, subnode, key, value);
            } else {
                System.out.println("Adding user: " + user);
                if (src_repo != null) {
                    src_repo.addUser(user);
                }
                if (src_auth != null) {
                    BareJID name = user;
                    String password = "";
                    src_auth.addUser(name, password);
                }
            }
        }
        if (del) {
            if (key_val || node) {
                if (key_val) {
                    System.out.println("Deleting data: " + content);
                    RepositoryUtils.parseNodeKeyValue(content);
                    System.out.println("Parsed parameters: user=" + user + ", node=" + subnode + ", key=" + key + ", value=" + value);
                    src_repo.removeData(user, subnode, key);
                }
                if (node) {
                    System.out.println("Deleting data node: " + content);
                    src_repo.removeSubnode(user, content);
                }
            } else {
                System.out.println("Deleting user: " + user);
                if (src_repo != null) {
                    src_repo.removeUser(user);
                }
                if (src_auth != null) {
                    src_auth.removeUser(user);
                }
            }
        }
        if (copy_repos) {
            UserRepository dst_repo = null;
            Exception dst_exc = null;
            AuthRepository dst_auth = null;
            try {
                dst_repo = RepositoryFactory.getUserRepository(dst_class, dst_uri, null);
                System.out.println("Loaded dst_repo " + dst_repo.getClass().getName() + " for parameters:\n   src_class=" + dst_class + "\n   src_uri=" + dst_uri);
                RepositoryUtils.copyRepositories(src_repo, dst_repo);
            }
            catch (Exception e) {
                dst_exc = e;
                dst_repo = null;
            }
            if (dst_repo == null) {
                try {
                    dst_auth = RepositoryFactory.getAuthRepository(dst_class, dst_uri, null);
                    System.out.println("Loaded dst_auth " + dst_auth.getClass().getName() + " for parameters:\n   src_class=" + dst_class + "\n   src_uri=" + dst_uri);
                }
                catch (Exception e) {
                    System.out.println("Incorrect destination class name given (or connection URI).");
                    System.out.println("Can't initialize repository:");
                    dst_exc.printStackTrace();
                    e.printStackTrace();
                    System.exit(-1);
                }
                RepositoryUtils.copyRepositories(src_repo, dst_auth);
            }
        }
        if (check_roster && src_repo != null) {
            System.out.println("Checking roster:");
            if (user != null) {
                RepositoryUtils.repairUserRoster(user, src_repo);
            } else {
                RepositoryUtils.repairRoster(src_repo);
            }
        }
        if (import_data && src_repo != null) {
            BufferedReader br = new BufferedReader(new FileReader(import_file));
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] vals = line.split(",");
                BareJID userId = BareJID.bareJIDInstance(vals[0].trim());
                try {
                    src_repo.addUser(userId);
                }
                catch (UserExistsException userExistsException) {
                    // empty catch block
                }
                if (vals.length >= 2 && vals[1].trim().length() > 0) {
                    src_repo.setData(userId, null, "password", vals[1].trim());
                }
                if (vals.length >= 3 && vals[2].trim().length() > 0) {
                    src_repo.setData(userId, "roster/" + vals[2].trim(), "name", vals[2].trim());
                }
                if (vals.length >= 4 && vals[3].trim().length() > 0) {
                    src_repo.setData(userId, "roster/" + vals[2].trim(), "name", vals[3].trim());
                }
                if (vals.length >= 5 && vals[4].trim().length() > 0) {
                    src_repo.setData(userId, "roster/" + vals[2].trim(), "subscription", vals[4].trim());
                }
                if (vals.length < 6 || vals[5].trim().length() <= 0) continue;
                src_repo.setData(userId, "roster/" + vals[2].trim(), "groups", vals[5].trim());
            }
            br.close();
        }
        if (export_data && src_repo != null) {
            FileWriter fr = new FileWriter(export_file);
            if (user != null) {
                RepositoryUtils.exportUserRoster(user, src_repo, fr);
            } else {
                RepositoryUtils.exportRoster(src_repo, fr);
            }
            fr.close();
        }
        if (print_repo && src_repo != null) {
            System.out.println("Printing repository:");
            if (content != null) {
                if (node) {
                    subnode = content;
                } else {
                    RepositoryUtils.parseNodeKeyValue(content);
                }
            }
            if (user != null) {
                if (key_val) {
                    System.out.println(src_repo.getData(user, subnode, key, null));
                } else if (node) {
                    RepositoryUtils.printNode(user, src_repo, "  ", subnode);
                } else {
                    RepositoryUtils.printNode(user, src_repo, "", null);
                }
            } else {
                RepositoryUtils.printRepoContent(src_repo);
            }
        }
    }

    public static void parseParams(String[] args) throws TigaseStringprepException {
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-h")) {
                    System.out.print(RepositoryUtils.help());
                    System.exit(0);
                }
                if (args[i].equals("-sc")) {
                    src_class = args[++i];
                }
                if (args[i].equals("-su")) {
                    src_uri = args[++i];
                }
                if (args[i].equals("-dc")) {
                    dst_class = args[++i];
                }
                if (args[i].equals("-du")) {
                    dst_uri = args[++i];
                }
                if (args[i].equals("-dt")) {
                    content = args[++i];
                }
                if (args[i].equals("-st")) {
                    simple_test = true;
                }
                if (args[i].equals("-at")) {
                    add_user_test = true;
                }
                if (args[i].equals("-cp")) {
                    copy_repos = true;
                }
                if (args[i].equals("-pr")) {
                    print_repo = true;
                }
                if (args[i].equals("-u")) {
                    user = BareJID.bareJIDInstance(args[++i]);
                }
                if (args[i].equals("-n")) {
                    node = true;
                }
                if (args[i].equals("-kv")) {
                    key_val = true;
                }
                if (args[i].equals("-add")) {
                    add = true;
                }
                if (args[i].equals("-del")) {
                    del = true;
                }
                if (args[i].equals("-roster")) {
                    check_roster = true;
                }
                if (args[i].equals("-import")) {
                    import_data = true;
                    import_file = args[++i];
                }
                if (args[i].equals("-export")) {
                    export_data = true;
                    export_file = args[++i];
                }
                if (!args[i].equals("-aeg")) continue;
                allowed_empty_groups = args[++i].equals("true");
            }
        }
    }

    public static void printNode(BareJID user, UserRepository repo, String prefix, String node) throws Exception {
        String[] nodes;
        String[] keys;
        if (node != null) {
            System.out.println(prefix + "node: " + node);
        }
        if ((keys = repo.getKeys(user, node)) != null) {
            for (String key : keys) {
                String[] vals = repo.getDataList(user, node, key);
                if (vals != null) {
                    StringBuilder valstr = new StringBuilder();
                    for (String val : vals) {
                        valstr.append(" ").append(val);
                    }
                    System.out.println(prefix + "  " + key + " = " + valstr);
                    continue;
                }
                System.out.println("    " + key);
            }
        }
        if ((nodes = repo.getSubnodes(user, node)) != null) {
            for (String subnode : nodes) {
                RepositoryUtils.printNode(user, repo, prefix + "  ", node != null ? node + "/" + subnode : subnode);
            }
        }
    }

    public static void printRepoContent(UserRepository repo) throws Exception {
        if (user != null) {
            RepositoryUtils.printNode(user, repo, "  ", subnode);
        } else {
            List<BareJID> users = repo.getUsers();
            if (users != null) {
                for (BareJID usr : users) {
                    System.out.println(usr);
                    RepositoryUtils.printNode(usr, repo, "  ", subnode);
                }
            } else {
                System.out.println("There are no user accounts in repository.");
            }
        }
    }

    public static void removeTestData(UserRepository repo) throws Exception {
        repo.removeUser(user1);
        repo.removeUser(user2);
        repo.removeUser(user3);
    }

    public static void repairRoster(UserRepository repo) throws Exception {
        if (user != null) {
            RepositoryUtils.repairUserRoster(user, repo);
        } else {
            List<BareJID> users = repo.getUsers();
            if (users != null) {
                for (BareJID usr : users) {
                    RepositoryUtils.repairUserRoster(usr, repo);
                }
            } else {
                System.out.println("There are no user accounts in repository.");
            }
        }
    }

    public static void repairUserRoster(BareJID user, UserRepository repo) throws Exception {
        System.out.println("  " + ++counter + ". " + user + " roster: ");
        String[] contacts = repo.getSubnodes(user, "roster");
        if (contacts != null) {
            for (String contact : contacts) {
                System.out.println("    contact: " + contact);
                boolean valid = RepositoryUtils.checkContact(user, repo, contact);
                if (valid) {
                    System.out.println("      looks OK");
                    continue;
                }
                System.out.println("      should be REMOVED");
                String contact_node = "roster/" + contact;
                System.out.println("      removing node: " + contact_node);
                repo.removeSubnode(user, contact_node);
                System.out.println("      DONE.");
            }
        } else {
            System.out.println("    empty roster...");
        }
    }

    public static void simpleTest(UserRepository repo) throws Exception {
        RepositoryUtils.printRepoContent(repo);
        try {
            repo.addUser(user1);
        }
        catch (UserExistsException userExistsException) {
            // empty catch block
        }
        RepositoryUtils.printRepoContent(repo);
        RepositoryUtils.removeTestData(repo);
        RepositoryUtils.printRepoContent(repo);
    }

    public static void userAddTest(UserRepository re) throws Exception {
        AuthRepository repo = (AuthRepository)((Object)re);
        BareJID test_user = BareJID.bareJIDInstanceNS("test111@localhost");
        RepositoryUtils.printRepoContent(re);
        try {
            repo.addUser(test_user, "some-pass");
        }
        catch (UserExistsException e) {
            e.printStackTrace();
        }
        RepositoryUtils.printRepoContent(re);
        System.out.println(re.getData(test_user, "privacy", "default-list", null));
        repo.removeUser(test_user);
        RepositoryUtils.printRepoContent(re);
    }

    private static String help() {
        return "\nParameters:\n -h          this help message\n -sc class   source repository class name\n -su uri     source repository init string\n -dc class   destination repository class name\n -du uri     destination repository init string\n -dt string  data content to set/remove in repository\n -u user     user ID, if given all operations are only for that ID\n             if you want to add user to AuthRepository parameter must\n             in form: \"user:password\"\n -st         perform simple test on repository\n -at         simple test for adding and removing user\n -cp         copy content from source to destination repository\n -pr         print content of the repository\n -n          data content string is a node string\n -kv         data content string is node/key=value string\n -add        add data content to repository\n -del        delete data content from repository\n ------------\n -roster     check the user roster\n -aeg [true|false]  Allow empty group list for the contact\n -import file  import user data from the file of following format:\n         user_jid, password, roser_jid, roster_nick, subscription, group\n -export file  export user roster data to the specified file in the following\n              format: user_jid, password, roser_jid, roster_nick, subscription,\n               group\n\n\nNote! If you put UserAuthRepository implementation as a class name\n      some operation are not allowed and will be silently skipped.\n      Have a look at UserAuthRepository to see what operations are\n      possible or what operation does make sense.\n      Alternatively look for admin tools guide on web site.\n";
    }

    private static void parseNodeKeyValue(String data) {
        int val_idx = data.indexOf(61);
        value = data.substring(val_idx + 1);
        String tmp_str = data.substring(0, val_idx);
        int key_idx = tmp_str.lastIndexOf(47);
        if (key_idx >= 0) {
            key = tmp_str.substring(key_idx + 1);
            subnode = tmp_str.substring(0, key_idx);
        } else {
            key = tmp_str;
        }
    }
}

