/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import tigase.util.NonpriorityQueue;
import tigase.util.PriorityQueueRelaxed;

public abstract class PriorityQueueAbstract<E> {
    public static final String NONPRIORITY_QUEUE = "nonpriority-queue";
    public static final String QUEUE_IMPLEMENTATION = "queue-implementation";

    public abstract void init(int var1, int var2);

    public abstract boolean offer(E var1, int var2);

    public abstract void put(E var1, int var2) throws InterruptedException;

    public abstract void setMaxSize(int var1);

    public abstract int[] size();

    public abstract E take() throws InterruptedException;

    public abstract int totalSize();

    public static <E> PriorityQueueAbstract<E> getPriorityQueue(int maxPriority, int maxSize) {
        PriorityQueueAbstract result = null;
        String queue_class = System.getProperty(QUEUE_IMPLEMENTATION, null);
        if (queue_class == null || queue_class.isEmpty()) {
            result = Boolean.getBoolean(NONPRIORITY_QUEUE) ? new NonpriorityQueue(maxSize) : new PriorityQueueRelaxed(maxPriority, maxSize);
        } else {
            try {
                result = (PriorityQueueAbstract)Class.forName(queue_class).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            result.init(maxPriority, maxSize);
        }
        return result;
    }
}

