/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ListDiffCalculator {
    private static <T> int commons(Collection<T> toCheck, Collection<T> inList) {
        int r = 0;
        for (T t : toCheck) {
            if (!inList.contains(t)) continue;
            ++r;
        }
        return r;
    }

    public <T> float calcDiff(T[] t1, T[] t2) {
        List<T> l1 = Arrays.asList(t1);
        List<T> l2 = Arrays.asList(t2);
        return this.calcDiff(l1, l2);
    }

    public <T> float calcDiff(Collection<T> l1, Collection<T> l2) {
        if (l1.size() == 0 && l2.size() == 0) {
            return 0.0f;
        }
        if (Collections.disjoint(l1, l2)) {
            return 1.0f;
        }
        if (l1.equals(l2)) {
            return 0.0f;
        }
        float s = Math.max(l1.size(), l2.size());
        float comm = ListDiffCalculator.commons(l1, l2);
        float r = 1.0f - comm / s;
        return r;
    }
}

