/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

public class IntHistoryCache {
    private int[] buffer = null;
    private int start = 0;
    private int count = 0;

    public IntHistoryCache(int limit) {
        this.buffer = new int[limit];
    }

    public synchronized void addItem(int item) {
        int ix = (this.start + this.count) % this.buffer.length;
        this.buffer[ix] = item;
        if (this.count < this.buffer.length) {
            ++this.count;
        } else {
            ++this.start;
            this.start %= this.buffer.length;
        }
    }

    public synchronized int[] getCurrentHistory() {
        int[] result = new int[this.count];
        for (int i = 0; i < this.count; ++i) {
            int ix = (this.start + i) % this.buffer.length;
            result[i] = this.buffer[ix];
        }
        return result;
    }
}

