/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.time.LocalDate;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;

public class MaxDailyCounterQueue<E extends Number>
extends ArrayDeque<E> {
    private final int limit;
    private LocalDate lastDailyStatsReset = LocalDate.now();
    private String toString = "[]";

    public static void main(String[] args) {
        MaxDailyCounterQueue<Integer> lq = new MaxDailyCounterQueue<Integer>(15){
            int i = 0;

            @Override
            protected boolean isNextItem() {
                return this.i++ % 4 == 0;
            }
        };
        for (int i = 0; i < 200; ++i) {
            int rand = ThreadLocalRandom.current().nextInt(0, 100);
            lq.add(rand);
            System.out.print(lq.toString());
            System.out.print("       max: " + lq.getMaxValueInRange(3));
            System.out.print("       sup-limit: " + lq.isLimitSurpassedAllItems(3, 50L));
            System.out.println();
        }
    }

    public MaxDailyCounterQueue(int limit) {
        this.limit = limit;
    }

    @Override
    public boolean add(E added) {
        if (this.isNextItem() || this.peekLast() == null) {
            super.add(added);
        } else if (((Comparable)((Object)((Number)this.peekLast()))).compareTo(added) < 0) {
            this.removeLast();
            super.add(added);
        }
        while (this.size() > this.limit) {
            super.remove();
        }
        this.toString = super.toString();
        return true;
    }

    public E getMaxValueInRange(int range) {
        Number result = null;
        Iterator iterator = this.descendingIterator();
        for (range = Math.min(range, this.limit); iterator.hasNext() && range > 0; --range) {
            Number next = (Number)iterator.next();
            if (result != null && ((Comparable)((Object)next)).compareTo(result) <= 0) continue;
            result = next;
        }
        return (E)result;
    }

    public boolean isLimitSurpassedAllItems(int range, long limit) {
        boolean result = true;
        range = Math.min(range, this.limit);
        Iterator iter = this.descendingIterator();
        while (iter.hasNext() && range > 0) {
            --range;
            Number next = (Number)iter.next();
            if (next.longValue() > limit) continue;
            result &= false;
        }
        return result;
    }

    public ArrayDeque<E> subQueue(int range) {
        ArrayDeque result = new ArrayDeque(range);
        Iterator iter = this.descendingIterator();
        for (range = Math.min(range, this.limit); iter.hasNext() && range > 0; --range) {
            result.add(iter.next());
        }
        return result;
    }

    protected boolean isNextItem() {
        LocalDate now = LocalDate.now();
        if (now.getYear() != this.lastDailyStatsReset.getYear() || now.getDayOfYear() != this.lastDailyStatsReset.getDayOfYear()) {
            this.lastDailyStatsReset = LocalDate.now();
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.toString;
    }
}

