/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver;

import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.ConfigurationException;
import tigase.net.ConnectionType;
import tigase.net.SocketType;
import tigase.server.ConnectionManager;
import tigase.server.Packet;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.ConnectionHandlerIfc;
import tigase.server.xmppserver.ServerConnections;
import tigase.stats.StatisticsList;
import tigase.util.Algorithms;
import tigase.util.DNSEntry;
import tigase.util.DNSResolverFactory;
import tigase.util.TimerTask;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPIOService;

@Deprecated
public class ServerConnectionManager
extends ConnectionManager<XMPPIOService<Object>>
implements ConnectionHandlerIfc<XMPPIOService<Object>> {
    private static final String DB_RESULT_EL_NAME = "db:result";
    private static final String DB_VERIFY_EL_NAME = "db:verify";
    public static final String MAX_PACKET_WAITING_TIME_PROP_KEY = "max-packet-waiting-time";
    private static final String RESULT_EL_NAME = "result";
    private static final String VERIFY_EL_NAME = "verify";
    private static final String XMLNS_DB_ATT = "xmlns:db";
    private static final String XMLNS_DB_VAL = "jabber:server:dialback";
    private static final String XMLNS_SERVER_VAL = "jabber:server";
    private static final String XMLNS_CLIENT_VAL = "jabber:client";
    private static final Logger log = Logger.getLogger(ServerConnectionManager.class.getName());
    public static final long MAX_PACKET_WAITING_TIME_PROP_VAL = 420000L;
    private static Map<String, TimerTask> waitingTaskFutures = new LinkedHashMap<String, TimerTask>();
    private long new_connection_thread_counter = 0L;
    private long maxPacketWaitingTime = 420000L;
    private ConcurrentHashMap<String, XMPPIOService<Object>> incoming = new ConcurrentHashMap(1000);
    private Map<CID, ServerConnections> connectionsByLocalRemote = new ConcurrentHashMap<CID, ServerConnections>(1000);

    @Override
    public boolean addOutPacket(Packet packet) {
        return super.addOutPacket(packet);
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        props.put(MAX_PACKET_WAITING_TIME_PROP_KEY, 420000L);
        return props;
    }

    @Override
    public String getDiscoCategoryType() {
        return "s2s";
    }

    @Override
    public String getDiscoDescription() {
        return "Server connection manager";
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        int waiting_packets = 0;
        int open_s2s_connections = this.incoming.size();
        int connected_servers = 0;
        int server_connections_instances = this.connectionsByLocalRemote.size();
        for (Map.Entry<CID, ServerConnections> entry : this.connectionsByLocalRemote.entrySet()) {
            ServerConnections conn = entry.getValue();
            waiting_packets += conn.getWaitingPackets().size();
            if (!conn.isOutgoingConnected()) continue;
            ++open_s2s_connections;
            ++connected_servers;
        }
        list.add(this.getName(), "Open s2s connections", open_s2s_connections, Level.FINE);
        list.add(this.getName(), "Packets queued", waiting_packets, Level.FINE);
        list.add(this.getName(), "Connected servers", connected_servers, Level.FINE);
        list.add(this.getName(), "Connection instances", server_connections_instances, Level.FINER);
    }

    @Override
    public boolean handlesNonLocalDomains() {
        return true;
    }

    @Override
    public int hashCodeForPacket(Packet packet) {
        if (packet.getStanzaTo() != null) {
            return packet.getStanzaTo().getDomain().hashCode();
        }
        return 1;
    }

    public boolean isIncomingValid(String session_id) {
        if (session_id == null) {
            return false;
        }
        XMPPIOService<Object> serv = this.incoming.get(session_id);
        if (serv == null || serv.getSessionData().get("valid") == null) {
            return false;
        }
        return (Boolean)serv.getSessionData().get("valid");
    }

    public synchronized void processDialback(Packet packet, XMPPIOService<Object> serv) {
        Element elem;
        CID serv_cid;
        String local_hostname;
        if (log.isLoggable(Level.FINEST)) {
            log.finest(serv + ", DIALBACK - " + packet);
        }
        if (!this.isLocalDomainOrComponent(local_hostname = packet.getStanzaTo().getDomain())) {
            this.generateStreamError("host-unknown", serv);
            return;
        }
        String remote_hostname = packet.getStanzaFrom().getDomain();
        if (this.isLocalDomainOrComponent(remote_hostname)) {
            this.generateStreamError("host-unknown", serv);
            return;
        }
        CID cid = this.getConnectionId(local_hostname, remote_hostname);
        ServerConnections serv_conns = this.getServerConnections(cid);
        String session_id = (String)serv.getSessionData().get("sessionID");
        String serv_local_hostname = (String)serv.getSessionData().get("local-hostname");
        String serv_remote_hostname = (String)serv.getSessionData().get("remote-hostname");
        CID cID = serv_cid = serv_remote_hostname == null ? null : this.getConnectionId(serv_local_hostname, serv_remote_hostname);
        if (serv_cid != null && !cid.equals(serv_cid)) {
            log.info(serv + ", Somebody tries to reuse connection? old_cid: " + serv_cid + ", new_cid: " + cid);
        }
        if (packet.getElemName() == RESULT_EL_NAME || packet.getElemName() == DB_RESULT_EL_NAME) {
            if (packet.getType() == null) {
                if (packet.getElemCData() != null) {
                    String db_key = packet.getElemCData();
                    elem = new Element(DB_VERIFY_EL_NAME, db_key, new String[]{"id", "to", "from", XMLNS_DB_ATT}, new String[]{session_id, remote_hostname, local_hostname, XMLNS_DB_VAL});
                    Packet result = Packet.packetInstance(elem, null, null);
                    if (serv_conns == null) {
                        serv_conns = this.createNewServerConnections(cid, null);
                    }
                    serv.getSessionData().put("remote-hostname", remote_hostname);
                    serv.getSessionData().put("local-hostname", local_hostname);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest(serv + ", cid: " + cid + ", sessionId: " + session_id + ", Counters: ioservices: " + this.countIOServices() + ", s2s connections: " + this.countOpenConnections() + (Packet.FULL_DEBUG ? ", all connections: " + this.connectionsByLocalRemote : ""));
                    }
                    if (!serv_conns.sendControlPacket(result) && serv_conns.needsConnection()) {
                        this.createServerConnection(cid, result, serv_conns);
                    }
                } else {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer(serv + ", Incorrect diablack packet: " + packet);
                    }
                    this.bouncePacketsBack(Authorization.SERVICE_UNAVAILABLE, cid);
                    this.generateStreamError("bad-format", serv);
                }
            } else {
                switch (packet.getType()) {
                    case valid: {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer(serv + ", Connection: " + cid + " is valid, adding to available services.");
                        }
                        serv_conns.handleDialbackSuccess();
                        break;
                    }
                    default: {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer(serv + ", Connection: " + cid + " is invalid!! Stopping...");
                        }
                        serv_conns.handleDialbackFailure();
                    }
                }
            }
        }
        if (packet.getElemName() == VERIFY_EL_NAME || packet.getElemName() == DB_VERIFY_EL_NAME) {
            if (packet.getStanzaId() != null) {
                String forkey_session_id = packet.getStanzaId();
                if (packet.getType() == null) {
                    if (packet.getElemCData() != null) {
                        String db_key = packet.getElemCData();
                        String local_key = this.getLocalDBKey(cid, db_key, forkey_session_id, session_id);
                        if (local_key == null) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine(serv + ", db key is not available for session ID: " + forkey_session_id + ", key for validation: " + db_key);
                            }
                        } else {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine(serv + ", Local key for cid=" + cid + " is " + local_key);
                            }
                            this.sendVerifyResult(local_hostname, remote_hostname, forkey_session_id, db_key.equals(local_key), serv_conns, session_id);
                        }
                    }
                } else {
                    elem = new Element(DB_RESULT_EL_NAME, new String[]{"type", "to", "from", XMLNS_DB_ATT}, new String[]{packet.getType().toString(), remote_hostname, local_hostname, XMLNS_DB_VAL});
                    this.sendToIncoming(forkey_session_id, Packet.packetInstance(elem, null, null));
                    this.validateIncoming(forkey_session_id, packet.getType() == StanzaType.valid);
                }
            } else {
                if (log.isLoggable(Level.FINER)) {
                    log.finer(serv + ", Incorrect diablack packet: " + packet);
                }
                this.bouncePacketsBack(Authorization.SERVICE_UNAVAILABLE, cid);
                this.generateStreamError("bad-format", serv);
            }
        }
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing packet: " + packet.toString());
        }
        if (!packet.isCommand() || !this.processCommand(packet)) {
            if (packet.getStanzaTo() == null) {
                log.warning("Missing 'to' attribute, ignoring packet..." + packet + "\n This most likely happens due to missconfiguration of components domain names.");
                return;
            }
            if (packet.getStanzaFrom() == null) {
                log.warning("Missing 'from' attribute, ignoring packet..." + packet);
                return;
            }
            String to_hostname = packet.getStanzaTo().getDomain();
            if (this.isLocalDomainOrComponent(to_hostname)) {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Packet addresses to localhost, I am not processing it: " + packet);
                }
                try {
                    this.addOutPacket(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, "S2S - not delivered. Server missconfiguration.", true));
                }
                catch (PacketErrorTypeException e) {
                    log.warning("Packet processing exception: " + e);
                }
                return;
            }
            String from_hostname = packet.getStanzaFrom().getDomain();
            if (to_hostname == from_hostname) {
                log.warning("Dropping incorrect packet - from_hostname == to_hostname: " + packet);
                return;
            }
            CID cid = this.getConnectionId(packet);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Connection ID is: " + cid);
            }
            ServerConnections serv_conn = this.getServerConnections(cid);
            Packet server_packet = packet.copyElementOnly();
            server_packet.getElement().removeAttribute("xmlns");
            if (serv_conn == null || !serv_conn.sendPacket(server_packet) && serv_conn.needsConnection()) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Couldn't send packet, creating a new connection: " + cid);
                }
                this.createServerConnection(cid, server_packet, serv_conn);
            } else if (log.isLoggable(Level.FINEST)) {
                log.finest("Packet seems to be sent correctly: " + server_packet);
            }
        }
    }

    @Override
    public Queue<Packet> processSocketData(XMPPIOService<Object> serv) {
        Queue<Packet> packets = serv.getReceivedPackets();
        Packet p = null;
        while ((p = packets.poll()) != null) {
            if (p.getXMLNS() == XMLNS_SERVER_VAL) {
                p.getElement().setXMLNS(XMLNS_CLIENT_VAL);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest(serv + ", Processing socket data: " + p);
            }
            if (p.getXMLNS() == XMLNS_DB_VAL) {
                this.processDialback(p, serv);
                continue;
            }
            if (p.getElemName() == "error") {
                this.processStreamError(p, serv);
                return null;
            }
            if (this.checkPacket(p, serv)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(serv + ", Adding packet out: " + p);
                }
                this.addOutPacket(p);
                continue;
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean processUndeliveredPacket(Packet packet, Long stamp, String errorMessage) {
        this.addPacket(packet);
        return true;
    }

    @Override
    public void reconnectionFailed(Map<String, Object> port_props) {
    }

    public boolean sendToIncoming(String session_id, Packet packet) {
        XMPPIOService<Object> serv = this.incoming.get(session_id);
        if (serv != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(serv + ", Sending to incoming connection: " + session_id + " packet: " + packet);
            }
            return this.writePacketToSocket(serv, packet);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Trying to send packet: " + packet + " to nonexisten connection with sessionId: " + session_id);
        }
        return false;
    }

    @Override
    public void serviceStarted(XMPPIOService<Object> serv) {
        super.serviceStarted(serv);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("s2s connection opened: " + serv);
        }
        switch (serv.connectionType()) {
            case connect: {
                String data = "<stream:stream xmlns:stream='http://etherx.jabber.org/streams' xmlns='jabber:server' xmlns:db='jabber:server:dialback'>";
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(serv + ", sending: " + data);
                }
                serv.xmppStreamOpen(data);
                break;
            }
        }
    }

    @Override
    public boolean serviceStopped(XMPPIOService<Object> serv) {
        boolean result = super.serviceStopped(serv);
        if (result) {
            switch (serv.connectionType()) {
                case connect: {
                    String local_hostname = (String)serv.getSessionData().get("local-hostname");
                    String remote_hostname = (String)serv.getSessionData().get("remote-hostname");
                    if (remote_hostname == null) {
                        log.info(serv + ", remote-hostname is NULL, local-hostname: " + local_hostname + ", local address: " + serv.getLocalAddress() + ", remote address: " + serv.getRemoteAddress());
                        break;
                    }
                    CID cid = this.getConnectionId(local_hostname, remote_hostname);
                    ServerConnections serv_conns = this.getServerConnections(cid);
                    if (serv_conns == null) {
                        log.warning("There is no ServerConnections for stopped service: " + serv + ", cid: " + cid);
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest(serv + ", Counters: ioservices: " + this.countIOServices() + ", s2s active conns: " + this.countOpenConnections() + (Packet.FULL_DEBUG ? ", all connections: " + this.connectionsByLocalRemote : ""));
                        }
                        return result;
                    }
                    serv_conns.serviceStopped(serv);
                    Queue<Packet> waiting = serv_conns.getWaitingPackets();
                    if (waiting.size() <= 0) break;
                    if (serv_conns.waitingTime() > this.maxPacketWaitingTime) {
                        this.bouncePacketsBack(Authorization.REMOTE_SERVER_TIMEOUT, cid);
                        break;
                    }
                    this.createServerConnection(cid, null, serv_conns);
                    break;
                }
                case accept: {
                    String session_id = (String)serv.getSessionData().get("sessionID");
                    if (session_id != null) {
                        XMPPIOService<Object> rem = this.incoming.remove(session_id);
                        if (rem == null) {
                            if (!log.isLoggable(Level.FINE)) break;
                            log.fine(serv + ", No service with given SESSION_ID: " + session_id);
                            break;
                        }
                        if (!log.isLoggable(Level.FINER)) break;
                        log.finer(serv + ", Connection removed: " + session_id);
                        break;
                    }
                    if (!log.isLoggable(Level.FINE)) break;
                    log.fine(serv + ", session_id is null, didn't remove the connection");
                    break;
                }
                default: {
                    log.severe(serv + ", Warning, program shouldn't reach that point.");
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest(serv + ", Counters: ioservices: " + this.countIOServices() + ", s2s active conns: " + this.countOpenConnections() + (Packet.FULL_DEBUG ? ", all connections: " + this.connectionsByLocalRemote : ""));
            }
        }
        return result;
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        this.maxPacketWaitingTime = (Long)props.get(MAX_PACKET_WAITING_TIME_PROP_KEY);
    }

    @Override
    public void tlsHandshakeCompleted(XMPPIOService<Object> service) {
    }

    public void validateIncoming(String session_id, boolean valid) {
        XMPPIOService<Object> serv = this.incoming.get(session_id);
        if (serv != null) {
            serv.getSessionData().put("valid", valid);
            if (!valid) {
                serv.stop();
            }
        }
    }

    @Override
    public void xmppStreamClosed(XMPPIOService<Object> serv) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(serv + ", Stream closed: " + this.getConnectionId(serv));
        }
    }

    @Override
    public String xmppStreamOpened(XMPPIOService<Object> serv, Map<String, String> attribs) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(serv + ", Stream opened: " + attribs.toString());
        }
        serv.getSessionData().put("xmlns", XMLNS_SERVER_VAL);
        switch (serv.connectionType()) {
            case connect: {
                ServerConnections serv_conns;
                String remote_hostname = (String)serv.getSessionData().get("remote-hostname");
                String local_hostname = (String)serv.getSessionData().get("local-hostname");
                CID cid = this.getConnectionId(local_hostname, remote_hostname);
                String remote_id = attribs.get("id");
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(serv + ", Connect Stream opened for: " + cid + ", session id" + remote_id);
                }
                if ((serv_conns = this.getServerConnections(cid)) == null) {
                    serv_conns = this.createNewServerConnections(cid, null);
                }
                serv_conns.addOutgoing(serv);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(serv + ", Counters: ioservices: " + this.countIOServices() + ", s2s active conns: " + this.countOpenConnections() + (Packet.FULL_DEBUG ? ", all connections: " + this.connectionsByLocalRemote : ""));
                }
                serv.getSessionData().put("sessionID", remote_id);
                String uuid = UUID.randomUUID().toString();
                String key = null;
                try {
                    key = Algorithms.hexDigest(remote_id, uuid, "SHA");
                }
                catch (NoSuchAlgorithmException e) {
                    key = uuid;
                }
                serv_conns.putDBKey(remote_id, key);
                Element elem = new Element(DB_RESULT_EL_NAME, key, new String[]{"from", "to", XMLNS_DB_ATT}, new String[]{local_hostname, remote_hostname, XMLNS_DB_VAL});
                serv_conns.addControlPacket(Packet.packetInstance(elem, null, null));
                serv_conns.sendAllControlPackets();
                return null;
            }
            case accept: {
                String remote_hostname = (String)serv.getSessionData().get("remote-hostname");
                String local_hostname = (String)serv.getSessionData().get("local-hostname");
                CID cid = this.getConnectionId(local_hostname, remote_hostname);
                String id = UUID.randomUUID().toString();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(serv + ", Accept Stream opened for: " + cid + ", session id: " + id);
                }
                if (remote_hostname != null && log.isLoggable(Level.FINE)) {
                    log.fine(serv + ", Opening stream for already established connection...., trying to turn on TLS????");
                }
                serv.getSessionData().put("sessionID", id);
                this.incoming.put(id, serv);
                return "<stream:stream xmlns:stream='http://etherx.jabber.org/streams' xmlns='jabber:server' xmlns:db='jabber:server:dialback' id='" + id + "'>";
            }
        }
        log.severe(serv + ", Warning, program shouldn't reach that point.");
        return null;
    }

    @Override
    protected int[] getDefPlainPorts() {
        return new int[]{5269};
    }

    protected String getLocalDBKey(CID cid, String key, String forkey_sessionId, String asking_sessionId) {
        ServerConnections serv_conns = this.getServerConnections(cid);
        return serv_conns == null ? null : serv_conns.getDBKey(forkey_sessionId);
    }

    @Override
    protected long getMaxInactiveTime() {
        return 900000L;
    }

    protected ServerConnections getServerConnections(CID cid) {
        return this.connectionsByLocalRemote.get(cid);
    }

    @Override
    protected XMPPIOService<Object> getXMPPIOServiceInstance() {
        return new XMPPIOService<Object>();
    }

    @Override
    protected boolean isHighThroughput() {
        return true;
    }

    protected ServerConnections removeServerConnections(CID cid) {
        return this.connectionsByLocalRemote.remove(cid);
    }

    protected void sendVerifyResult(String from, String to, String forkey_sessionId, boolean valid, ServerConnections serv_conns, String asking_sessionId) {
        String type = valid ? "valid" : "invalid";
        Element result_el = new Element(DB_VERIFY_EL_NAME, new String[]{"from", "to", "id", "type", XMLNS_DB_ATT}, new String[]{from, to, forkey_sessionId, type, XMLNS_DB_VAL});
        Packet result = Packet.packetInstance(result_el, null, null);
        if (!this.sendToIncoming(asking_sessionId, result)) {
            log.warning("Can not send verification packet back: " + result.toString());
        }
    }

    private void bouncePacketsBack(Authorization author, CID cid) {
        ServerConnections serv_conns = this.getServerConnections(cid);
        if (serv_conns != null) {
            Queue<Packet> waiting = serv_conns.getWaitingPackets();
            Packet p = null;
            while ((p = waiting.poll()) != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sending packet back: " + p);
                }
                try {
                    this.addOutPacket(author.getResponseMessage(p, "S2S - not delivered", true));
                }
                catch (PacketErrorTypeException e) {
                    log.info("Packet processing exception: " + e);
                }
            }
        } else {
            log.info("No ServerConnections for cid: " + cid);
        }
    }

    private boolean checkPacket(Packet packet, XMPPIOService<Object> serv) {
        JID packet_from = packet.getStanzaFrom();
        JID packet_to = packet.getStanzaTo();
        if (packet_from == null || packet_to == null) {
            this.generateStreamError("improper-addressing", serv);
            return false;
        }
        String remote_hostname = (String)serv.getSessionData().get("remote-hostname");
        if (!packet_from.getDomain().equals(remote_hostname)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer(serv + ", Invalid hostname from the remote server, expected: " + remote_hostname);
            }
            this.generateStreamError("invalid-from", serv);
            return false;
        }
        String local_hostname = (String)serv.getSessionData().get("local-hostname");
        if (!packet_to.getDomain().equals(local_hostname)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer(serv + ", Invalid hostname of the local server, expected: " + local_hostname);
            }
            this.generateStreamError("host-unknown", serv);
            return false;
        }
        String session_id = (String)serv.getSessionData().get("sessionID");
        if (!this.isIncomingValid(session_id)) {
            log.info(serv + ", Incoming connection hasn't been validated");
            return false;
        }
        return true;
    }

    private int countOpenConnections() {
        int open_s2s_connections = 0;
        for (Map.Entry<CID, ServerConnections> entry : this.connectionsByLocalRemote.entrySet()) {
            ServerConnections conn = entry.getValue();
            if (!conn.isOutgoingConnected()) continue;
            ++open_s2s_connections;
        }
        return open_s2s_connections;
    }

    private ServerConnections createNewServerConnections(CID cid, Packet packet) {
        ServerConnections conns = new ServerConnections(this, cid);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Creating a new ServerConnections instance: {0}", conns);
        }
        if (packet != null) {
            if (packet.getElement().getXMLNS() == XMLNS_DB_VAL) {
                conns.addControlPacket(packet);
            } else {
                conns.addDataPacket(packet);
            }
        }
        this.connectionsByLocalRemote.put(cid, conns);
        return conns;
    }

    private void createServerConnection(final CID cid, final Packet packet, ServerConnections serv_conn) {
        final ServerConnections sconn = serv_conn == null ? this.createNewServerConnections(cid, packet) : serv_conn;
        sconn.setConnecting();
        new ConnectionWatchdogTask(sconn, cid.getLocalHost(), cid.getRemoteHost());
        Thread new_connection_thread = new Thread("NewServerConnection-" + ++this.new_connection_thread_counter){

            @Override
            public void run() {
                ServerConnectionManager.this.createServerConnectionInThread(cid, packet, sconn);
            }
        };
        new_connection_thread.start();
    }

    private void createServerConnectionInThread(CID cid, Packet packet, ServerConnections serv_conn) {
        String remotehost;
        ServerConnections conns = serv_conn;
        String localhost = cid.getLocalHost();
        if (this.openNewServerConnection(localhost, remotehost = cid.getRemoteHost())) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Connecting a new s2s service: " + conns);
            }
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Couldn't open a new s2s service: (UknownHost??) " + conns);
            }
            Queue<Packet> waitingPackets = conns.getWaitingPackets();
            Packet p = null;
            while ((p = waitingPackets.poll()) != null) {
                if (p.getElement().getXMLNS() == XMLNS_DB_VAL) continue;
                try {
                    this.addOutPacket(Authorization.REMOTE_SERVER_NOT_FOUND.getResponseMessage(p, "S2S - destination host not found", true));
                }
                catch (PacketErrorTypeException e) {
                    log.warning("Packet: " + p.toString() + " processing exception: " + e);
                }
            }
            conns.stopAll();
        }
    }

    private void generateStreamError(String error_el, XMPPIOService<Object> serv) {
        Element error = new Element("stream:error", new Element[]{new Element(error_el, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-streams"})}, null, null);
        try {
            this.writeRawData(serv, error.toString());
            serv.stop();
        }
        catch (Exception e) {
            serv.forceStop();
        }
    }

    private CID getConnectionId(String localhost, String remotehost) {
        return new CID(localhost, remotehost);
    }

    private CID getConnectionId(Packet packet) {
        return new CID(packet.getStanzaFrom().getDomain(), packet.getStanzaTo().getDomain());
    }

    private CID getConnectionId(XMPPIOService<Object> service) {
        String local_hostname = (String)service.getSessionData().get("local-hostname");
        String remote_hostname = (String)service.getSessionData().get("remote-hostname");
        CID cid = this.getConnectionId(local_hostname, remote_hostname);
        return cid;
    }

    private boolean openNewServerConnection(String localhost, String remotehost) {
        try {
            DNSEntry dns_entry = DNSResolverFactory.getInstance().getHostSRV_Entry(remotehost);
            TreeMap<String, Object> port_props = new TreeMap<String, Object>();
            port_props.put("remote-ip", dns_entry.getIp());
            port_props.put("local-hostname", localhost);
            port_props.put("remote-hostname", remotehost);
            port_props.put("ifc", new String[]{dns_entry.getIp()});
            port_props.put("socket", (Object)SocketType.plain);
            port_props.put("type", (Object)ConnectionType.connect);
            port_props.put("port-no", dns_entry.getPort());
            CID cid = this.getConnectionId(localhost, remotehost);
            port_props.put("cid", cid);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("STARTING new connection: " + cid);
            }
            this.addWaitingTask(port_props);
            return true;
        }
        catch (UnknownHostException e) {
            log.info("UnknownHostException for host: " + remotehost);
            return false;
        }
    }

    private boolean processCommand(Packet packet) {
        switch (packet.getCommand()) {
            case STARTTLS: {
                break;
            }
            case STREAM_CLOSED: {
                break;
            }
            case GETDISCO: {
                break;
            }
            case CLOSE: {
                break;
            }
        }
        return false;
    }

    private void processStreamError(Packet packet, XMPPIOService<Object> serv) {
        Authorization author = Authorization.RECIPIENT_UNAVAILABLE;
        if (packet.getElement().getChild("host-unknown") != null) {
            author = Authorization.REMOTE_SERVER_NOT_FOUND;
        }
        CID cid = this.getConnectionId(serv);
        this.bouncePacketsBack(author, cid);
        serv.stop();
    }

    private class ConnectionWatchdogTask
    extends TimerTask {
        private ServerConnections conns = null;
        private String localhost = null;
        private String remotehost = null;

        private ConnectionWatchdogTask(ServerConnections conns, String localhost, String remotehost) {
            this.conns = conns;
            this.localhost = localhost;
            this.remotehost = remotehost;
            String key = localhost + remotehost;
            TimerTask task = (TimerTask)waitingTaskFutures.get(key);
            if (task != null) {
                task.cancel();
            }
            ServerConnectionManager.this.addTimerTask(this, 15L, TimeUnit.SECONDS);
            waitingTaskFutures.put(key, task);
        }

        @Override
        public void run() {
            String key = this.localhost + this.remotehost;
            waitingTaskFutures.remove(key);
            if (this.conns.getOutgoingState() != ServerConnections.OutgoingState.OK) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Connecting timeout expired, still connecting: " + this.conns);
                }
                this.conns.stopAll();
                Queue<Packet> waiting = this.conns.getWaitingPackets();
                if (waiting.size() > 0) {
                    if (this.conns.waitingTime() > ServerConnectionManager.this.maxPacketWaitingTime) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("Max packets waiting time expired, sending all back: " + this.conns);
                        }
                        ServerConnectionManager.this.bouncePacketsBack(Authorization.REMOTE_SERVER_TIMEOUT, this.conns.getCID());
                    } else {
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("Reconnecting: " + this.conns);
                        }
                        ServerConnectionManager.this.createServerConnection(this.conns.getCID(), null, this.conns);
                    }
                } else if (log.isLoggable(Level.FINEST)) {
                    log.finest("No packets waiting in queue, giving up: " + this.conns);
                }
            } else if (log.isLoggable(Level.FINEST)) {
                log.finest("Connecting timeout expired: " + this.conns);
            }
        }
    }
}

