/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.xmppserver.OutgoingState;
import tigase.server.xmppserver.S2SConnectionHandlerIfc;
import tigase.server.xmppserver.S2SIOService;

public class S2SConnection
implements Comparable<S2SConnection> {
    private static final Logger log = Logger.getLogger(S2SConnection.class.getName());
    private S2SConnectionHandlerIfc<S2SIOService> handler = null;
    private String ipAddress = null;
    private S2SIOService service = null;
    private OutgoingState conn_state = OutgoingState.NULL;
    private ConcurrentLinkedQueue<Packet> waitingControlPackets = new ConcurrentLinkedQueue();

    public S2SConnection(S2SConnectionHandlerIfc<S2SIOService> handler, String ip) {
        this.handler = handler;
        this.ipAddress = ip;
    }

    public void addControlPacket(Packet packet) {
        this.waitingControlPackets.add(packet);
    }

    @Override
    public int compareTo(S2SConnection o) {
        return this.hashCode() - o.hashCode();
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public S2SIOService getS2SIOService() {
        return this.service;
    }

    public int getWaitingControlCount() {
        return this.waitingControlPackets.size();
    }

    public boolean isConnected() {
        return this.service != null && this.service.isConnected();
    }

    public void sendAllControlPackets() {
        if (log.isLoggable(Level.FINEST)) {
            for (Packet packet : this.waitingControlPackets) {
                log.log(Level.FINEST, "Sending on connection: {0} control packet: {1}", new Object[]{this.service, packet});
            }
        }
        this.handler.writePacketsToSocket(this.service, this.waitingControlPackets);
    }

    public boolean sendPacket(Packet packet) throws IOException {
        return this.handler.writePacketToSocket(this.service, packet);
    }

    public void setS2SIOService(S2SIOService serv) {
        this.service = serv;
    }

    public String toString() {
        return "S2S: " + this.service;
    }
}

