/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver.sysmon;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.sreceiver.sysmon.AbstractMonitor;
import tigase.server.sreceiver.sysmon.SystemMonitorTask;
import tigase.stats.StatisticsList;
import tigase.sys.TigaseRuntime;
import tigase.xmpp.JID;

public class CPUMonitor
extends AbstractMonitor {
    private static final Logger log = Logger.getLogger(CPUMonitor.class.getName());
    private int historySize = 100;
    private long prevUptime = TigaseRuntime.getTigaseRuntime().getUptime();
    private long prevCputime = TigaseRuntime.getTigaseRuntime().getProcessCPUTime();
    private float[] cpuUsage = new float[this.historySize];
    private int cpuUsageIdx = 0;
    private double[] loadAverage = new double[this.historySize];
    private int loadAverageIdx = 0;
    private ThreadMXBean thBean = null;
    private OperatingSystemMXBean osBean = null;
    private NumberFormat format = NumberFormat.getNumberInstance();
    private Map<Long, ThreadData> threads = new ConcurrentHashMap<Long, ThreadData>();
    private int deadLockedThreadsNo = 0;
    private static final String CPU_MON = "cpu-mon";

    private String checkForDeadLock() {
        long[] tids = this.thBean.findDeadlockedThreads();
        if (tids != null && tids.length > 0) {
            this.deadLockedThreadsNo = tids.length;
            StringBuilder sb = new StringBuilder();
            sb.append("Locked threads " + tids.length + ":\n");
            LinkedHashSet<Long> tidSet = new LinkedHashSet<Long>();
            for (long tid : tids) {
                tidSet.add(tid);
            }
            ThreadGroup rootGroup = Thread.currentThread().getThreadGroup();
            while (rootGroup.getParent() != null) {
                rootGroup = rootGroup.getParent();
            }
            int allThreadsCount = this.thBean.getThreadCount();
            Thread[] allThreads = new Thread[allThreadsCount];
            rootGroup.enumerate(allThreads, true);
            for (Thread thread : allThreads) {
                StackTraceElement[] ste;
                if (!tidSet.contains(thread.getId())) continue;
                ThreadInfo threadInfo = this.thBean.getThreadInfo(thread.getId());
                sb.append("Locked thread [" + thread.getId() + "] " + threadInfo.getThreadName() + " on " + threadInfo.getLockInfo().toString() + ", locked synchronizers: " + Arrays.toString(threadInfo.getLockedSynchronizers()) + ", locked monitors: " + Arrays.toString(threadInfo.getLockedMonitors()) + " by [" + threadInfo.getLockOwnerId() + "] " + threadInfo.getLockOwnerName()).append('\n');
                for (StackTraceElement stackTraceElement : ste = thread.getStackTrace()) {
                    sb.append("  " + stackTraceElement.toString()).append('\n');
                }
            }
            return sb.toString();
        }
        return null;
    }

    private String getStackTrace(Map<Thread, StackTraceElement[]> map, long id) {
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            if (entry.getKey().getId() != id) continue;
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement stelem : entry.getValue()) {
                sb.append(stelem.toString() + "\n");
            }
            return sb.toString();
        }
        return null;
    }

    private String getThreadInfo(long thid, boolean stack) {
        ThreadInfo ti = this.thBean.getThreadInfo(thid);
        if (ti != null) {
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            StringBuilder sb = new StringBuilder("Thread: " + ti.getThreadName() + ", ID: " + ti.getThreadId());
            ThreadData td = this.threads.get(thid);
            if (td != null) {
                sb.append(", CPU usage: " + this.format.format(td.cpuUse) + "%\n");
            }
            if (stack) {
                sb.append(ti.toString());
                sb.append(this.getStackTrace(map, thid));
            }
            return sb.toString();
        }
        return "ThreadInfo is null...";
    }

    @Override
    public String runCommand(String[] com) {
        command comm = command.valueOf(com[0].substring(2));
        switch (comm) {
            case mth: 
            case maxthread: {
                if (com.length > 1) {
                    try {
                        long thid = Long.parseLong(com[1]);
                        return this.getThreadInfo(thid, true);
                    }
                    catch (Exception e) {
                        return "Incorrect Thread ID";
                    }
                }
                List<ThreadData> sorted = this.sortThreadCPUUse();
                if (sorted.size() > 0) {
                    return this.getThreadInfo(sorted.get((int)0).id, true);
                }
                return "No max threads info yet.";
            }
            case allthreads: {
                boolean extend = false;
                if (com.length > 1 && com[1].equals("ex")) {
                    extend = true;
                }
                StringBuilder sb = new StringBuilder("All threads information:\n");
                for (long thid : this.thBean.getAllThreadIds()) {
                    sb.append(this.getThreadInfo(thid, extend));
                }
                return sb.toString();
            }
        }
        return null;
    }

    private List<ThreadData> sortThreadCPUUse() {
        ArrayList<ThreadData> list = new ArrayList<ThreadData>(this.threads.values());
        Collections.sort(list, new Comparator<ThreadData>(){

            @Override
            public int compare(ThreadData o1, ThreadData o2) {
                if (o1.cpuUse < o2.cpuUse) {
                    return 1;
                }
                if (o1.cpuUse > o2.cpuUse) {
                    return -1;
                }
                return 0;
            }
        });
        return list;
    }

    @Override
    public String commandsHelp() {
        StringBuilder sb = new StringBuilder();
        for (command comm : command.values()) {
            sb.append("//" + comm.name() + comm.getHelp() + "\n");
        }
        return sb.toString();
    }

    @Override
    public boolean isMonitorCommand(String com) {
        if (com != null) {
            for (command comm : command.values()) {
                if (!com.startsWith("//" + comm.toString())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void init(JID jid, float treshold, SystemMonitorTask smTask) {
        super.init(jid, treshold, smTask);
        this.thBean = ManagementFactory.getThreadMXBean();
        this.osBean = ManagementFactory.getOperatingSystemMXBean();
        this.format.setMaximumFractionDigits(1);
        if (this.thBean.isCurrentThreadCpuTimeSupported()) {
            this.thBean.setThreadCpuTimeEnabled(true);
        } else {
            log.warning("Current thread CPU Time is NOT supported.");
        }
        if (this.thBean.isThreadContentionMonitoringSupported()) {
            this.thBean.setThreadContentionMonitoringEnabled(true);
        } else {
            log.warning("Thread contention monitoring is NOT supported.");
        }
    }

    @Override
    public void check10Secs(Queue<Packet> results) {
        long currUptime = TigaseRuntime.getTigaseRuntime().getUptime();
        long currCputime = TigaseRuntime.getTigaseRuntime().getProcessCPUTime();
        float cpuUse = this.calcCPUUse(this.prevUptime, currUptime, this.prevCputime, currCputime, TigaseRuntime.getTigaseRuntime().getCPUsNumber());
        this.prevUptime = currUptime;
        this.prevCputime = currCputime;
        this.cpuUsageIdx = this.setValueInArr(this.cpuUsage, this.cpuUsageIdx, cpuUse);
        this.loadAverageIdx = this.setValueInArr(this.loadAverage, this.loadAverageIdx, this.osBean.getSystemLoadAverage());
        float thresh = this.treshold * 100.0f;
        if (cpuUse > thresh && this.recentCpu(6) > (double)thresh) {
            this.prepareWarning("High CPU usage, current: " + this.format.format(cpuUse) + "%, last minute: " + this.format.format(this.recentCpu(6)) + "%", results, this);
        } else if ((double)cpuUse < (double)thresh * 0.75) {
            this.prepareCalmDown("CPU usage is now low again, current: " + this.format.format(cpuUse) + "%, last minute: " + this.format.format(this.recentCpu(6)) + "%", results, this);
        }
        String result = this.checkForDeadLock();
        if (result != null) {
            System.out.println("Dead-locked threads:\n" + result);
            this.prepareWarning("Dead-locked threads:\n" + result, results, this);
        }
        this.updateThreadCPUUse();
    }

    private double recentCpu(int histCheck) {
        double recentCpu = 0.0;
        int start = this.cpuUsageIdx - histCheck;
        if (start < 0) {
            start = this.cpuUsage.length - start;
        }
        for (int i = 0; i < histCheck; ++i) {
            int idx = (start + i) % this.cpuUsage.length;
            recentCpu += (double)this.cpuUsage[idx];
        }
        return recentCpu / (double)histCheck;
    }

    @Override
    public String getState() {
        int idx = this.cpuUsageIdx - 1;
        if (idx < 0) {
            idx = this.cpuUsage.length - 1;
        }
        NumberFormat formd = NumberFormat.getNumberInstance();
        formd.setMaximumFractionDigits(4);
        return "Current CPU usage is: " + this.format.format(this.cpuUsage[idx]) + "%, Last minute CPU usage is: " + this.format.format(this.recentCpu(6)) + "%, Load average is: " + formd.format(this.loadAverage[idx]) + "\n";
    }

    @Override
    public void destroy() {
    }

    @Override
    public void getStatistics(StatisticsList list) {
        ThreadData td;
        super.getStatistics(list);
        list.add(CPU_MON, "Deadlocked threads no", this.deadLockedThreadsNo, Level.INFO);
        List<ThreadData> sorted = this.sortThreadCPUUse();
        if (sorted.size() > 0) {
            td = sorted.get(0);
            list.add(CPU_MON, "1st max CPU thread", td.name + ": " + this.format.format(td.cpuUse) + "%", Level.INFO);
        }
        if (sorted.size() > 1) {
            td = sorted.get(1);
            list.add(CPU_MON, "2nd max CPU thread", td.name + ": " + this.format.format(td.cpuUse) + "%", Level.FINE);
        }
        if (sorted.size() > 2) {
            td = sorted.get(2);
            list.add(CPU_MON, "3rd max CPU thread", td.name + ": " + this.format.format(td.cpuUse) + "%", Level.FINE);
        }
        if (sorted.size() > 3) {
            td = sorted.get(3);
            list.add(CPU_MON, "4th max CPU thread", td.name + ": " + this.format.format(td.cpuUse) + "%", Level.FINER);
        }
        if (sorted.size() > 4) {
            td = sorted.get(4);
            list.add(CPU_MON, "5th max CPU thread", td.name + ": " + this.format.format(td.cpuUse) + "%", Level.FINER);
        }
        if (sorted.size() > 5) {
            td = sorted.get(5);
            list.add(CPU_MON, "6th max CPU thread", td.name + ": " + this.format.format(td.cpuUse) + "%", Level.FINEST);
        }
    }

    public float calcCPUUse(long prevUptime, long currUptime, long prevCputime, long currCputime, int cpus) {
        long elapsedTime = currUptime - prevUptime;
        long elapsedCpu = currCputime - prevCputime;
        return Math.min(99.99f, (float)elapsedCpu / ((float)elapsedTime * 10000.0f * (float)cpus));
    }

    private void updateThreadCPUUse() {
        long[] allIds;
        long currUptime = TigaseRuntime.getTigaseRuntime().getUptime();
        for (long l : allIds = this.thBean.getAllThreadIds()) {
            ThreadData td = this.threads.get(l);
            if (td == null) {
                ThreadInfo ti = this.thBean.getThreadInfo(l);
                if (ti != null) {
                    td = new ThreadData();
                    td.id = l;
                    td.name = ti.getThreadName();
                    td.prevCputime = this.thBean.getThreadCpuTime(l);
                    td.prevUptime = currUptime;
                    this.threads.put(l, td);
                    continue;
                }
                log.finer("ThreadInfo null for thread: " + l);
                continue;
            }
            long currCputime = this.thBean.getThreadCpuTime(l);
            if (currCputime > 0L) {
                td.cpuUse = this.calcCPUUse(td.prevUptime, currUptime, td.prevCputime, currCputime, 1);
            }
            td.prevCputime = currCputime;
            td.prevUptime = currUptime;
        }
    }

    private class ThreadData {
        long id = 0L;
        String name = "";
        float cpuUse = 0.0f;
        long prevUptime = 0L;
        long prevCputime = 0L;

        private ThreadData() {
        }
    }

    private static enum command {
        maxthread(" - Returns information about the most active thread."),
        mth(" - Short version of the command above."),
        allthreads(" [ex] - display all threads information, with 'ex' parameters it prints extended information.");

        private String helpText = null;

        private command(String helpText) {
            this.helpText = helpText;
        }

        public String getHelp() {
            return this.helpText;
        }
    }
}

