/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.ConfiguratorAbstract;
import tigase.disteventbus.EventBus;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.monitor.InfoTask;
import tigase.monitor.MonitorComponent;
import tigase.monitor.tasks.AbstractConfigurableTimerTask;
import tigase.server.XMPPServer;
import tigase.server.xmppsession.SessionManager;
import tigase.util.DateTimeFormatter;
import tigase.xml.Element;

@Bean(name="connections-task")
public class ConnectionsTask
extends AbstractConfigurableTimerTask
implements InfoTask {
    protected static final DateTimeFormatter dtf = new DateTimeFormatter();
    protected static final Logger log = Logger.getLogger(ConnectionsTask.class.getName());
    private static final String USERS_DISCONNECTEED_EVENT_NAME = "UsersDisconnected";
    @Inject
    protected MonitorComponent component;
    @Inject
    protected EventBus eventBus;
    private int lastOnlineUsers;
    @ConfigField(desc="Minimal amount of disconnected users")
    private int thresholdMinimal = 10;
    @ConfigField(desc="Percent of disconnected users")
    private int threshold = 80;

    public static Element createAlarmEvent(int currentOnlineUsers, int lastOnlineUsers, int thresholdMinimal, int threshold) {
        int delta = currentOnlineUsers - lastOnlineUsers;
        float percent = (lastOnlineUsers == 0 ? 1.0f : (float)delta / (float)lastOnlineUsers) * 100.0f;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Data: lastOnlineUsers=" + lastOnlineUsers + "; currentOnlineUsers=" + currentOnlineUsers + "; delta=" + delta + "; percent=" + percent + "; thresholdMinimal=" + thresholdMinimal + "; threshold=" + threshold);
        }
        if (-1 * delta >= thresholdMinimal && -1.0f * percent >= (float)threshold) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Creating event!");
            }
            Element event = new Element(USERS_DISCONNECTEED_EVENT_NAME, new String[]{"xmlns"}, new String[]{"tigase:monitor:event"});
            event.addChild(new Element("timestamp", "" + dtf.formatDateTime(new Date())));
            event.addChild(new Element("disconnections", "" + -1 * delta));
            event.addChild(new Element("disconnectionsPercent", "" + -1.0f * percent));
            return event;
        }
        return null;
    }

    @Override
    public Form getCurrentConfiguration() {
        Form x = super.getCurrentConfiguration();
        x.addField(Field.fieldTextSingle("threshold", "" + this.threshold, "Percent of disconnected users"));
        x.addField(Field.fieldTextSingle("thresholdMinimal", "" + this.thresholdMinimal, "Minimal amount of disconnected users"));
        return x;
    }

    @Override
    public Form getTaskInfo() {
        Form x = new Form("", "Task Info", "");
        x.addField(Field.fieldTextSingle("lastUsersOnline", "" + this.lastOnlineUsers, "Last measured online users"));
        return x;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getThresholdMinimal() {
        return this.thresholdMinimal;
    }

    public void setThresholdMinimal(int thresholdMinimal) {
        this.thresholdMinimal = thresholdMinimal;
    }

    @Override
    protected void run() {
        ConfiguratorAbstract configurator;
        SessionManager sess;
        int currentOnlineUsers;
        Element event;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Running task...");
        }
        if ((event = ConnectionsTask.createAlarmEvent(currentOnlineUsers = (sess = (SessionManager)(configurator = XMPPServer.getConfigurator()).getComponent("sess-man")).getOpenUsersConnectionsAmount(), this.lastOnlineUsers, this.thresholdMinimal, this.threshold)) != null) {
            event.addChild(new Element("hostname", this.component.getDefHostName().toString()));
            this.eventBus.fire(event);
        }
        this.lastOnlineUsers = currentOnlineUsers;
    }

    @Override
    public void setNewConfiguration(Form form) {
        Field thresholdNetto;
        Field thresholdPercent = form.get("threshold");
        if (thresholdPercent != null) {
            this.threshold = Integer.parseInt(thresholdPercent.getValue());
        }
        if ((thresholdNetto = form.get("thresholdMinimal")) != null) {
            this.thresholdMinimal = Integer.parseInt(thresholdNetto.getValue());
        }
        super.setNewConfiguration(form);
    }
}

