/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptException;
import tigase.db.TigaseDBException;
import tigase.db.comp.ComponentRepository;
import tigase.db.comp.RepositoryChangeListenerIfc;
import tigase.form.Form;
import tigase.kernel.beans.Inject;
import tigase.kernel.core.Kernel;
import tigase.monitor.ConfigurableTask;
import tigase.monitor.MonitorTask;
import tigase.monitor.TaskConfigItem;
import tigase.monitor.tasks.ScriptTask;
import tigase.monitor.tasks.ScriptTimerTask;

public class TasksScriptRegistrar {
    public static final String ID = "TasksScriptRegistrar";
    @Inject
    private Kernel kernel;
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    @Inject
    private ComponentRepository<TaskConfigItem> repo;

    public void delete(String taskName) {
        try {
            this.repo.removeItem(taskName);
        }
        catch (TigaseDBException e) {
            e.printStackTrace();
        }
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public ComponentRepository<TaskConfigItem> getRepo() {
        return this.repo;
    }

    private void initTaskFromTaskConfig(TaskConfigItem item) throws ScriptException, TigaseDBException {
        TaskConfigItem.Type type;
        try {
            type = item.getType();
            if (type == null) {
                this.repo.removeItem(item.getKey());
                return;
            }
        }
        catch (Exception e) {
            this.repo.removeItem(item.getKey());
            return;
        }
        String taskName = item.getTaskName();
        String scriptExtension = item.getScriptExtension();
        String scriptContent = item.getTaskScript();
        switch (type) {
            case task: {
                if (this.kernel.isBeanClassRegistered(item.getTaskName())) {
                    MonitorTask task = (MonitorTask)this.kernel.getInstance(item.getTaskName());
                    if (!(task instanceof ConfigurableTask)) break;
                    ((ConfigurableTask)((Object)task)).setNewConfiguration(item.getConfiguration());
                    break;
                }
                this.repo.removeItem(item.getKey());
                break;
            }
            case scriptTask: {
                this.runScriptTask(taskName, scriptExtension, scriptContent, item.getConfiguration());
            }
            case scriptTimerTask: {
                this.runScriptTimerTask(taskName, scriptExtension, scriptContent, item.getConfiguration());
            }
        }
    }

    public void load() {
        try {
            for (TaskConfigItem item : this.repo.allItems()) {
                this.initTaskFromTaskConfig(item);
            }
        }
        catch (TigaseDBException e) {
            e.printStackTrace();
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void registerScript(String scriptName, String scriptExtension, String scriptContent) throws ScriptException {
        ScriptTask task = this.runScriptTask(scriptName, scriptExtension, scriptContent);
        this.saveScript(TaskConfigItem.Type.scriptTask, scriptName, scriptExtension, scriptContent, task.getCurrentConfiguration());
    }

    public void registerTimerScript(String scriptName, String scriptExtension, String scriptContent, Long delay) throws ScriptException {
        ScriptTimerTask task = this.runScriptTimerTask(scriptName, scriptExtension, scriptContent, delay);
        this.saveScript(TaskConfigItem.Type.scriptTimerTask, scriptName, scriptExtension, scriptContent, task.getCurrentConfiguration());
    }

    private ScriptTask runScriptTask(String scriptName, String scriptExtension, String scriptContent) throws ScriptException {
        this.kernel.registerBean(scriptName).asClass(ScriptTask.class).exec();
        ScriptTask scriptTask = (ScriptTask)this.kernel.getInstance(scriptName);
        scriptTask.setScript(scriptContent, scriptExtension);
        scriptTask.setEnabled(true);
        return scriptTask;
    }

    private ScriptTask runScriptTask(String scriptName, String scriptExtension, String scriptContent, Form config) throws ScriptException {
        this.kernel.registerBean(scriptName).asClass(ScriptTask.class).exec();
        ScriptTask scriptTask = (ScriptTask)this.kernel.getInstance(scriptName);
        scriptTask.setScript(scriptContent, scriptExtension);
        scriptTask.setNewConfiguration(config);
        return scriptTask;
    }

    private ScriptTimerTask runScriptTimerTask(String scriptName, String scriptExtension, String scriptContent, Form config) throws ScriptException {
        this.kernel.registerBean(scriptName).asClass(ScriptTimerTask.class).exec();
        ScriptTimerTask scriptTask = (ScriptTimerTask)this.kernel.getInstance(scriptName);
        scriptTask.setScript(scriptContent, scriptExtension);
        scriptTask.setNewConfiguration(config);
        return scriptTask;
    }

    private ScriptTimerTask runScriptTimerTask(String scriptName, String scriptExtension, String scriptContent, Long delay) throws ScriptException {
        this.kernel.registerBean(scriptName).asClass(ScriptTimerTask.class).exec();
        ScriptTimerTask scriptTask = (ScriptTimerTask)this.kernel.getInstance(scriptName);
        scriptTask.setScript(scriptContent, scriptExtension);
        scriptTask.setPeriod(delay);
        scriptTask.setEnabled(true);
        return scriptTask;
    }

    private void saveScript(TaskConfigItem.Type type, String scriptName, String scriptExtension, String scriptContent, Form configuration) {
        TaskConfigItem item = new TaskConfigItem();
        item.setTaskName(scriptName);
        item.setConfiguration(configuration);
        item.setScriptExtension(scriptExtension);
        item.setTaskScript(scriptContent);
        item.setType(type);
        try {
            this.repo.addItem(item);
        }
        catch (TigaseDBException e) {
            e.printStackTrace();
        }
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public void setRepo(ComponentRepository<TaskConfigItem> repo) {
        this.repo = repo;
        this.repo.addRepoChangeListener(new RepositoryChangeListenerIfc<TaskConfigItem>(){

            @Override
            public void itemAdded(TaskConfigItem item) {
                if (!TasksScriptRegistrar.this.kernel.isBeanClassRegistered(item.getTaskName())) {
                    try {
                        TasksScriptRegistrar.this.initTaskFromTaskConfig(item);
                    }
                    catch (Exception e) {
                        TasksScriptRegistrar.this.log.log(Level.WARNING, "Problem during initializing task", e);
                    }
                }
            }

            @Override
            public void itemRemoved(TaskConfigItem item) {
                try {
                    TasksScriptRegistrar.this.kernel.unregister(item.getTaskName());
                }
                catch (Exception e) {
                    TasksScriptRegistrar.this.log.log(Level.WARNING, "Problem during unregistering task", e);
                }
            }

            @Override
            public void itemUpdated(TaskConfigItem item) {
                try {
                    MonitorTask task = (MonitorTask)TasksScriptRegistrar.this.kernel.getInstance(item.getTaskName());
                    if (task instanceof ConfigurableTask) {
                        ((ConfigurableTask)((Object)task)).setNewConfiguration(item.getConfiguration());
                    }
                }
                catch (Exception e) {
                    TasksScriptRegistrar.this.log.log(Level.WARNING, "Problem during configuring task", e);
                }
            }
        });
    }

    public void updateConfig(String taskName, Form form) {
        MonitorTask task = (MonitorTask)this.kernel.getInstance(taskName);
        TaskConfigItem item = this.repo.getItem(taskName);
        if (item == null) {
            item = new TaskConfigItem();
            item.setTaskName(taskName);
            if (task instanceof ScriptTimerTask) {
                item.setType(TaskConfigItem.Type.scriptTimerTask);
                item.setScriptExtension(((ScriptTimerTask)task).getScriptExtension());
                item.setTaskScript(((ScriptTimerTask)task).getScript());
            } else if (task instanceof ScriptTask) {
                item.setType(TaskConfigItem.Type.scriptTask);
                item.setScriptExtension(((ScriptTask)task).getScriptExtension());
                item.setTaskScript(((ScriptTask)task).getScript());
            } else {
                item.setType(TaskConfigItem.Type.task);
                item.setTaskClass(task.getClass());
            }
        }
        item.setConfiguration(form);
        try {
            this.repo.addItem(item);
        }
        catch (TigaseDBException e) {
            e.printStackTrace();
        }
    }
}

