/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel.core;

import java.util.logging.Logger;
import tigase.kernel.KernelException;
import tigase.kernel.Registrar;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.DependencyManager;
import tigase.kernel.core.Kernel;

public class BeanConfigBuilder {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final String beanName;
    private final DependencyManager dependencyManager;
    private final Kernel kernel;
    private BeanConfig beanConfig;
    private Object beanInstance;
    private BeanConfig factoryBeanConfig;
    private Class<?> clazz;

    BeanConfigBuilder(Kernel kernel, DependencyManager dependencyManager, String beanName) {
        this.kernel = kernel;
        this.dependencyManager = dependencyManager;
        this.beanName = beanName;
    }

    public BeanConfigBuilder asClass(Class<?> cls) {
        this.clazz = cls;
        if (this.beanConfig != null) {
            this.throwException(new KernelException("Class or instance is already defined for bean '" + this.beanName + "'"));
        }
        this.beanConfig = this.dependencyManager.createBeanConfig(this.kernel, this.beanName, cls);
        return this;
    }

    public BeanConfigBuilder asInstance(Object bean) {
        if (this.beanConfig != null) {
            this.throwException(new KernelException("Class or instance is already defined for bean '" + this.beanName + "'"));
        }
        this.beanConfig = this.dependencyManager.createBeanConfig(this.kernel, this.beanName, bean.getClass());
        this.beanInstance = bean;
        return this;
    }

    public void exec() {
        if (this.beanConfig == null) {
            this.log.warning("Bean " + this.clazz + " cannot be registered, because Kernel cannot create configuration for this bean.");
            return;
        }
        if (this.factoryBeanConfig != null) {
            this.kernel.unregisterInt(this.factoryBeanConfig.getBeanName());
            this.dependencyManager.register(this.factoryBeanConfig);
        }
        this.kernel.unregisterInt(this.beanConfig.getBeanName());
        this.dependencyManager.register(this.beanConfig);
        if (this.beanInstance != null) {
            this.kernel.putBeanInstance(this.beanConfig, this.beanInstance);
        }
        this.kernel.currentlyUsedConfigBuilder = null;
        this.kernel.injectIfRequired(this.beanConfig);
        for (BeanConfig rbc : this.kernel.getDependencyManager().getBeanConfigs(Registrar.class)) {
            this.kernel.getInstance(rbc.getBeanName());
        }
    }

    public BeanConfigBuilder exportable() {
        this.beanConfig.setExportable(true);
        return this;
    }

    public String getBeanName() {
        return this.beanName;
    }

    protected void throwException(KernelException e) {
        this.kernel.currentlyUsedConfigBuilder = null;
        throw e;
    }

    public BeanConfigBuilder withFactory(Class<?> beanFactoryClass) {
        if (this.beanInstance != null) {
            this.throwException(new KernelException("Cannot register factory to bean '" + this.beanName + "' registered as instance."));
        }
        if (this.factoryBeanConfig != null) {
            this.throwException(new KernelException("Factory for bean '" + this.beanName + "' is already registered."));
        }
        this.factoryBeanConfig = this.dependencyManager.createBeanConfig(this.kernel, this.beanName + "#FACTORY", beanFactoryClass);
        this.beanConfig.setFactory(this.factoryBeanConfig);
        return this;
    }
}

