/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel.beans.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tigase.kernel.BeanUtils;
import tigase.kernel.KernelException;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.BeanConfigurator;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.DependencyManager;
import tigase.kernel.core.Kernel;

public abstract class AbstractBeanConfigurator
implements BeanConfigurator {
    private final ConcurrentHashMap<BeanConfig, HashMap<Field, Object>> defaultFieldValues = new ConcurrentHashMap();
    @Inject(nullAllowed=false)
    private Kernel kernel;

    @Override
    public void configure(BeanConfig beanConfig, Object bean) throws KernelException {
        try {
            Field[] fields;
            Map<String, Object> ccc = this.getConfiguration(beanConfig);
            HashMap<Field, Object> defaultConfig = this.defaultFieldValues.get(beanConfig);
            if (defaultConfig == null) {
                defaultConfig = new HashMap();
                this.defaultFieldValues.put(beanConfig, defaultConfig);
            }
            for (Field field : fields = DependencyManager.getAllFields(beanConfig.getClazz())) {
                ConfigField configField = field.getAnnotation(ConfigField.class);
                if (configField == null) continue;
                Object currentValue = BeanUtils.getValue(bean, field);
                if (!this.defaultFieldValues.contains(field)) {
                    defaultConfig.put(field, currentValue);
                }
                if (!ccc.containsKey(field.getName())) continue;
                Object valueToSet = ccc.get(field.getName());
                Method setter = BeanUtils.prepareSetterMethod(field);
                if (setter != null) {
                    setter.invoke(bean, valueToSet);
                    continue;
                }
                field.setAccessible(true);
                field.set(bean, valueToSet);
            }
        }
        catch (Exception e) {
            throw new KernelException("Cannot inject configuration to bean " + beanConfig.getBeanName(), e);
        }
    }

    protected abstract Map<String, Object> getConfiguration(BeanConfig var1);

    public Kernel getKernel() {
        return this.kernel;
    }

    public void restoreDefaults(String beanName) {
        BeanConfig beanConfig = this.kernel.getDependencyManager().getBeanConfig(beanName);
        Object bean = this.kernel.getInstance(beanName);
        try {
            Field[] fields;
            HashMap<Field, Object> defaultConfig = this.defaultFieldValues.get(beanConfig);
            if (defaultConfig == null) {
                return;
            }
            for (Field field : fields = DependencyManager.getAllFields(beanConfig.getClazz())) {
                ConfigField configField = field.getAnnotation(ConfigField.class);
                if (configField == null || !defaultConfig.containsKey(field)) continue;
                Object valueToSet = defaultConfig.get(field);
                Method setter = BeanUtils.prepareSetterMethod(field);
                if (setter != null) {
                    setter.invoke(bean, valueToSet);
                    continue;
                }
                field.setAccessible(true);
                field.set(bean, valueToSet);
            }
        }
        catch (Exception e) {
            throw new KernelException("Cannot inject configuration to bean " + beanConfig.getBeanName(), e);
        }
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }
}

