/*
 * Decompiled with CFR 0.152.
 */
package tigase.form;

import java.util.List;
import java.util.logging.Level;
import tigase.form.AbstractForm;
import tigase.form.Field;
import tigase.form.Fields;
import tigase.xml.Element;

public class Form
extends AbstractForm {
    protected Fields fields = new Fields();

    public Form(Element form) {
        super(form);
        List<Element> children = form.getChildren();
        if (children != null) {
            for (Element sub : children) {
                if (!"field".equals(sub.getName())) continue;
                Field field = new Field(sub);
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("read Data Form field [" + field.getVar() + "]");
                }
                this.fields.addField(field);
            }
        }
    }

    public Form(String type, String title, String instruction) {
        super(type, title, instruction);
    }

    public void addField(Field field) {
        this.fields.addField(field);
    }

    public void clear() {
        this.fields.clear();
    }

    public void copyValuesFrom(Element form) {
        this.log.finest("Copying values from form ");
        List<Element> children = form.getChildren();
        if (children != null) {
            for (Element sub : children) {
                if (!"field".equals(sub.getName())) continue;
                Field field = new Field(sub);
                Field f = this.fields.get(field.getVar());
                if (f != null) {
                    f.setValues(field.getValues());
                    continue;
                }
                if (!this.log.isLoggable(Level.FINER)) continue;
                this.log.finer("Field " + field.getVar() + " is not declared in form '" + this.title + "'!");
            }
        }
    }

    public void copyValuesFrom(Form form) {
        for (Field field : form.fields.getAllFields()) {
            Field f = this.fields.get(field.getVar());
            if (f != null) {
                f.setValues(field.getValues());
                continue;
            }
            if (!this.log.isLoggable(Level.FINER)) continue;
            this.log.finer("Field " + field.getVar() + " is not declared in form '" + this.title + "'!");
        }
    }

    public Field get(String var) {
        return this.fields.get(var);
    }

    public List<Field> getAllFields() {
        return this.fields.getAllFields();
    }

    public Boolean getAsBoolean(String var) {
        return this.fields.getAsBoolean(var);
    }

    public Integer getAsInteger(String var) {
        return this.fields.getAsInteger(var);
    }

    public Long getAsLong(String var) {
        return this.fields.getAsLong(var);
    }

    public String getAsString(String var) {
        return this.fields.getAsString(var);
    }

    public String[] getAsStrings(String var) {
        return this.fields.getAsStrings(var);
    }

    @Override
    public Element getElement() {
        Element form = super.getElement();
        for (Field field : this.fields.getAllFields()) {
            form.addChild(field.getElement());
        }
        return form;
    }

    @Override
    public String getInstruction() {
        return this.instruction;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTypeOrElse(String defValue) {
        if (this.type == null) {
            return defValue;
        }
        return this.type;
    }

    public boolean is(String var) {
        return this.fields.is(var);
    }

    @Override
    public boolean isType(String type) {
        return this.type != null && this.type.equals(type);
    }

    public void removeField(String var) {
        this.fields.removeField(var);
    }

    @Override
    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "Form{fields=" + this.fields + '}';
    }
}

