/*
 * Decompiled with CFR 0.152.
 */
package tigase.disteventbus.component;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import tigase.component.exceptions.ComponentException;
import tigase.component.responses.AsyncCallback;
import tigase.criteria.Criteria;
import tigase.disteventbus.EventHandler;
import tigase.disteventbus.component.AbstractEventBusModule;
import tigase.disteventbus.component.ElemPathCriteria;
import tigase.disteventbus.component.EventBusContext;
import tigase.disteventbus.component.NodeNameUtil;
import tigase.disteventbus.component.stores.Subscription;
import tigase.disteventbus.impl.EventName;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class UnsubscribeModule
extends AbstractEventBusModule {
    public static final String ID = "unsubscribe";
    private static final Criteria CRIT = new ElemPathCriteria(new String[]{"iq", "pubsub", "unsubscribe"}, new String[]{null, "http://jabber.org/protocol/pubsub", null});
    private final EventHandler eventBusHandlerRemovedHandler = new EventHandler(){
        private final String[] NAME_PATH = new String[]{"HandlerRemoved", "name"};
        private final String[] XMLNS_PATH = new String[]{"HandlerRemoved", "xmlns"};

        @Override
        public void onEvent(String name, String xmlns, Element event) {
            String n = event.getCData(this.NAME_PATH);
            String x = event.getCData(this.XMLNS_PATH);
            if (x == null || !x.equals("tigase:eventbus:internal:events:0")) {
                UnsubscribeModule.this.onRemoveHandler(n, x);
            }
        }
    };

    @Override
    public void afterRegistration() {
        super.afterRegistration();
        ((EventBusContext)this.context).getEventBusInstance().addHandler("HandlerRemoved", "tigase:eventbus:internal:events:0", this.eventBusHandlerRemovedHandler);
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#subscribe"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    protected void onRemoveHandler(String eventName, String eventXmlns) {
        boolean listenedByHandlers = ((EventBusContext)this.context).getEventBusInstance().hasHandlers(eventName, eventXmlns);
        if (!listenedByHandlers) {
            for (JID node : ((EventBusContext)this.context).getConnectedNodes()) {
                Element se = this.prepareUnsubscribeElement(new EventName(eventName, eventXmlns), ((EventBusContext)this.context).getComponentID(), null);
                this.sendUnsubscribeRequest("eventbus@" + node.getDomain(), Collections.singleton(se));
            }
        }
    }

    private Element prepareUnsubscribeElement(EventName event, JID jid, String service) {
        Element subscribeElem = new Element(ID);
        subscribeElem.addAttribute("node", event.toEventBusNode());
        subscribeElem.addAttribute("jid", jid.toString());
        if (service != null) {
            subscribeElem.addChild(new Element("service", service));
        }
        return subscribeElem;
    }

    @Override
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        if (packet.getType() != StanzaType.set) {
            throw new ComponentException(Authorization.NOT_ALLOWED);
        }
        this.processSet(packet);
    }

    private void processSet(Packet packet) throws TigaseStringprepException {
        List<Element> unsubscribeElements = packet.getElemChildrenStaticStr(new String[]{"iq", "pubsub"});
        if (this.isClusteredEventBus(packet.getStanzaFrom())) {
            for (Element unsubscribe : unsubscribeElements) {
                EventName parsedName = NodeNameUtil.parseNodeName(unsubscribe.getAttributeStaticStr("node"));
                JID jid = JID.jidInstance(unsubscribe.getAttributeStaticStr("jid"));
                ((EventBusContext)this.context).getSubscriptionStore().removeSubscription(parsedName.getName(), parsedName.getXmlns(), new Subscription(jid));
            }
        } else {
            HashSet<Element> subscribedNodes = new HashSet<Element>();
            for (Element subscribe : unsubscribeElements) {
                EventName parsedName = NodeNameUtil.parseNodeName(subscribe.getAttributeStaticStr("node"));
                JID jid = JID.jidInstance(subscribe.getAttributeStaticStr("jid"));
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Entity " + jid + " subscribed for events " + parsedName);
                }
                ((EventBusContext)this.context).getSubscriptionStore().removeSubscription(parsedName.getName(), parsedName.getXmlns(), new Subscription(jid, packet.getStanzaTo()));
                subscribedNodes.add(this.prepareUnsubscribeElement(parsedName, jid, packet.getStanzaTo().toString()));
            }
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Forwarding unsubcribe to: " + ((EventBusContext)this.context).getConnectedNodes());
            }
            for (JID node : ((EventBusContext)this.context).getConnectedNodes()) {
                this.sendUnsubscribeRequest("eventbus@" + node.getDomain(), subscribedNodes);
            }
        }
        Packet response = packet.okResult((Element)null, 0);
        response.setPermissions(Permissions.ADMIN);
        this.write(response);
    }

    protected void sendUnsubscribeRequest(String to, Collection<Element> subscriptionElement) {
        try {
            Element iq = new Element("iq", new String[]{"from", "to", "type", "id"}, new String[]{((EventBusContext)this.context).getComponentID().toString(), to, "set", this.nextStanzaID()});
            Element pubsubElem = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
            iq.addChild(pubsubElem);
            for (Element node : subscriptionElement) {
                pubsubElem.addChild(node);
            }
            Packet packet = Packet.packetInstance(iq);
            packet.setPermissions(Permissions.ADMIN);
            packet.setXMLNS("jabber:client");
            this.write(packet, new AsyncCallback(){

                @Override
                public void onError(Packet responseStanza, String errorCondition) {
                }

                @Override
                public void onSuccess(Packet responseStanza) {
                }

                @Override
                public void onTimeout() {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void unregisterModule() {
        ((EventBusContext)this.context).getEventBusInstance().removeHandler("HandlerRemoved", "tigase:eventbus:internal:events:0", this.eventBusHandlerRemovedHandler);
        super.unregisterModule();
    }
}

